/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.model;

import de.datomino.peppergis.client.communication.WageCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.model.AbstractTimeObjectBucketModel;
import de.datomino.peppergis.client.manager.model.TimeExtractor;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.wage.HistoryAreaTourSearchDto;
import de.datomino.peppergis.wage.ProductWeightParameter;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.swing.blocking.BusyHandler;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AreaDelivererHistoryTourBucketModel
extends AbstractTimeObjectBucketModel<HistoryAreaTourModelWageResult, AreaDelivererModel> {
    private ModelEnviroment modelEnviroment;
    private ProductWeightParameter productWeightParameter;

    public AreaDelivererHistoryTourBucketModel(ModelEnviroment modelEnviroment, int dayDimension, BusyHandler busyHandler) {
        super(AreaDelivererHistoryTourBucketModel.createTimeExtractor(), dayDimension, busyHandler);
        this.modelEnviroment = modelEnviroment;
        this.productWeightParameter = this.modelEnviroment.getAllCaller().getWageCaller().getProductWeightParameter();
    }

    private static TimeExtractor<HistoryAreaTourModelWageResult> createTimeExtractor() {
        return new TimeExtractor<HistoryAreaTourModelWageResult>(){

            @Override
            public Date getTime(HistoryAreaTourModelWageResult tour) {
                return tour.getModel().getDate();
            }
        };
    }

    @Override
    protected Map<AreaDelivererModel, Collection<HistoryAreaTourModelWageResult>> callback(Collection<AreaDelivererModel> ts, Date startTime, Date endTime) {
        WageCaller wageCaller = this.modelEnviroment.getAllCaller().getWageCaller();
        HashSet<AreaDelivererDto> delivererDtos = new HashSet<AreaDelivererDto>();
        CollectionUtil.transform(ts, delivererDtos, new Transformer<AreaDelivererModel, AreaDelivererDto>(){

            @Override
            public AreaDelivererDto transform(AreaDelivererModel t) {
                return (AreaDelivererDto)((Object)t.createProxy());
            }
        });
        HistoryAreaTourSearchDto searchDto = new HistoryAreaTourSearchDto(null, null, startTime, endTime, delivererDtos);
        List<HistoryAreaTourModel> histories = wageCaller.searchHistoryAreaTours(searchDto);
        HashMap<AreaDelivererModel, Collection<HistoryAreaTourModelWageResult>> map = new HashMap<AreaDelivererModel, Collection<HistoryAreaTourModelWageResult>>();
        for (AreaDelivererModel t : ts) {
            HashSet<HistoryAreaTourModelWageResult> value = (HashSet<HistoryAreaTourModelWageResult>)map.get(t);
            if (value == null) {
                value = new HashSet<HistoryAreaTourModelWageResult>();
                map.put(t, value);
            }
            value.addAll(this.findHsitories(histories, t));
        }
        return map;
    }

    private Collection<HistoryAreaTourModelWageResult> findHsitories(Collection<HistoryAreaTourModel> histories, AreaDelivererModel t) {
        HashSet<HistoryAreaTourModelWageResult> found = new HashSet<HistoryAreaTourModelWageResult>();
        for (HistoryAreaTourModel history : histories) {
            if (history.getDeliverer() == null || !history.getDeliverer().equals(t)) continue;
            found.add(new HistoryAreaTourModelWageResult(history, this.productWeightParameter, this.modelEnviroment.getAllCaller().getTourCaller()));
        }
        return found;
    }

    public Collection<HistoryAreaTourModelWageResult> findObjects(AreaDelivererModel deliverer, Date startTime, Date endTime) {
        Map bucketMap = super.findBuckets(CollectionUtil.buildHashSet(deliverer), startTime, endTime);
        HashSet<HistoryAreaTourModelWageResult> found = new HashSet<HistoryAreaTourModelWageResult>();
        for (HistoryAreaTourModelWageResult result : bucketMap.get(deliverer)) {
            HistoryAreaTourModel history = result.getModel();
            Date date = history.getDate();
            if (history.isDeleted() || date == null || !date.equals(startTime) && !date.after(startTime) || !date.before(endTime)) continue;
            found.add(result);
        }
        return found;
    }
}

