/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.listener;

import de.datomino.peppergis.areamanager.gui.AreaDelivererDialog;
import de.datomino.peppergis.areamanager.gui.AreaDelivererTreeGui;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.gui.AreaSchedulePlanTable;
import de.datomino.peppergis.areamanager.model.AreaScheduleTimeBucketModel;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.areamanager.util.AreaTourScheduleModelUtil;
import de.datomino.peppergis.client.deliveryRound.AreaDeliveryRoundDialog;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.tour.AbstractDelivererTimeIntervalDialog;
import de.datomino.peppergis.client.manager.model.DelivererTransferable;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModelImpl;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.client.wage.HistoryAreaTourDialog;
import de.datomino.peppergis.type.ComponentType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.type.WeekDay;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.collections.IteratorUtils;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class SchedulePlanTableListener
extends DefaultMouseManipulator
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private AreaSchedulePlanTable planTablePane;
    private AreaDelivererTreeGui delivererGui;
    private AreaManagerCalendarGui areaManager;
    private boolean editable;
    private boolean wageEnabled;

    public SchedulePlanTableListener(AreaManagerCalendarGui areaManager) {
        this.planTablePane = areaManager.getPlanTablePane();
        this.delivererGui = areaManager.getDelivererGui();
        this.areaManager = areaManager;
        this.editable = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.PERSONAL_PLANNER, UserRole.DISPONENT_SUPER);
        ModelEnviroment modelEnviroment = this.areaManager.getModelEnviroment();
        this.wageEnabled = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE, UserRole.WAGE_PASSIVE, UserRole.WAGE_DIFFERENCE) && modelEnviroment.getAllCaller().getUserCaller().isComponentEnabled(ComponentType.WAGE_TOOL);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point dropLoc = dtde.getLocation();
        JTable planTable = this.planTablePane.getPlanTable();
        final int dropRow = planTable.rowAtPoint(dropLoc);
        final int dropCol = planTable.columnAtPoint(dropLoc);
        JTree delivererJTree = this.delivererGui.getDelivererJTree();
        int selTreeIndex = delivererJTree.getLeadSelectionRow();
        final AreaDelivererModel deliverer = (AreaDelivererModel)this.areaManager.getDelivererGui().getSelectedObject();
        delivererJTree.clearSelection();
        if (!dtde.isDataFlavorSupported(DelivererTransferable.getDataFlavor()) || !this.isAllowedDrop(dtde, dropRow, dropCol, selTreeIndex)) {
            dtde.rejectDrop();
            return;
        }
        dtde.acceptDrop(3);
        AreaObjectModel dropArea = (AreaObjectModel)planTable.getValueAt(dropRow, 0);
        final DeliveryRoundSelectionPane roundSelectionPane = new DeliveryRoundSelectionPane(dropArea);
        AbstractDelivererTimeIntervalDialog timeWindowDialog = new AbstractDelivererTimeIntervalDialog(planTable, roundSelectionPane, "messages.default.timewindow"){
            private static final long serialVersionUID = 5588858544408798726L;

            @Override
            protected void setTimeWindow(Set<Tupel<Date, Date>> timeWindows) {
                SchedulePlanTableListener.this.fireScheduleChanged(dropRow, dropCol, deliverer, timeWindows, roundSelectionPane.selectionMap);
            }
        };
        timeWindowDialog.setVisible(true);
        dtde.dropComplete(true);
    }

    private void fireScheduleChanged(int dropRow, int dropCol, AreaDelivererModel deliverer, Set<Tupel<Date, Date>> timeWindows, Map<WeekDay, Collection<Tupel<DeliveryRoundRelationModel, Boolean>>> roundMap) {
        JTable planTable = this.planTablePane.getPlanTable();
        Date dropDate = this.planTablePane.getDateFromColumn(dropCol);
        AreaObjectModel dropArea = (AreaObjectModel)planTable.getValueAt(dropRow, 0);
        AreaScheduleTimeBucketModel scheduleBucketModel = this.areaManager.getScheduleBucketModel();
        UndoManager undoManager = this.areaManager.getActions().getUndoManager();
        undoManager.startTransaction();
        LinkedList<Tupel<Date, DeliveryRoundRelationModel>> setDataList = new LinkedList<Tupel<Date, DeliveryRoundRelationModel>>();
        for (Tupel<Date, Date> timeWindow : timeWindows) {
            Date date;
            Calendar c = Calendar.getInstance();
            c.setTime(TimeUtil.normalize(timeWindow.getElement1()));
            while (!(date = c.getTime()).after(timeWindow.getElement2()) && !date.equals(timeWindow.getElement2())) {
                WeekDay weekDay = WeekDay.valueOf(c.get(7));
                Collection<Tupel<DeliveryRoundRelationModel, Boolean>> rounds = roundMap.get((Object)weekDay);
                if (rounds != null) {
                    for (Tupel<DeliveryRoundRelationModel, Boolean> tupel : rounds) {
                        if (!tupel.getElement2().booleanValue()) continue;
                        DeliveryRoundRelationModel selectedRound = tupel.getElement1();
                        Tupel<AreaScheduleEntity, AreaTourScheduleModel> found = this.findSchedule(dropArea, date, selectedRound);
                        AreaTourScheduleModel schedule = found.getElement2();
                        if (schedule == null) {
                            schedule = new AreaTourScheduleModelImpl();
                            schedule.setPlannedStartTime(date);
                            schedule.setAreaObject(dropArea);
                            schedule.setDeliveryRound(selectedRound);
                            AreaScheduleEntity entity = found.getElement1();
                            if (entity == null) {
                                entity = new AreaScheduleEntity(dropArea, date, CollectionUtil.buildHashSet(schedule), null, this.areaManager.getModelEnviroment());
                                scheduleBucketModel.addObject(dropArea, entity);
                                if (TimeUtil.isSamedWeek(dropDate, date)) {
                                    int column = this.planTablePane.getColumnIndex(date);
                                    planTable.setValueAt(entity, dropRow, column);
                                }
                            }
                            entity.getModel().add(schedule);
                        }
                        if (!deliverer.equals(schedule.getDeliverer())) {
                            this.removeOldSalary(deliverer, date);
                            if (schedule.getDeliverer() != null) {
                                this.removeOldSalary(schedule.getDeliverer(), date);
                            }
                            schedule.setDeliverer(deliverer);
                        }
                        setDataList.add(new Tupel<Date, DeliveryRoundRelationModel>(date, selectedRound));
                    }
                }
                c.add(5, 1);
            }
        }
        this.doHistoryAreaTours(deliverer, dropArea, setDataList);
        ((DefaultTableModel)planTable.getModel()).fireTableDataChanged();
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.areatour.updated", new Serializable[0]));
    }

    private void removeOldSalary(AreaDelivererModel deliverer, Date date) {
        Date firstMonthDate;
        Double d;
        Map<Date, Double> salaryMap = this.planTablePane.getSalaryForecastMap().get(deliverer);
        if (salaryMap != null && (d = salaryMap.get(firstMonthDate = TimeUtil.getMonthTupel(date).getElement1())) != null) {
            salaryMap.remove(firstMonthDate);
        }
    }

    private void doHistoryAreaTours(AreaDelivererModel deliverer, AreaObjectModel dropArea, List<Tupel<Date, DeliveryRoundRelationModel>> setDataList) {
        ArrayList<Tripel<AreaObjectModel, Date, DeliveryRoundRelationModel>> tripelList = new ArrayList<Tripel<AreaObjectModel, Date, DeliveryRoundRelationModel>>(setDataList.size());
        for (Tupel<Date, DeliveryRoundRelationModel> tupel : setDataList) {
            tripelList.add(new Tripel<AreaObjectModel, Date, DeliveryRoundRelationModel>(dropArea, tupel.getElement1(), tupel.getElement2()));
        }
        Collection<HistoryAreaTourModel> historyAreaTourList = this.areaManager.getModelEnviroment().getAllCaller().getWageCaller().getHistoryAreaTourForDelivererUpdate(tripelList);
        for (HistoryAreaTourModel historyAreaTour : historyAreaTourList) {
            historyAreaTour.setDeliverer(deliverer);
        }
        HashSet<HistoryAreaTourModel> hashSet = new HashSet<HistoryAreaTourModel>(historyAreaTourList);
        Collection allObject = this.areaManager.getScheduleBucketModel().getAllObject();
        LinkedList<HistoryAreaTourModelWageResult> toUpdate = new LinkedList<HistoryAreaTourModelWageResult>();
        for (AreaScheduleEntity areaScheduleEntity : allObject) {
            Collection<HistoryAreaTourModelWageResult> historyResults = areaScheduleEntity.getHistoryResult();
            for (HistoryAreaTourModelWageResult historyResult : historyResults) {
                HistoryAreaTourModel model = historyResult.getModel();
                if (model == null || !hashSet.contains(model)) continue;
                toUpdate.add(historyResult);
            }
        }
        for (HistoryAreaTourModelWageResult historyResult : toUpdate) {
            historyResult.refresh();
        }
    }

    private Tupel<AreaScheduleEntity, AreaTourScheduleModel> findSchedule(AreaObjectModel area, Date date, DeliveryRoundRelationModel round) {
        AreaScheduleTimeBucketModel scheduleBucketModel = this.areaManager.getScheduleBucketModel();
        Tupel<Date, Date> dayTupel = TimeUtil.getDayTupel(date);
        Map<AreaObjectModel, Collection<AreaScheduleEntity>> map = scheduleBucketModel.findObjects(CollectionUtil.buildHashSet(area), dayTupel.getElement1(), dayTupel.getElement2(), false);
        Tupel<Object, Object> found = new Tupel<Object, Object>(null, null);
        block0: for (AreaScheduleEntity entity : map.get(area)) {
            if (!TimeUtil.isSamedDay(entity.getDate(), date)) continue;
            found.setElement1(entity);
            for (AreaTourScheduleModel schedule : entity.getModel()) {
                if (!TimeUtil.isSamedDay(schedule.getPlannedStartTime(), date) || round != null && !round.equals(schedule.getDeliveryRound())) continue;
                found.setElement2(schedule);
                break block0;
            }
        }
        return found;
    }

    private boolean isAllowedDrop(DropTargetDropEvent dtde, int dropRow, int dropCol, int selTreeIndex) {
        if (!this.editable) {
            return false;
        }
        JDialog.setDefaultLookAndFeelDecorated(true);
        JRootPane parent = this.planTablePane.getPlanTable().getRootPane();
        if (dtde.isDataFlavorSupported(DelivererTransferable.getDataFlavor())) {
            AreaDelivererModel delivererTransferData;
            if (dropCol == 0) {
                ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.dropErrorDeliverer", new Serializable[0]), parent);
                return false;
            }
            try {
                delivererTransferData = (AreaDelivererModel)dtde.getTransferable().getTransferData(DelivererTransferable.getDataFlavor());
            }
            catch (Exception e) {
                return false;
            }
            boolean delivererActive = DelivererModelUtil.isDelivererActive(delivererTransferData, this.planTablePane.getDateFromColumn(dropCol));
            if (!delivererActive) {
                ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.message.dropInactiveDeliverer", new Serializable[0]), parent);
            }
            return delivererActive;
        }
        return true;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        if (this.planTablePane.isInTable(dsde.getLocation())) {
            context.setCursor(DragSource.DefaultMoveDrop);
        } else {
            context.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
        int column;
        Point point;
        int row;
        Object selObject;
        JTable planTable = this.planTablePane.getPlanTable();
        if (mouseButton == MouseButton.BUTTON1) {
            Object selObject2 = this.planTablePane.getSelObject();
            if (selObject2 != null) {
                if (selObject2 instanceof AreaScheduleEntity) {
                    AreaScheduleEntity schedule = (AreaScheduleEntity)selObject2;
                    if (clickCount == 2 && this.wageEnabled) {
                        if (schedule.getHistoryResult().isEmpty()) {
                            JOptionPane.showMessageDialog(this.areaManager, ModelEnviroment.getMessageResolver().resolveMessage("gui.area.schedule.noHistoryTour", new Serializable[0]));
                        } else {
                            HistoryAreaTourDialog.createAndShow(new ArrayList<HistoryAreaTourModelWageResult>(schedule.getHistoryResult()), this.areaManager.getModelEnviroment(), SwingUtils.findWindowParent(planTable));
                        }
                    } else if (clickCount == 1) {
                        if ((modifiers & 2) <= 0) {
                            this.planTablePane.clearSelectedObjects();
                        }
                        this.planTablePane.updateMarkSet(schedule, planTable.getSelectedRow(), planTable.getSelectedColumn());
                    }
                } else if (selObject2 instanceof AreaObjectModel) {
                    AreaObjectModel areaObject = (AreaObjectModel)selObject2;
                    if (clickCount == 2 && areaObject.iterateAreaDeliveryRounds().hasNext() && this.wageEnabled) {
                        AreaDeliveryRoundDialog.createAndShow(IteratorUtils.toList(areaObject.iterateAreaDeliveryRounds()), this.areaManager.getModelEnviroment(), SwingUtils.findWindowParent(planTable));
                    }
                }
            } else {
                this.planTablePane.clearSelectedObjects();
            }
        } else if (mouseButton == MouseButton.BUTTON3 && this.editable && (selObject = this.planTablePane.getObjectInTable(row = planTable.rowAtPoint(point = new Point(x, y)), column = planTable.columnAtPoint(point))) instanceof AreaScheduleEntity) {
            AreaScheduleEntity entity = (AreaScheduleEntity)selObject;
            this.planTablePane.clearSelectedObjects();
            this.planTablePane.updateMarkSet(entity, row, column);
            JPopupMenu popupMenu = new JPopupMenu();
            if (entity.getHistoryResult().isEmpty() && this.wageEnabled) {
                popupMenu.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.schedule.noHistoryTour", new Serializable[0]));
            }
            String deleteString = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]) + " - ";
            HashSet<AreaDelivererModel> deliverers = new HashSet<AreaDelivererModel>();
            for (final AreaTourScheduleModel schedule : entity.getModel()) {
                final AreaDelivererModel deliverer = schedule.getDeliverer();
                if (deliverer != null) {
                    deliverers.add(deliverer);
                }
                String actionName = deleteString + AreaTourScheduleModelUtil.getDisplayForTable(schedule, " - ");
                popupMenu.add(new AbstractAction(actionName){
                    private static final long serialVersionUID = 8366710894546123519L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModelEnviroment modelEnviroment = SchedulePlanTableListener.this.areaManager.getModelEnviroment();
                        UndoManager undoManager = modelEnviroment.getUndoManager();
                        undoManager.startTransaction();
                        schedule.delete();
                        undoManager.finishTransaction("Zustelltour-Plan gel\u00f6scht - " + AreaTourScheduleModelUtil.getDisplayForTable(schedule, " - "));
                        SchedulePlanTableListener.this.planTablePane.createPlanTable();
                    }
                });
            }
            String historyString = ModelEnviroment.getMessageResolver().resolveMessage("gui.areaDeliverer.history", new Serializable[0]) + " - ";
            for (final AreaDelivererModel deliverer : deliverers) {
                popupMenu.add(new AbstractAction(historyString + DelivererModelUtil.getDisplayString(deliverer)){
                    private static final long serialVersionUID = 8366710894546123519L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Window parent = SwingUtils.findWindowParent(SchedulePlanTableListener.this.areaManager);
                        new AreaDelivererDialog(parent, SchedulePlanTableListener.this.areaManager.getModelEnviroment(), deliverer, false, true, SchedulePlanTableListener.this.delivererGui.getBucket());
                    }
                });
            }
            popupMenu.show(planTable, x, y);
        }
        planTable.clearSelection();
        planTable.repaint(10L);
    }

    private class DeliveryRoundSelectionPane
    extends JPanel {
        private static final long serialVersionUID = -4507616863185040588L;
        private Map<WeekDay, Collection<Tupel<DeliveryRoundRelationModel, Boolean>>> selectionMap;

        private DeliveryRoundSelectionPane(AreaObjectModel area) {
            super(new SpringLayout());
            this.selectionMap = new HashMap<WeekDay, Collection<Tupel<DeliveryRoundRelationModel, Boolean>>>();
            for (AreaDeliveryRoundModel areaRound : area.iterableAreaDeliveryRounds()) {
                this.putRoundRelation(areaRound.getMonday(), WeekDay.MONDAY);
                this.putRoundRelation(areaRound.getTuesday(), WeekDay.TUESDAY);
                this.putRoundRelation(areaRound.getWednesday(), WeekDay.WEDNESDAY);
                this.putRoundRelation(areaRound.getThursday(), WeekDay.THURSDAY);
                this.putRoundRelation(areaRound.getFriday(), WeekDay.FRIDAY);
                this.putRoundRelation(areaRound.getSaturday(), WeekDay.SATURDAY);
                this.putRoundRelation(areaRound.getSunday(), WeekDay.SUNDAY);
            }
            this.initialize();
        }

        private void putRoundRelation(DeliveryRoundRelationModel relation, WeekDay weekDay) {
            if (relation == null) {
                return;
            }
            Collection<Tupel<DeliveryRoundRelationModel, Boolean>> value = this.selectionMap.get((Object)weekDay);
            if (value == null) {
                value = new HashSet<Tupel<DeliveryRoundRelationModel, Boolean>>();
                this.selectionMap.put(weekDay, value);
            }
            value.add(new Tupel<DeliveryRoundRelationModel, Boolean>(relation, false));
        }

        /*
         * WARNING - void declaration
         */
        private void initialize() {
            void var3_6;
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monday.short", new Serializable[0]), null, 0));
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.tuesday.short", new Serializable[0]), null, 0));
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.wednesday.short", new Serializable[0]), null, 0));
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.thursday.short", new Serializable[0]), null, 0));
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.friday.short", new Serializable[0]), null, 0));
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.saturday.short", new Serializable[0]), null, 0));
            this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.sunday.short", new Serializable[0]), null, 0));
            int rows = 0;
            for (Collection<Tupel<DeliveryRoundRelationModel, Boolean>> collection : this.selectionMap.values()) {
                if (collection.size() <= rows) continue;
                rows = collection.size();
            }
            ArrayList<JComponent> components = new ArrayList<JComponent>(rows++ * 7);
            for (WeekDay weekDay : WeekDay.values()) {
                HashSet value = this.selectionMap.get((Object)weekDay);
                value = value == null ? new HashSet() : value;
                ArrayList list = new ArrayList(value);
                Collections.sort(list, new StringComparator<Tupel<DeliveryRoundRelationModel, Boolean>>(true){

                    @Override
                    protected String getString(Tupel<DeliveryRoundRelationModel, Boolean> o) {
                        return o.getElement1().getDeliveryRound().getName();
                    }
                });
                for (final Tupel tupel : list) {
                    JCheckBox checkBox = new JCheckBox(new AbstractAction(((DeliveryRoundRelationModel)tupel.getElement1()).getDeliveryRound().getName()){
                        private static final long serialVersionUID = 5771530464467478950L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JCheckBox checkBox = (JCheckBox)e.getSource();
                            if (checkBox.isSelected()) {
                                tupel.setElement2(true);
                            } else {
                                tupel.setElement2(false);
                            }
                        }
                    });
                    components.add(checkBox);
                }
                for (int i = 0; i < rows - value.size(); ++i) {
                    JLabel comp = new JLabel("");
                    comp.setPreferredSize(new Dimension(150, 25));
                    components.add(comp);
                }
            }
            boolean bl = false;
            while (var3_6 < rows) {
                for (int y = 0; y < 7; ++y) {
                    this.add((Component)components.get(y * rows + var3_6));
                }
                ++var3_6;
            }
            SpringUtilities.makeCompactGrid(this, rows + 1, 7, 5, 5, 5, 5);
        }
    }
}

