/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.listener;

import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.gui.letter.LetterDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelDialog;
import de.datomino.peppergis.client.gui.poi.PoiDialog;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.util.NumericUtil;
import de.datomino.util.swing.SwingUtils;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.ktde.swing.navigator.DefaultMouseManipulator;

public class AreaLegendTreeListener
extends DefaultMouseManipulator {
    private AreaManagerMapGui mapGui;
    private Set<AreaStopNode<LegendObject<? extends Model>>> selectedStopNodes = new HashSet<AreaStopNode<LegendObject<? extends Model>>>();

    public AreaLegendTreeListener(AreaManagerMapGui mapGui) {
        this.mapGui = mapGui;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTree tree = this.mapGui.getAreaLegendTree();
        TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        if (e.getButton() == 3) {
            if (e.isControlDown() && !this.selectedStopNodes.isEmpty()) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem(ModelEnviroment.getMessageResolver().resolveMessage("messages.legend.chooseNumber", new Serializable[0]));
                menu.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String input = JOptionPane.showInputDialog(AreaLegendTreeListener.this.mapGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.legend.chooseNumber", new Serializable[0]), "Reihenfolge", 2);
                        if (input != null) {
                            AreaLegendTreeListener.this.insertToNewPosition(input);
                        }
                    }
                });
                menu.show(e.getComponent(), e.getX(), e.getY());
                menu.setVisible(true);
            }
        } else if (e.getButton() == 1) {
            AreaStopNode stopNode;
            LegendObject areaStop;
            Object o = this.getObjectFromLocation(e.getX(), e.getY());
            if (e.getClickCount() == 1) {
                if (o instanceof AreaObjectTourMapNode) {
                    AreaObjectTourMapNode tourNode = (AreaObjectTourMapNode)o;
                    Rectangle pathBounds = tree.getPathBounds(treePath);
                    if (pathBounds.getX() + pathBounds.getWidth() - (double)e.getX() < 20.0) {
                        this.mapGui.removeAreaTourMapNode(tourNode);
                    }
                } else if (o instanceof AreaStopNode && e.isControlDown() && e.getButton() == 1) {
                    AreaStopNode stopNode2 = (AreaStopNode)o;
                    if (this.selectedStopNodes.contains(stopNode2)) {
                        this.selectedStopNodes.remove(stopNode2);
                    } else {
                        TreeNode parent;
                        if (!this.selectedStopNodes.isEmpty() && !(parent = this.selectedStopNodes.iterator().next().getParent()).equals(stopNode2.getParent())) {
                            ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.legend.selectedIn2Areas", new Serializable[0]), this.mapGui);
                            return;
                        }
                        LegendObject stop = (LegendObject)stopNode2.getAreaStop();
                        if (stop.getM() instanceof PoiModel) {
                            ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.legend.poiSelectionNotAllowed", new Serializable[0]), this.mapGui);
                            return;
                        }
                        this.selectedStopNodes.add(stopNode2);
                    }
                    tree.repaint(10L);
                }
            } else if (o instanceof AreaStopNode && (areaStop = (LegendObject)(stopNode = (AreaStopNode)o).getAreaStop()) != null) {
                Model model = (Model)areaStop.getM();
                if (model instanceof PoiModel) {
                    PoiModel poi = (PoiModel)model;
                    PoiDialog poiDialog = new PoiDialog(SwingUtils.findWindowParent(this.mapGui), Collections.singletonList(poi), this.mapGui.getModelEnviroment());
                    poiDialog.setVisible(true);
                } else if (model instanceof SubscriptionModel) {
                    SubscriptionModel subscription = (SubscriptionModel)model;
                    SubscriptionDialog subscriptionDialog = new SubscriptionDialog(SwingUtils.findWindowParent(this.mapGui), Collections.singletonList(subscription), this.mapGui.getModelEnviroment());
                    PausableInternalFrame internalFrame = (PausableInternalFrame)((Object)SwingUtils.findInternalFrameParent(this.mapGui));
                    subscriptionDialog.setInternalFrame(internalFrame);
                    subscriptionDialog.setVisible(true);
                } else if (model instanceof ParcelModel) {
                    ParcelModel parcel = (ParcelModel)model;
                    ParcelDialog parcelDialog = new ParcelDialog(SwingUtils.findWindowParent(this.mapGui), parcel, Dialog.ModalityType.APPLICATION_MODAL, this.mapGui.getModelEnviroment(), false, false);
                    PausableInternalFrame internalFrame = (PausableInternalFrame)((Object)SwingUtils.findInternalFrameParent(this.mapGui));
                    parcelDialog.setInternalFrame(internalFrame);
                    parcelDialog.setVisible(true);
                } else if (model instanceof LetterModel) {
                    LetterModel letter = (LetterModel)model;
                    LetterDialog letterDialog = new LetterDialog(SwingUtils.findWindowParent(this.mapGui), Collections.singletonList(letter), this.mapGui.getModelEnviroment());
                    PausableInternalFrame internalFrame = (PausableInternalFrame)((Object)SwingUtils.findInternalFrameParent(this.mapGui));
                    letterDialog.setInternalFrame(internalFrame);
                    letterDialog.setVisible(true);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        AreaStopNode stopNode;
        LegendObject legendObject;
        Object o = this.getObjectFromLocation(this.pressedMouseEvent.getX(), this.pressedMouseEvent.getY());
        if (o instanceof AreaStopNode && !((legendObject = (LegendObject)(stopNode = (AreaStopNode)o).getUserObject()).getM() instanceof PoiModel)) {
            this.selectedStopNodes.clear();
            this.selectedStopNodes.add(stopNode);
            this.mapGui.getAreaLegendTree().setCursor(DragSource.DefaultMoveDrop);
            super.mouseDragged(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object o;
        if (this.dragged && !this.selectedStopNodes.isEmpty() && (o = this.getObjectFromLocation(e.getX(), e.getY())) instanceof AreaStopNode) {
            AreaStopNode toDrop = (AreaStopNode)o;
            TreeNode parent = this.selectedStopNodes.iterator().next().getParent();
            if (!parent.equals(toDrop.getParent())) {
                ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("gui.legend.dropInArea", new Serializable[0]), this.mapGui);
                return;
            }
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (!parent.getChildAt(i).equals(toDrop)) continue;
                this.insertToNewPosition(String.valueOf(i + 1));
                break;
            }
        }
        this.mapGui.getAreaLegendTree().setCursor(Cursor.getDefaultCursor());
        super.mouseReleased(e);
    }

    private void insertToNewPosition(String newPositionStr) {
        int newPosition = 0;
        try {
            newPosition = Integer.parseInt(newPositionStr);
        }
        catch (NumberFormatException ex) {
            ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("messages.error.numberFormatException", new Serializable[0]), this.mapGui);
            return;
        }
        ArrayList<AreaStopNode<LegendObject<? extends Model>>> inserted = new ArrayList<AreaStopNode<LegendObject<? extends Model>>>(this.selectedStopNodes);
        Collections.sort(inserted, new Comparator<AreaStopNode<LegendObject<? extends Model>>>(){

            @Override
            public int compare(AreaStopNode<LegendObject<? extends Model>> o1, AreaStopNode<LegendObject<? extends Model>> o2) {
                return NumericUtil.getIntegerValue(o1.getAreaStop().getSortOrder()) - NumericUtil.getIntegerValue(o2.getAreaStop().getSortOrder());
            }
        });
        ArrayList<AreaStopNode> startPoiNodes = new ArrayList<AreaStopNode>();
        ArrayList<AreaStopNode> remained = new ArrayList<AreaStopNode>();
        ArrayList<AreaStopNode> endPoiNodes = new ArrayList<AreaStopNode>();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((AreaStopNode)inserted.get(0)).getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AreaStopNode child = (AreaStopNode)parent.getChildAt(i);
            if (inserted.contains(child)) continue;
            if (((LegendObject)child.getAreaStop()).getM() instanceof PoiModel) {
                if (remained.isEmpty()) {
                    startPoiNodes.add(child);
                    continue;
                }
                endPoiNodes.add(child);
                continue;
            }
            remained.add(child);
        }
        if (newPosition < 1 || newPosition > parent.getChildCount()) {
            ErrorMessagesDialog.creatAndShow(ModelEnviroment.getMessageResolver().resolveMessage("messages.error.arrayIndexOutOfBoundsException", new Serializable[0]), this.mapGui);
            return;
        }
        ArrayList<AreaStopNode> list = new ArrayList<AreaStopNode>(remained);
        list.addAll(newPosition - 1, inserted);
        list.addAll(0, startPoiNodes);
        list.addAll(endPoiNodes);
        parent.removeAllChildren();
        for (AreaStopNode node : list) {
            parent.add(node);
        }
        this.selectedStopNodes.clear();
        this.mapGui.getChangedLogisticTourNodes().add((AreaObjectLogisticTourMapNode)parent.getParent());
        this.mapGui.repaintGui(false);
    }

    private Object getObjectFromLocation(int x, int y) {
        JTree tree = this.mapGui.getAreaLegendTree();
        TreePath treePath = tree.getPathForLocation(x, y);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    public Set<AreaStopNode<LegendObject<? extends Model>>> getSelectedStopNodes() {
        return this.selectedStopNodes;
    }
}

