/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.listener;

import de.datomino.peppergis.areamanager.gui.AreaDelivererDialog;
import de.datomino.peppergis.areamanager.gui.AreaDelivererTreeGui;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.BranchNode;
import de.datomino.peppergis.client.manager.model.AreaDelivererTreeModel;
import de.datomino.peppergis.client.manager.model.DelivererTransferable;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SwingUtils;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class AreaDelivererTreeListener
extends MouseAdapter
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private AreaManagerCalendarGui areaManager;

    public AreaDelivererTreeListener(AreaManagerCalendarGui tourManagerCaldendarGui) {
        this.areaManager = tourManagerCaldendarGui;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        BranchModel newBranch;
        AreaDelivererTreeGui delivererGui = this.areaManager.getDelivererGui();
        JTree tree = delivererGui.getDelivererJTree();
        DefaultMutableTreeNode selectedTreeNode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        tree.clearSelection();
        if (selectedTreeNode == null || !(selectedTreeNode.getUserObject() instanceof AreaDelivererModel)) {
            return;
        }
        AreaDelivererModel selected = (AreaDelivererModel)selectedTreeNode.getUserObject();
        DefaultMutableTreeNode branchTreeNode = null;
        TreePath dropPath = tree.getPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        DefaultMutableTreeNode dropTreeNode = (DefaultMutableTreeNode)dropPath.getLastPathComponent();
        if (dropTreeNode.getUserObject() instanceof BranchNode) {
            branchTreeNode = dropTreeNode;
        } else if (dropTreeNode.getUserObject() instanceof AreaDelivererModel) {
            branchTreeNode = (DefaultMutableTreeNode)dropTreeNode.getParent();
        }
        BranchModel branchModel = newBranch = branchTreeNode == null ? null : ((BranchNode)branchTreeNode.getUserObject()).getBranch();
        if (!(branchTreeNode == null || selected.getBranch() != null && selected.getBranch().equals(newBranch))) {
            UndoManager undoManager = this.areaManager.getActions().getUndoManager();
            undoManager.startTransaction();
            selected.setBranch(newBranch);
            undoManager.finishTransaction("Der Zusteller " + selected.getDelivererNumber() + " geh\u00f6rt zu der neuen Gruppe " + (newBranch == null ? "" : newBranch.getName()));
            AreaDelivererTreeModel treeModel = (AreaDelivererTreeModel)tree.getModel();
            treeModel.insertTreeNode(selectedTreeNode, branchTreeNode);
            tree.expandPath(new TreePath(branchTreeNode.getPath()));
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        DragSourceContext context = dsde.getDragSourceContext();
        if (this.areaManager.getPlanTablePane().isInTable(dsde.getLocation())) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else if (this.areaManager.getDelivererGui().isInTree(dsde.getLocation())) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Object object = this.areaManager.getDelivererGui().getSelectedObject();
        if (object != null && object instanceof AreaDelivererModel) {
            dge.startDrag(DragSource.DefaultCopyDrop, new DelivererTransferable<AreaDelivererModel>((AreaDelivererModel)object), this);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        AreaDelivererTreeGui delivererGui = this.areaManager.getDelivererGui();
        Object selTreeNode = delivererGui.getSelectedObject();
        if (selTreeNode != null && selTreeNode instanceof AreaDelivererModel && e.getClickCount() == 2 && !e.isConsumed()) {
            e.consume();
            boolean editable = ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER);
            new AreaDelivererDialog(SwingUtils.findWindowParent(this.areaManager), this.areaManager.getModelEnviroment(), (AreaDelivererModel)selTreeNode, editable, false, delivererGui.getBucket());
        }
        delivererGui.getDelivererJTree().clearSelection();
        this.areaManager.repaint(10L);
    }
}

