/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui.legend;

import de.datomino.peppergis.areamanager.gui.legend.AreaObjectMapAttributeNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AreaObjectTourMapNode<O>
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 6184463503482338630L;
    private AreaObjectModel area;
    private AreaObjectTourLegendType type;
    private AllObjectFilterLayerRenderer allObjectFilterLayerRenderer;
    private Color color;

    public AreaObjectTourMapNode(AreaObjectModel area, O o, AreaObjectTourLegendType type) {
        super(o);
        this.area = area;
        this.type = type;
    }

    protected abstract String getTourInfo(String var1);

    public abstract Integer getModelSum();

    public void addAttributeNodes() {
        DefaultMutableTreeNode info = new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]));
        this.add(info);
        info.add(new AreaObjectMapAttributeNode(this, AreaObjectMapAttribute.TOUR_TYPE, Color.BLACK));
        info.add(new AreaObjectMapAttributeNode(this, AreaObjectMapAttribute.DISTANCE, Color.BLACK));
        info.add(new AreaObjectMapAttributeNode(this, AreaObjectMapAttribute.DURATION, Color.BLACK));
        info.add(new AreaObjectMapAttributeNode(this, AreaObjectMapAttribute.DIFFICULTY_LEVEL, Color.BLACK));
        info.add(new AreaObjectMapAttributeNode(this, AreaObjectMapAttribute.PARCEL_LOCATION, Color.BLACK));
        info.add(new AreaObjectMapAttributeNode(this, AreaObjectMapAttribute.SUM, Color.BLACK));
    }

    public String getString() {
        return this.getTourInfo("%%%shortcut%%% - %%%displayname%%%\n%%%duration%%%\n%%%distance%%%\n%%%sum%%%\n%%%printDate%%%\n%%%cost_duration%%%\n%%%cost_distance%%%\n%%%cost_nightSurcharge%%%\n%%%cost_extraCharge%%%\n%%%cost_sum%%%");
    }

    public AreaObjectModel getAreaObject() {
        return this.area;
    }

    public AreaObjectTourLegendType getType() {
        return this.type;
    }

    public void setAllObjectFilterLayerRenderer(AllObjectFilterLayerRenderer allObjectFilterLayerRenderer) {
        this.allObjectFilterLayerRenderer = allObjectFilterLayerRenderer;
    }

    public AllObjectFilterLayerRenderer getAllObjectFilterLayerRenderer() {
        return this.allObjectFilterLayerRenderer;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public List<AreaStopNode<?>> getAllStopNodes() {
        ArrayList nodes = new ArrayList();
        this.getAllStopNodes(this, nodes);
        return nodes;
    }

    private void getAllStopNodes(TreeNode treeNode, List<AreaStopNode<?>> nodes) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode child = treeNode.getChildAt(i);
            if (child instanceof AreaStopNode) {
                nodes.add((AreaStopNode)child);
            }
            this.getAllStopNodes(child, nodes);
        }
    }

    public static enum AreaObjectMapAttribute {
        TOUR_TYPE,
        DISTANCE,
        DURATION,
        DIFFICULTY_LEVEL,
        PARCEL_LOCATION,
        SUM;

    }
}

