/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui.legend;

import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectTourMapNode;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.model.AreaTourExportModelsHolder;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.dto.exporter.AreaTourExportDto;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.LogisticTourResult;
import java.io.Serializable;
import java.util.Date;
import org.ktde.util.StringUtil;

public class AreaObjectLogisticTourMapNode
extends AreaObjectTourMapNode<AreaTourExportDto> {
    private static final long serialVersionUID = 2586701497520132794L;
    private AreaTourExportModelsHolder modelsHolder;
    private AreaTourParameter parameter;

    public AreaObjectLogisticTourMapNode(AreaObjectModel area, AreaTourExportDto exportDto, AreaTourParameter parameter, AreaTourExportModelsHolder modelsHolder) {
        super(area, exportDto, parameter.getRouteVehicleTypeInArea() == null ? null : AreaObjectTourLegendType.valueOf(parameter.getRouteVehicleTypeInArea().name()));
        this.modelsHolder = modelsHolder;
        this.parameter = parameter;
    }

    @Override
    public Integer getModelSum() {
        int sum = this.modelsHolder.getOrderedModels().size();
        sum += this.modelsHolder.getStartPois().size() + this.modelsHolder.getEndPois().size();
        return sum += this.modelsHolder.getStartPickPoints().size() + this.modelsHolder.getEndPickPoints().size();
    }

    @Override
    public String getTourInfo(String pattern) {
        String distanceString;
        if (pattern == null) {
            return this.getString();
        }
        AreaTourExportDto areaTourExportDto = (AreaTourExportDto)super.getUserObject();
        LogisticTourDto<PointEntityId> logisticTour = areaTourExportDto.getLogisticTourDto();
        LogisticTourResult logisticTourResult = logisticTour == null ? null : new LogisticTourResult(logisticTour);
        String string = ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]) + " - " + pattern;
        string = string.replaceAll("%%%shortcut%%%", StringUtil.getNotNull(this.getAreaObject().getShortcut()));
        string = string.replaceAll("%%%displayname%%%", StringUtil.getNotNull(this.getAreaObject().getDisplayname()));
        Integer duration = logisticTour == null ? null : logisticTour.getDurationSum();
        String durationString = duration == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.duration", new Serializable[]{FormUtil.getSecondTimeString(duration)});
        string = string.replaceAll("%%%duration%%%", durationString);
        Integer distance = logisticTour == null ? null : logisticTour.getDistanceSum();
        Integer accessDistance = logisticTour == null ? null : logisticTour.getAccessSum();
        Integer streetDistance = distance == null || accessDistance == null ? null : Integer.valueOf(distance - accessDistance);
        String distanceDisplay = ClientFormUtil.getDistanceDisplay(distance, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
        String string2 = distanceString = distance == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + distanceDisplay;
        if (streetDistance != null && accessDistance != null) {
            distanceString = distanceString + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(streetDistance, "");
            distanceString = distanceString + "- " + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(accessDistance, "") + ")";
        }
        string = string.replaceAll("%%%distance%%%", distanceString);
        Integer sum = this.getModelSum();
        string = string.replaceAll("%%%sum%%%", sum == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.stopSum", new Serializable[0]) + ": " + sum);
        string = string.replaceAll("%%%printDate%%%", ClientFormUtil.dateToString(new Date(), FormUtil.DATEFORMAT));
        Double costDuration = null;
        Double costDistance = null;
        Double costNightSurcharge = null;
        Double costExtraCharge = null;
        Double costSum = null;
        if (logisticTourResult != null && this.parameter != null) {
            costDuration = logisticTourResult.getCostDuration(this.parameter);
            costDistance = logisticTourResult.getCostDistance(this.parameter);
            costNightSurcharge = logisticTourResult.getCostNightSurcharge(this.parameter);
            costExtraCharge = logisticTourResult.getCostExtraCharge(this.parameter);
            costSum = logisticTourResult.getCostSum(this.parameter);
        }
        string = string.replaceAll("%%%cost_duration%%%", costDuration == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.duration", new Serializable[0]) + ": " + costDuration);
        string = string.replaceAll("%%%cost_distance%%%", costDistance == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.distance", new Serializable[0]) + ": " + costDistance);
        string = string.replaceAll("%%%cost_nightSurcharge%%%", costNightSurcharge == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.nightsurcharge", new Serializable[0]) + ": " + costNightSurcharge);
        string = string.replaceAll("%%%cost_extraCharge%%%", costExtraCharge == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.extraCharge", new Serializable[0]) + ": " + costExtraCharge);
        string = string.replaceAll("%%%cost_sum%%%", costSum == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.cost.total", new Serializable[0]) + ": " + costSum);
        String[] ss = string.split("\n");
        string = ss[0];
        for (int i = 1; i < ss.length; ++i) {
            if (StringUtil.isBlank(ss[i]) || ss[i].contains("%%%")) continue;
            string = string + "\n" + ss[i];
        }
        return string;
    }

    public AreaTourExportModelsHolder getModelsHolder() {
        return this.modelsHolder;
    }

    public void setModelsHolder(AreaTourExportModelsHolder modelsHolder) {
        this.modelsHolder = modelsHolder;
    }

    public AreaTourParameter getParameter() {
        return this.parameter;
    }

    public LogisticTourDto<PointEntityId> getTour() {
        return ((AreaTourExportDto)this.getUserObject()).getLogisticTourDto();
    }
}

