/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui.legend;

import de.datomino.peppergis.areamanager.gui.legend.AreaObjectTourMapNode;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.util.FormUtil;
import java.io.Serializable;
import java.util.Date;
import org.ktde.util.StringUtil;

public class AreaObjectHistoryTourMapNode
extends AreaObjectTourMapNode<HistoryAreaTourModelWageResult> {
    private static final long serialVersionUID = 258746826365426198L;

    public AreaObjectHistoryTourMapNode(AreaObjectModel area, HistoryAreaTourModelWageResult historyResult) {
        super(area, historyResult, AreaObjectTourLegendType.HISTORY);
    }

    @Override
    public Integer getModelSum() {
        HistoryAreaTourModelWageResult result = (HistoryAreaTourModelWageResult)super.getUserObject();
        HistoryAreaTourModel tour = result.getModel();
        return tour.getStopCount();
    }

    @Override
    public String getTourInfo(String pattern) {
        String distanceString;
        if (pattern == null) {
            return this.getString();
        }
        HistoryAreaTourModelWageResult result = (HistoryAreaTourModelWageResult)super.getUserObject();
        HistoryAreaTourModel logisticTour = result.getModel();
        String string = ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]) + " - " + pattern;
        string = string.replaceAll("%%%shortcut%%%", StringUtil.getNotNull(this.getAreaObject().getShortcut()));
        string = string.replaceAll("%%%displayname%%%", StringUtil.getNotNull(this.getAreaObject().getDisplayname()));
        Integer duration = logisticTour == null ? null : logisticTour.getDuration();
        String durationString = duration == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.duration", new Serializable[]{FormUtil.getSecondTimeString(duration)});
        string = string.replaceAll("%%%duration%%%", durationString);
        Integer distance = logisticTour == null ? null : logisticTour.getLength();
        Integer accessDistance = logisticTour == null ? null : logisticTour.getParcelLength();
        Integer streetDistance = distance == null || accessDistance == null ? null : Integer.valueOf(distance - accessDistance);
        String distanceDisplay = ClientFormUtil.getDistanceDisplay(distance, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
        String string2 = distanceString = distance == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + distanceDisplay;
        if (streetDistance != null && accessDistance != null) {
            distanceString = distanceString + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(streetDistance, "");
            distanceString = distanceString + "- " + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(accessDistance, "") + ")";
        }
        string = string.replaceAll("%%%distance%%%", distanceString);
        Integer sum = this.getModelSum();
        string = string.replaceAll("%%%sum%%%", sum == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.stopSum", new Serializable[0]) + ": " + sum);
        string = string.replaceAll("%%%printDate%%%", ClientFormUtil.dateToString(new Date(), FormUtil.DATEFORMAT));
        String[] ss = string.split("\n");
        string = ss[0];
        for (int i = 1; i < ss.length; ++i) {
            if (StringUtil.isBlank(ss[i]) || ss[i].contains("%%%")) continue;
            string = string + "\n" + ss[i];
        }
        return string;
    }
}

