/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.message.MessageResolver;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.ktde.util.datatypes.Tupel;

public class LayoverSeletionDialog
extends CommonDialog {
    private static final long serialVersionUID = -3398710302381844221L;
    private JTable table;
    private Map<AreaTourModel, LocationModel> areaTourMap;

    public LayoverSeletionDialog(Map<AreaTourModel, LocationModel> areaTourMap, Component parent, String title, Dialog.ModalityType modalityType) {
        super(parent, title, modalityType);
        this.areaTourMap = areaTourMap;
    }

    @Override
    protected Component getMainComponent() {
        this.table = new JTable(new DefaultTableModel());
        this.table.setSelectionMode(0);
        this.table.setRowMargin(5);
        this.table.setRowHeight(25);
        ArrayList<Map.Entry<AreaTourModel, LocationModel>> entries = new ArrayList<Map.Entry<AreaTourModel, LocationModel>>(this.areaTourMap.entrySet());
        Collections.sort(entries, new StreetNameComparator<Map.Entry<AreaTourModel, LocationModel>, LocationModel>(){

            @Override
            protected LocationModel getM(Map.Entry<AreaTourModel, LocationModel> o) {
                return o.getValue();
            }
        });
        Object[] header = this.createHeader();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int index = 0;
        for (Map.Entry entry : entries) {
            Object[] row = this.createRow((AreaTourModel)entry.getKey(), (LocationModel)entry.getValue(), index + 1);
            Object[] subRow = Arrays.copyOfRange(row, 1, row.length);
            boolean exists = false;
            for (Object[] r : rows) {
                if (!Arrays.equals(subRow, Arrays.copyOfRange(r, 1, r.length))) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            rows.add(row);
            ++index;
        }
        Object[][] dataVector = new Object[rows.size()][header.length];
        rows.toArray((T[])dataVector);
        ((DefaultTableModel)this.table.getModel()).setDataVector(dataVector, header);
        this.createMultiHeader();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(1600, 400));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(8).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(9).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(10).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(11).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(12).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(13).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(14).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(15).setPreferredWidth(100);
        return jScrollPane;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -8645739622667930402L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoverSeletionDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = 5662313633892186835L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoverSeletionDialog.this.table.clearSelection();
                super.actionPerformed(e);
            }
        };
    }

    private Object[] createRow(AreaTourModel areaTour, LocationModel location, int index) {
        Object[] row = new Object[16];
        row[0] = new Tupel<Integer, LocationModel>(index, location);
        LocationWrapper locationDto = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        row[1] = locationDto.getCountry() == null ? "" : locationDto.getCountry().getIso3166_2();
        row[2] = locationDto.getPostcode();
        row[3] = locationDto.getCity();
        row[4] = locationDto.getDistrict();
        row[5] = locationDto.getStreet();
        row[6] = locationDto.getHousenumber();
        row[7] = locationDto.getHousenumberExtension();
        boolean back = false;
        boolean startPoi = false;
        boolean endPoi = false;
        boolean startPickPoint = false;
        boolean endPickPoint = false;
        RouteVehicleType vehiclePoi = null;
        RouteVehicleType vehiclePickPoint = null;
        RouteVehicleType vehicleArea = null;
        if (areaTour.countAreaTourParts() == 1) {
            AreaStopModel first;
            AreaTourPartModel part = areaTour.getAreaTourPartAt(0);
            AreaStopModel last = part.getAreaStopAt(part.countAreaStops() - 1);
            if (last.getPoi() != null) {
                block0 : switch (last.getPoi().getPoiType()) {
                    case AREAOBJECT_LOCATION: 
                    case AREA_DELIVERER_LOCATION: {
                        AreaStopModel s;
                        endPoi = true;
                        for (int i = part.countAreaStops() - 2; i >= 0 && (s = part.getAreaStopAt(i)).getPoi() != null; --i) {
                            if (s.getPoi().getPoiType() != PoiType.PICK_POINT) continue;
                            endPickPoint = true;
                            break block0;
                        }
                        break;
                    }
                    case END_POINT: {
                        back = true;
                        break;
                    }
                    case PICK_POINT: {
                        endPickPoint = true;
                        break;
                    }
                }
            }
            if ((first = part.getAreaStopAt(0)).getPoi() != null) {
                block5 : switch (first.getPoi().getPoiType()) {
                    case AREAOBJECT_LOCATION: 
                    case DELIVERER_LOCATION: {
                        AreaStopModel s;
                        startPoi = true;
                        for (int i = 1; i < part.countAreaStops() && (s = part.getAreaStopAt(i)).getPoi() != null; ++i) {
                            if (s.getPoi().getPoiType() != PoiType.PICK_POINT) continue;
                            startPickPoint = true;
                            break block5;
                        }
                        break;
                    }
                    case PICK_POINT: {
                        startPickPoint = true;
                        break;
                    }
                }
            }
            if (back) {
                endPoi = startPoi;
                endPickPoint = startPickPoint;
            }
            vehiclePickPoint = vehicleArea = part.getRouteVehicleType();
            vehiclePoi = vehicleArea;
        } else if (areaTour.countAreaTourParts() == 5) {
            AreaTourPartModel startPoiPart = areaTour.getAreaTourPartAt(0);
            AreaTourPartModel startPickPointPart = areaTour.getAreaTourPartAt(1);
            AreaTourPartModel areaPart = areaTour.getAreaTourPartAt(2);
            AreaTourPartModel endPickPointPart = areaTour.getAreaTourPartAt(3);
            AreaTourPartModel endPoiPart = areaTour.getAreaTourPartAt(4);
            startPoi = !startPoiPart.isAreaStopsEmpty();
            endPoi = !endPoiPart.isAreaStopsEmpty();
            startPickPoint = !startPickPointPart.isAreaStopsEmpty();
            endPickPoint = !endPickPointPart.isAreaStopsEmpty();
            vehiclePoi = startPoiPart.getRouteVehicleType();
            vehiclePickPoint = startPickPointPart.getRouteVehicleType();
            vehicleArea = areaPart.getRouteVehicleType();
        }
        row[8] = back ? "x" : "-";
        row[9] = startPoi ? "x" : "-";
        row[10] = endPoi ? "x" : "-";
        row[11] = startPickPoint ? "x" : "-";
        row[12] = endPickPoint ? "x" : "-";
        row[13] = vehiclePoi == null ? "-" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(vehiclePoi);
        row[14] = vehiclePickPoint == null ? "-" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(vehiclePickPoint);
        row[15] = vehicleArea == null ? "-" : ModelEnviroment.getMessageResolver().resolveMessageForEnum(vehicleArea);
        return row;
    }

    private String[] createHeader() {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        String[] header = new String[]{" \n#\n \n", " \n" + messageResolver.resolveMessage("address.country", new Serializable[0]), " \n" + messageResolver.resolveMessage("address.postcode", new Serializable[0]), " \n" + messageResolver.resolveMessage("address.city", new Serializable[0]), " \n" + messageResolver.resolveMessage("address.district", new Serializable[0]), " \n" + messageResolver.resolveMessage("address.street", new Serializable[0]), " \n" + messageResolver.resolveMessage("address.housenumber", new Serializable[0]), " \n" + messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]), " \n" + messageResolver.resolveMessage("buttons.backward", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.startPoi", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.endPoi", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.startPickPoint", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.endPickPoint", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.vehicle.poi", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.vehicle.pickPoint", new Serializable[0]), " \n" + messageResolver.resolveMessage("gui.areatour.vehicle.area", new Serializable[0])};
        return header;
    }

    private void createMultiHeader() {
        MultiLineHeaderRenderer headerRenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerRenderer);
            tableColumn.setCellRenderer(new LayoverTableCellRenderer());
        }
    }

    public static LocationModel show(Map<AreaTourModel, LocationModel> areaTourMap, Component parent) {
        LayoverSeletionDialog dialog = new LayoverSeletionDialog(areaTourMap, parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.selectLayover", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        dialog.buildLayout();
        dialog.pack();
        dialog.center();
        dialog.setVisible(true);
        int selectedRow = dialog.table.getSelectedRow();
        return selectedRow < 0 ? null : (LocationModel)((Tupel)dialog.table.getValueAt(selectedRow, 0)).getElement2();
    }

    private class LayoverTableCellRenderer
    extends AbstractTableRenderer {
        private LayoverTableCellRenderer() {
        }

        @Override
        protected String getString(Object value) {
            if (value instanceof Tupel) {
                value = ((Tupel)value).getElement1();
            }
            return value == null ? "" : value.toString();
        }
    }
}

