/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.StopType;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.LayoverSeletionDialog;
import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiSelectionPanel;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.type.PoiSearchType;
import de.datomino.util.format.SpecialNumberFormat;
import de.datomino.util.swing.SpringUtilities;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class AreaTourRoutingPane
extends JPanel {
    private static final long serialVersionUID = -8256706581255959266L;
    private JRadioButton calculate;
    private JRadioButton optimise;
    private JRadioButton calculateOrig;
    private JRadioButton parcelSortOrder;
    private JCheckBox poi;
    private PoiSelectionPanel startPickPoint;
    private PoiSelectionPanel endPickPoint;
    private EnumComboBox<RouteBackType> back;
    private JRadioButton motorcar;
    private JRadioButton foot;
    private JRadioButton bike;
    private JRadioButton motorcarPoi;
    private JRadioButton footPoi;
    private JRadioButton bikePoi;
    private JRadioButton motorcarPickPoint;
    private JRadioButton footPickPoint;
    private JRadioButton bikePickPoint;
    private JCheckBox startFix;
    private JFormattedTextField startFixCounter;
    private JCheckBox endFix;
    private JCheckBox streetSide;
    private JFormattedTextField endFixCounter;
    private ModelEnviroment modelEnviroment;

    public AreaTourRoutingPane(ModelEnviroment modelEnviroment, AreaObjectModel areaObjectModel) {
        this.modelEnviroment = modelEnviroment;
        this.initialise(areaObjectModel);
    }

    private void initialise(AreaObjectModel areaObjectModel) {
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        JPanel typePane = new JPanel(new FlowLayout());
        typePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.calculate = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{""}));
        typePane.add(this.calculate);
        this.optimise = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.optimise", new Serializable[]{""}));
        this.optimise.setSelected(true);
        typePane.add(this.optimise);
        this.calculateOrig = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculateOrig", new Serializable[0]));
        typePane.add(this.calculateOrig);
        ButtonGroup group = new ButtonGroup();
        group.add(this.calculate);
        group.add(this.optimise);
        group.add(this.calculateOrig);
        this.parcelSortOrder = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.parcelSortOrder", new Serializable[0]));
        typePane.add(this.parcelSortOrder);
        group.add(this.parcelSortOrder);
        this.add(typePane);
        JPanel routingTypePane = new JPanel(new FlowLayout());
        routingTypePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.motorcar = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.MOTORCAR));
        routingTypePane.add(this.motorcar);
        this.foot = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.FOOT));
        this.foot.setSelected(true);
        routingTypePane.add(this.foot);
        this.bike = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.BIKE));
        routingTypePane.add(this.bike);
        ButtonGroup vehicleGroup = new ButtonGroup();
        vehicleGroup.add(this.motorcar);
        vehicleGroup.add(this.foot);
        vehicleGroup.add(this.bike);
        VehicleActionListener vehicleActionListener = new VehicleActionListener();
        this.motorcar.addActionListener(vehicleActionListener);
        this.foot.addActionListener(vehicleActionListener);
        this.bike.addActionListener(vehicleActionListener);
        this.add(routingTypePane);
        JPanel pickpointPane = new JPanel(new SpringLayout());
        pickpointPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.poi", new Serializable[0])));
        JPanel routingTypePoiPane = new JPanel(new FlowLayout());
        routingTypePoiPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.motorcarPoi = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.MOTORCAR));
        routingTypePoiPane.add(this.motorcarPoi);
        this.footPoi = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.FOOT));
        this.footPoi.setSelected(true);
        routingTypePoiPane.add(this.footPoi);
        this.bikePoi = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.BIKE));
        routingTypePoiPane.add(this.bikePoi);
        ButtonGroup vehiclePoiGroup = new ButtonGroup();
        vehiclePoiGroup.add(this.motorcarPoi);
        vehiclePoiGroup.add(this.footPoi);
        vehiclePoiGroup.add(this.bikePoi);
        pickpointPane.add(routingTypePoiPane);
        pickpointPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.vehicle.pickPoint", new Serializable[0])));
        JPanel routingTypePickPointPane = new JPanel(new FlowLayout());
        routingTypePickPointPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.motorcarPickPoint = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.MOTORCAR));
        routingTypePickPointPane.add(this.motorcarPickPoint);
        this.footPickPoint = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.FOOT));
        this.footPickPoint.setSelected(true);
        routingTypePickPointPane.add(this.footPickPoint);
        this.bikePickPoint = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.BIKE));
        routingTypePickPointPane.add(this.bikePickPoint);
        ButtonGroup vehiclePickPointGroup = new ButtonGroup();
        vehiclePickPointGroup.add(this.motorcarPickPoint);
        vehiclePickPointGroup.add(this.footPickPoint);
        vehiclePickPointGroup.add(this.bikePickPoint);
        pickpointPane.add(routingTypePickPointPane);
        SpringUtilities.makeCompactGrid(pickpointPane, 2, 2, 0, 0, 5, 5);
        this.add(pickpointPane);
        SpecialNumberFormat formatter = new SpecialNumberFormat(true, null);
        JPanel poiPane = new JPanel(new FlowLayout());
        poiPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.poi = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0]));
        poiPane.add(this.poi);
        poiPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("buttons.backward", new Serializable[0])));
        this.back = new EnumComboBox<RouteBackType>(RouteBackType.class, false);
        this.back.setSelectedValue(RouteBackType.NONE);
        poiPane.add(this.back);
        this.streetSide = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.preference.withSide", new Serializable[0]));
        poiPane.add(this.streetSide);
        this.add(poiPane);
        JPanel fixPane = new JPanel(new FlowLayout());
        fixPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.startFix = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.firstFix", new Serializable[0]));
        fixPane.add(this.startFix);
        this.startFixCounter = new JFormattedTextField(formatter);
        this.startFixCounter.setColumns(4);
        this.startFixCounter.setValue(1);
        fixPane.add(this.startFixCounter);
        this.endFix = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.lastFix", new Serializable[0]));
        fixPane.add(this.endFix);
        this.endFixCounter = new JFormattedTextField(formatter);
        this.endFixCounter.setColumns(4);
        this.endFixCounter.setValue(1);
        fixPane.add(this.endFixCounter);
        this.add(fixPane);
        pickpointPane = new JPanel(new SpringLayout());
        pickpointPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pickpointPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.startPickPoints", new Serializable[0])));
        this.startPickPoint = new PoiSelectionPanel(this.modelEnviroment, new PoiSearchType[]{PoiSearchType.AREAOBJECT_LOCATION, PoiSearchType.PICK_POINT}, areaObjectModel.getFirstPickPoint(), true);
        pickpointPane.add(this.startPickPoint);
        pickpointPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.endPickPoints", new Serializable[0])));
        this.endPickPoint = new PoiSelectionPanel(this.modelEnviroment, new PoiSearchType[]{PoiSearchType.AREAOBJECT_LOCATION, PoiSearchType.PICK_POINT}, areaObjectModel.getLastPickPoint(), true);
        pickpointPane.add(this.endPickPoint);
        SpringUtilities.makeCompactGrid(pickpointPane, 2, 2, 0, 0, 5, 5);
        this.add(pickpointPane);
    }

    public static Tripel<AreaTourParameter, PoiModel, PoiModel> show(AreaManagerMapGui areaManagerMap) throws LogisticException {
        Tripel<AreaTourParameter, PoiModel, PoiModel> result = new Tripel<AreaTourParameter, PoiModel, PoiModel>();
        return result;
    }

    private static Tupel<PoiModel, Boolean> getPickPoint(PoiModel pickPoint, Tupel<AreaObjectModel, StopType> areaPickPointTupel, AreaTourParameter parameter, AreaManagerMapGui areaManagerMap) throws LogisticException {
        Tupel<PoiModel, Boolean> selected = new Tupel<PoiModel, Boolean>(pickPoint, true);
        return selected;
    }

    private static LocationModel selectPickPoint(Map<AreaTourModel, LocationModel> areaTourMap, AreaManagerMapGui areaManagerMap) {
        LocationModel selected = null;
        boolean samed = true;
        for (LocationModel l1 : areaTourMap.values()) {
            LocationModel l2;
            Iterator<LocationModel> iterator = areaTourMap.values().iterator();
            while (iterator.hasNext() && (samed = LocationModelUtil.areSamedAddress(l1, l2 = iterator.next()))) {
            }
        }
        selected = samed ? (areaTourMap.isEmpty() ? null : areaTourMap.values().iterator().next()) : LayoverSeletionDialog.show(areaTourMap, areaManagerMap);
        return selected;
    }

    private static void getBacks(AreaTourModel areaTour, StopType stopType, Map<AreaTourModel, LocationModel> areaTourMap, ModelEnviroment modelEnviroment) {
        ArrayList<Model> modelsWithouPoi = new ArrayList<Model>();
        for (AreaTourPartModel part : areaTour.iterableAreaTourParts()) {
            for (AreaStopModel stop : part.iterableAreaStops()) {
                if (stop.getPoi() != null) continue;
                if (stop.getParcel() != null) {
                    modelsWithouPoi.add(stop.getParcel());
                    continue;
                }
                if (stop.getSubscription() != null) {
                    modelsWithouPoi.add(stop.getSubscription());
                    continue;
                }
                if (stop.getLetter() == null) continue;
                modelsWithouPoi.add(stop.getLetter());
            }
        }
        if (!modelsWithouPoi.isEmpty()) {
            Model pickPointModel = null;
            switch (stopType) {
                case FIX_START: {
                    pickPointModel = (Model)modelsWithouPoi.get(0);
                    break;
                }
                case FIX_END: {
                    pickPointModel = (Model)modelsWithouPoi.get(modelsWithouPoi.size() - 1);
                }
            }
            BaseCaller baseCaller = modelEnviroment.getAllCaller().getBaseCaller();
            LocationModel location = null;
            if (pickPointModel != null && pickPointModel instanceof ParcelModel) {
                ParcelModel parcel = (ParcelModel)pickPointModel;
                Collection<LocationModel> ls = baseCaller.getLocationsForParcel(parcel);
                if (ls == null || ls.isEmpty()) {
                    location = new LocationModelImpl();
                    location.setParcel(parcel);
                } else {
                    location = ls.iterator().next();
                }
            } else if (pickPointModel != null && pickPointModel instanceof SubscriptionModel) {
                location = ((SubscriptionModel)pickPointModel).getLocation();
            } else if (pickPointModel != null && pickPointModel instanceof LetterModel) {
                location = ((LetterModel)pickPointModel).getLocation();
            }
            areaTourMap.put(areaTour, location);
        }
    }

    private class VehicleActionListener
    implements ActionListener {
        private VehicleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AreaTourRoutingPane.this.motorcar.isSelected()) {
                AreaTourRoutingPane.this.motorcarPoi.setSelected(true);
                AreaTourRoutingPane.this.motorcarPickPoint.setSelected(true);
            } else if (AreaTourRoutingPane.this.foot.isSelected()) {
                AreaTourRoutingPane.this.footPoi.setSelected(true);
                AreaTourRoutingPane.this.footPickPoint.setSelected(true);
            } else if (AreaTourRoutingPane.this.bike.isSelected()) {
                AreaTourRoutingPane.this.bikePoi.setSelected(true);
                AreaTourRoutingPane.this.bikePickPoint.setSelected(true);
            }
        }
    }
}

