/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.logistic.LogisticException;
import de.datomino.peppergis.areamanager.gui.legend.schedule.AreaTourScheduleNode;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.DashLineRenderer;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.helper.PointEntity;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class AreaScheduleLayerRenderer
extends AbstractNavigatorRenderer {
    private AbstractManagerMapGui<AreaScheduleEntity> mapGui;
    private NavigatorPanel navigatorPanel;
    private Map<AreaTourScheduleNode, List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>>> tourLineStrings = new HashMap<AreaTourScheduleNode, List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>>>();
    private Map<AreaTourScheduleNode, List<AbstractImmutableGeoObject>> accessLineStrings = new HashMap<AreaTourScheduleNode, List<AbstractImmutableGeoObject>>();
    private Map<AreaTourScheduleNode, List<ImmutablePoint>> pointLists = new HashMap<AreaTourScheduleNode, List<ImmutablePoint>>();
    private Set<Coordinate> areaRectangles = new HashSet<Coordinate>();
    private ModelEnviroment modelEnviroment;

    public AreaScheduleLayerRenderer(AbstractManagerMapGui<AreaScheduleEntity> mapGui, ModelEnviroment modelEnviroment) {
        super("AreaTourLayerRenderer");
        this.mapGui = mapGui;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.pointLists != null && super.isActive()) {
            ImmutableLineString lineString;
            ManagerPointRenderer tourPointRenderer = new ManagerPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory(), null);
            SolidLineRenderer solidLineRenderer = new SolidLineRenderer(upp, true, this.navigatorPanel.getCoordinateFactory());
            DashLineRenderer dashLineRenderer = new DashLineRenderer(upp, true, this.navigatorPanel.getCoordinateFactory());
            double margin = 10.0 * Math.pow(upp, -0.2) * upp;
            for (List<Tupel<AbstractImmutableGeoObject, AbstractLineRenderer.LineType>> list : this.tourLineStrings.values()) {
                for (Object geo : list) {
                    if (!(((Tupel)geo).getElement1() instanceof ImmutableLineString)) continue;
                    lineString = (ImmutableLineString)((Tupel)geo).getElement1();
                    switch ((AbstractLineRenderer.LineType)((Object)((Tupel)geo).getElement2())) {
                        case DASH: {
                            dashLineRenderer.render(g2d, (ImmutableLineString)lineString.getTransformed(this.navigatorPanel.getCoordinateFactory()), Color.BLACK, 1.0f);
                            break;
                        }
                        case SOLID: {
                            solidLineRenderer.render(g2d, (ImmutableLineString)lineString.getTransformed(this.navigatorPanel.getCoordinateFactory()), Color.BLACK, 1.0f);
                            break;
                        }
                    }
                }
            }
            for (List<Object> list : this.accessLineStrings.values()) {
                for (Object geo : list) {
                    if (!(geo instanceof ImmutableLineString)) continue;
                    lineString = (ImmutableLineString)geo;
                    solidLineRenderer.render(g2d, (ImmutableLineString)lineString.getTransformed(this.navigatorPanel.getCoordinateFactory()), Color.BLACK, 1.0f);
                }
            }
            for (AreaTourScheduleNode areaTourScheduleNode : this.pointLists.keySet()) {
                int index = 1;
                List<ImmutablePoint> points = this.pointLists.get(areaTourScheduleNode);
                for (ImmutablePoint point : points) {
                    String string = String.valueOf(index++);
                    RendererNode node = new RendererNode(string, point.getCoordinate(), Color.BLACK, areaTourScheduleNode.getColor(), margin);
                    tourPointRenderer.drawBuilding(node, false);
                }
                tourPointRenderer.drawStopWithCircle(points.get(0), "S", margin * 1.5);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    private void initLineStrings(Collection<AreaTourScheduleNode> schedules) throws LogisticException {
        this.pointLists.clear();
        this.accessLineStrings.clear();
        this.tourLineStrings.clear();
        if (schedules != null) {
            for (AreaTourScheduleNode schedule : schedules) {
                Set<HistoryAreaTourModelWageResult> wageResult;
                Collection<HistoryAreaTourModelWageResult> collection = wageResult = schedule.getEntity() == null ? Collections.emptySet() : schedule.getEntity().getHistoryResult();
                if (wageResult.isEmpty()) continue;
                ArrayList<PointEntity> entities = new ArrayList<PointEntity>();
                for (HistoryAreaTourModelWageResult r : wageResult) {
                    entities.addAll(r.getPointEntities());
                }
                LinkedList<ImmutablePoint> pointList = new LinkedList<ImmutablePoint>();
                LinkedList<ImmutablePoint> accessPointList = new LinkedList<ImmutablePoint>();
                LinkedList<AbstractImmutableGeoObject> accessLineString = new LinkedList<AbstractImmutableGeoObject>();
                for (PointEntity entity : entities) {
                    ImmutablePoint geoPoint = entity.getGeom();
                    ImmutablePoint accessPoint = entity.getAccessGeom();
                    if (GeoUtil.isNullPoint(accessPoint)) {
                        accessPoint = geoPoint;
                    }
                    pointList.add(geoPoint);
                    accessPointList.add(accessPoint);
                    if (GeoUtil.isNullPoint(geoPoint)) {
                        accessLineString.add(geoPoint);
                        continue;
                    }
                    accessLineString.add(GeoUtil.createLineString(accessPoint, geoPoint));
                }
                this.pointLists.put(schedule, pointList);
                this.accessLineStrings.put(schedule, accessLineString);
                for (HistoryAreaTourModelWageResult r : wageResult) {
                    entities.addAll(r.getPointEntities());
                    ImmutableLineString lineString = r.getModel().getLineString();
                    if (lineString == null) continue;
                    this.tourLineStrings.put(schedule, CollectionUtil.buildArrayList(new Tupel<ImmutableLineString, AbstractLineRenderer.LineType>(lineString, AbstractLineRenderer.LineType.SOLID)));
                    this.areaRectangles.addAll(GeoUtil.getAreaRectangle(lineString.getCoordinates()));
                }
            }
        }
    }

    public void setSchedulesWithColor(Collection<AreaTourScheduleNode> schedules) throws LogisticException {
        this.areaRectangles = new HashSet<Coordinate>();
        this.initLineStrings(schedules);
        this.mapGui.setAreaRectangles(this.areaRectangles);
    }

    public Set<Coordinate> getAreaRectangles() {
        return this.areaRectangles;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }
}

