/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.peppergis.areamanager.gui.AreaLegendTreeRenderer;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.gui.AreaTreeLegendReorderingListener;
import de.datomino.peppergis.areamanager.gui.legend.AreaGroupMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectHistoryTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import de.datomino.peppergis.areamanager.listener.AreaLegendTreeListener;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.handler.DisablingDoubleClickMouseListener;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.manager.legend.LegendObjectHelper;
import de.datomino.peppergis.client.model.AreaTourExportModelsHolder;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.dto.exporter.AreaTourExportDto;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaManagerMapGui
extends AbstractManagerMapGui<AreaScheduleEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaManagerMapGui.class);
    private static final long serialVersionUID = -4530128702418519803L;
    private Set<Coordinate> areaRectangles;
    private AreaManagerCalendarGui areaManager;
    private AreaLayerRenderer postcodeLayerRenderer;
    protected AreaLayerModel postcodeAreaLayer;
    private JTabbedPane legendTabbedPane;
    private List<AreaObjectMapNode> areaMapNodes = new ArrayList<AreaObjectMapNode>();
    private JTree areaLegendTree;
    private DefaultTreeModel areaLegendTreeModel;
    private Color currentAreaColor;
    private JButton areaLegendReCalcButton;
    private Set<AreaObjectLogisticTourMapNode> changedLogisticTourNodes = new HashSet<AreaObjectLogisticTourMapNode>();

    public AreaManagerMapGui(AreaManagerCalendarGui areaManager) throws IOException {
        super((LayoutManager)new BorderLayout(), areaManager.getModelEnviroment());
        this.areaManager = areaManager;
        this.modelEnviroment = this.areaManager.getModelEnviroment();
    }

    @Override
    public AreaScheduleEntity getSelectedModel() {
        return null;
    }

    @Override
    public void repaintGui(boolean update) {
        if (this.areaMapNodes == null || this.areaMapNodes.isEmpty()) {
            return;
        }
        this.loadAreaLegendPane();
        if (update) {
            if (this.areaRectangles == null) {
                this.areaRectangles = new HashSet<Coordinate>();
            } else {
                this.areaRectangles.clear();
            }
            for (AreaObjectMapNode node : this.areaMapNodes) {
                if (node == null) continue;
                Enumeration<TreeNode> children = node.children();
                while (children.hasMoreElements()) {
                    AreaObjectTourMapNode nextElement = (AreaObjectTourMapNode)children.nextElement();
                    if (nextElement.getAllObjectFilterLayerRenderer() == null) continue;
                    this.areaRectangles.addAll(nextElement.getAllObjectFilterLayerRenderer().getAreaRectangles(false));
                }
            }
            this.center();
        }
        Container parent = this.areaLegendTree.getParent().getParent().getParent().getParent();
        this.legendTabbedPane.setSelectedComponent(parent);
        this.areaManager.getTabbedPane().setSelectedComponent(this);
        if (this.changedLogisticTourNodes.isEmpty()) {
            this.areaLegendReCalcButton.setVisible(false);
        } else {
            this.areaLegendReCalcButton.setVisible(true);
        }
        this.repaint(10L);
    }

    public void initialized(Coordinate startCoordinate) throws IOException {
        this.initializedMapPanel(startCoordinate);
        this.legendTabbedPane = new JTabbedPane(1, 0);
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.AREA_VIEWER, UserRole.PERSONAL_PLANNER)) {
            this.legendTabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.deliveryroute", new Serializable[0]), this.createAreaLegendPanel());
            this.legendTabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.routePlanner", new Serializable[0]), this.createRoutePlannerPane(this.legendTabbedPane));
        }
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.legendTabbedPane, "Center");
        JSplitPane splitPane = new JSplitPane(1, leftPanel, this.navigatorPanel);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)splitPane, "Center");
    }

    private JPanel createAreaLegendPanel() {
        MouseListener[] listeners;
        this.areaLegendTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.markingWithColor", new Serializable[0])));
        this.areaLegendTreeModel.addTreeModelListener(new AreaTreeLegendReorderingListener(this.areaLegendTreeModel));
        this.areaLegendTree = new JTree(this.areaLegendTreeModel);
        for (MouseListener listener : listeners = this.areaLegendTree.getMouseListeners()) {
            this.areaLegendTree.removeMouseListener(listener);
            this.areaLegendTree.addMouseListener(new DisablingDoubleClickMouseListener(listener));
        }
        AreaLegendTreeListener mouseListener = new AreaLegendTreeListener(this);
        this.areaLegendTree.addMouseListener(mouseListener);
        this.areaLegendTree.addMouseMotionListener(mouseListener);
        this.areaLegendTree.setCellRenderer(new AreaLegendTreeRenderer());
        this.areaLegendTree.setScrollsOnExpand(true);
        this.areaLegendTree.getSelectionModel().setSelectionMode(1);
        this.areaLegendReCalcButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.legend.routeUpdate", new Serializable[0])){
            private static final long serialVersionUID = -5665511397235394534L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaManagerMapGui.this.recalcChangedNodes();
            }
        });
        this.areaLegendReCalcButton.setForeground(Color.RED);
        this.areaLegendReCalcButton.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.areaLegendReCalcButton.setVisible(false);
        JScrollPane areaLegendPane = new JScrollPane(this.areaLegendTree);
        areaLegendPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        JButton clearButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.legend.clear", new Serializable[0])){
            private static final long serialVersionUID = -6544014220939095492L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaManagerMapGui.this.clearAreaMapNodes();
            }
        });
        clearButton.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.areaLegendReCalcButton, "North");
        pane.add((Component)areaLegendPane, "Center");
        pane.add((Component)clearButton, "South");
        return ClientSwingUtil.createPanelForComponent(pane, ModelEnviroment.getMessageResolver().resolveMessage("gui.area.legend", new Serializable[0]));
    }

    private void recalcChangedNodes() {
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        for (AreaObjectLogisticTourMapNode node : this.changedLogisticTourNodes) {
            LogisticTourDto<PointEntityId> tour = node.getTour();
            this.adaptLogisticStopSortOrder(tour, node);
            try {
                LogisticTourDto<PointEntityId> newTour = tourCaller.calculateLogisticTour(tour, false);
                AreaTourExportDto exportDto = (AreaTourExportDto)node.getUserObject();
                exportDto.setLogisticTourDto(newTour);
                node.getModelsHolder().update(newTour);
                node.removeAllChildren();
                this.loadLogisticTourMapNode(node);
            }
            catch (LogisticException e) {
                ErrorMessagesDialog.creatAndShow(e.getLocalizedMessage(), this.areaManager);
            }
        }
        this.changedLogisticTourNodes.clear();
        this.repaintGui(true);
    }

    private void adaptLogisticStopSortOrder(LogisticTourDto<PointEntityId> tour, AreaObjectLogisticTourMapNode tourNode) {
        List<AreaStopNode<?>> stopNodes = tourNode.getAllStopNodes();
        for (LogisticTourPartDto<PointEntityId> part : tour.getTourParts()) {
            List<LogisticStopDto<PointEntityId>> stops = part.getStopDtos();
            ArrayList newStops = new ArrayList(stops.size());
            int sortOrder = 1;
            for (AreaStopNode<?> n : stopNodes) {
                LegendObject o = (LegendObject)n.getAreaStop();
                Model m = (Model)o.getM();
                LogisticStopDto<PointEntityId> found = this.findLogisticStop(stops, m);
                if (found == null) continue;
                if (m instanceof PoiModel) {
                    found.setSortOrder(0);
                } else {
                    found.setSortOrder(sortOrder++);
                }
                newStops.add(found);
            }
            part.setStopDtos(newStops);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private LogisticStopDto<PointEntityId> findLogisticStop(List<LogisticStopDto<PointEntityId>> stops, Model m) {
        LogisticStopDto<PointEntityId> found = null;
        Iterator<LogisticStopDto<PointEntityId>> iterator = stops.iterator();
        while (iterator.hasNext()) {
            LogisticStopDto<PointEntityId> stop = iterator.next();
            PointEntityId entityId = (PointEntityId)stop.getId();
            if (!entityId.getId().equals(m.getTempUUID())) continue;
            switch (entityId.getPointEnityType()) {
                case LETTER: {
                    if (!(m instanceof LetterModel)) break;
                    return stop;
                }
                case PARCEL: {
                    if (!(m instanceof ParcelModel)) break;
                    return stop;
                }
                case POI: {
                    if (!(m instanceof PoiModel)) break;
                    return stop;
                }
                case STOP: {
                    break;
                }
                case SUBSCRIPTION: {
                    if (!(m instanceof SubscriptionModel)) break;
                    return stop;
                }
            }
        }
        return found;
    }

    private Set<Coordinate> createAreaRectangles(List<Model> models) {
        if (models.isEmpty()) {
            return null;
        }
        HashSet<Coordinate> coords = new HashSet<Coordinate>();
        for (Model model : models) {
            LetterModel letter;
            if (model instanceof ParcelModel) {
                ParcelModel parcel = (ParcelModel)model;
                if (!ParcelModelUtil.checkGeomOfParcel(parcel)) continue;
                coords.add(parcel.getGeom().getCoordinate());
                continue;
            }
            if (model instanceof SubscriptionModel) {
                SubscriptionModel subscription = (SubscriptionModel)model;
                if (!SubscriptionModelUtil.checkGeomOfSubscription(subscription)) continue;
                coords.add(SubscriptionModelUtil.getGeom(subscription).getCoordinate());
                continue;
            }
            if (!(model instanceof LetterModel) || !LetterModelUtil.checkGeomOfLetter(letter = (LetterModel)model)) continue;
            coords.add(LetterModelUtil.getGeom(letter).getCoordinate());
        }
        if (coords.isEmpty()) {
            return null;
        }
        return coords;
    }

    private void initializedMapPanel(Coordinate startCoordinate) throws IOException {
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        this.navigatorPanel = new NavigatorPanel(startCoordinate, OpenStreetmapViewFactory.INSTANCE, (Container)this);
        this.navigatorPanel.setPanning(true);
        if (this.navigatorPanel.getPanningAction() != null) {
            this.navigatorPanel.getPanningAction().setSelected(true);
        }
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        this.addRenderers();
    }

    private void addRenderers() throws IOException {
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        this.addRenderer(osmNavigatorRenderer);
        DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(100000.0, this.navigatorPanel.getCoordinateFactory(), AreaManagerMapGui.createAreaGeomExtractor());
        bucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                Collection<AreaObjectModel> areaObjects = Collections.emptySet();
                if (AreaManagerMapGui.this.getPostcodeAreaLayer() != null) {
                    AreaCaller areaCaller = AreaManagerMapGui.this.getModelEnviroment().getAllCaller().getAreaCaller();
                    areaObjects = areaCaller.fetchAreaObjects(AreaManagerMapGui.this.getPostcodeAreaLayer(), topLeft, bottomRight);
                }
                return areaObjects;
            }
        });
        bucketsModel.setBusyHandler(this.areaManager.getBusyHandler());
        this.postcodeLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Renderer for Postcodes", bucketsModel, AreaManagerMapGui.createAreaGeomExtractor(), "postcode", this.getModelEnviroment(), null, true, this.navigatorPanel);
        this.postcodeLayerRenderer.setActive(false);
        this.addRenderer(this.postcodeLayerRenderer);
        ParcelLayerRenderer parcelLayerRenderer = new ParcelLayerRenderer(this, this.modelEnviroment, false);
        this.addRenderer(parcelLayerRenderer);
        SubscriptionLayerRenderer subscriptionLayerRenderer = new SubscriptionLayerRenderer(this, this.modelEnviroment, false);
        this.addRenderer(subscriptionLayerRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        this.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        this.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
    }

    private Set<DefaultMutableTreeNode> getExpandedNodes(DefaultMutableTreeNode rootNode) {
        HashSet<DefaultMutableTreeNode> expandedNodes = new HashSet<DefaultMutableTreeNode>();
        for (int i1 = 0; i1 < rootNode.getChildCount(); ++i1) {
            DefaultMutableTreeNode n1 = (DefaultMutableTreeNode)rootNode.getChildAt(i1);
            if (!this.areaLegendTree.isExpanded(new TreePath(n1.getPath()))) continue;
            expandedNodes.add(n1);
            for (int i2 = 0; i2 < n1.getChildCount(); ++i2) {
                DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)n1.getChildAt(i2);
                if (!this.areaLegendTree.isExpanded(new TreePath(n2.getPath()))) continue;
                expandedNodes.add(n2);
                for (int i3 = 0; i3 < n2.getChildCount(); ++i3) {
                    DefaultMutableTreeNode n3 = (DefaultMutableTreeNode)n2.getChildAt(i3);
                    if (!this.areaLegendTree.isExpanded(new TreePath(n3.getPath()))) continue;
                    expandedNodes.add(n3);
                }
            }
        }
        return expandedNodes;
    }

    public void addRenderer(NavigatorRenderer navigatorRenderer) {
        navigatorRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(navigatorRenderer);
    }

    public void removeRenderer(NavigatorRenderer navigatorRenderer) {
        if (navigatorRenderer != null) {
            navigatorRenderer.setNavigatorPanel(null);
            this.navigatorPanel.removeRenderer(navigatorRenderer);
        }
    }

    public void center() {
        if (this.areaRectangles == null || this.areaRectangles.isEmpty()) {
            return;
        }
        this.navigatorPanel.center(this.areaRectangles, 10);
    }

    @Override
    public void setAreaRectangles(Set<Coordinate> areaRectangles) {
        this.areaRectangles = areaRectangles;
    }

    @Override
    public AreaLayerModel getLayer() {
        return this.areaManager.getCurrentLayer();
    }

    public DefaultMutableTreeNode getSelObjectFromLegendTree() {
        int selRow = this.areaLegendTree.getLeadSelectionRow();
        if (selRow < 1) {
            return null;
        }
        DefaultMutableTreeNode treeMode = (DefaultMutableTreeNode)this.areaLegendTree.getLastSelectedPathComponent();
        return treeMode;
    }

    @Override
    public Component getPane() {
        return this.areaManager.getTabbedPane();
    }

    public AreaManagerCalendarGui getAreaManager() {
        return this.areaManager;
    }

    private static GeomExtractor<AreaObjectModel, ImmutablePolygonKind> createAreaGeomExtractor() {
        return new GeomExtractor<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectModel areaObject) {
                return areaObject.getGeom();
            }
        };
    }

    public AreaLayerModel getPostcodeAreaLayer() {
        return this.postcodeAreaLayer;
    }

    public void setPostcodeAreaLayer(AreaLayerModel postcodeAreaLayer) {
        this.postcodeAreaLayer = postcodeAreaLayer;
    }

    public AreaLayerRenderer getPostcodeLayerRenderer() {
        return this.postcodeLayerRenderer;
    }

    public void addAreaTourMapNode(AreaObjectModel area, HistoryAreaTourModelWageResult historyResult) {
        if (historyResult == null || historyResult.getModel() == null) {
            return;
        }
        AreaObjectMapNode areaNode = this.getAreaObjectMapNode(area, true);
        AreaObjectHistoryTourMapNode historyNode = new AreaObjectHistoryTourMapNode(area, historyResult);
        historyNode.setColor(areaNode.getColor());
        AllObjectFilterLayerRenderer renderer = new AllObjectFilterLayerRenderer(true);
        renderer.setLegendType(AreaObjectTourLegendType.HISTORY);
        renderer.setArea(area, areaNode.getColor());
        renderer.setSortOrder(areaNode.getSortOrder());
        LogisticTourDto<PointEntityId> logisticTourDto = historyResult.createLogisticTour();
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        try {
            logisticTourDto = tourCaller.calculateLogisticTour(logisticTourDto, false);
        }
        catch (LogisticException e) {
            ErrorMessagesDialog.creatAndShow(e.getLocalizedMessage(), this);
        }
        renderer.setSharp(logisticTourDto);
        historyNode.setAllObjectFilterLayerRenderer(renderer);
        areaNode.addTourNodes(historyNode, this);
        historyNode.addAttributeNodes();
    }

    public void addAreaTourMapNode(AreaObjectModel area, AreaObjectLogisticTourMapNode tourNode) {
        AreaObjectMapNode areaNode = this.getAreaObjectMapNode(area, true);
        areaNode.addTourNodes(tourNode, this);
        this.loadLogisticTourMapNode(tourNode);
    }

    public void addAreaGroupMapNode(List<AreaObjectModel> areas, String groupName, AreaObjectLogisticTourMapNode tourNode) {
        AreaGroupMapNode groupNode = this.getAreaGroupMapNode(areas, groupName);
        groupNode.addTourNodes(tourNode, this);
        this.loadLogisticTourMapNode(tourNode);
    }

    private void loadLogisticTourMapNode(AreaObjectLogisticTourMapNode tourNode) {
        tourNode.addAttributeNodes();
        this.loadLogisticStopsNode(tourNode);
        this.loadLogisticTourRenderer(tourNode);
    }

    private void loadLogisticTourRenderer(AreaObjectLogisticTourMapNode tourNode) {
        LogisticTourDto<PointEntityId> tour = tourNode.getTour();
        AllObjectFilterLayerRenderer renderer = tourNode.getAllObjectFilterLayerRenderer();
        AreaTourExportModelsHolder holder = tourNode.getModelsHolder();
        renderer.setObjects(holder.getStartPois(), holder.getEndPois(), holder.getStartPickPoints(), holder.getEndPickPoints(), holder.getOrderedModels(), holder.getNullGeomModels(), tourNode.getParameter().getAreaTourType());
        renderer.setSharp(tour);
    }

    private void loadLogisticStopsNode(AreaObjectLogisticTourMapNode tourNode) {
        DefaultMutableTreeNode stopsNode = new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("gui.address.list", new Serializable[0]));
        tourNode.add(stopsNode);
        LegendObjectHelper helper = new LegendObjectHelper(this.modelEnviroment);
        List<LegendObject<? extends Model>> ls = helper.creatLegend(tourNode.getTour(), tourNode.getModelsHolder());
        for (LegendObject<? extends Model> legendObject : ls) {
            AreaStopNode<LegendObject<? extends Model>> stopNode = new AreaStopNode<LegendObject<? extends Model>>(legendObject, legendObject.getSortOrder(), Color.BLACK);
            stopsNode.add(stopNode);
        }
    }

    private AreaObjectMapNode getAreaObjectMapNode(AreaObjectModel area, boolean addIfNotPresent) {
        AreaObjectMapNode found = null;
        int maxSortOrder = AllObjectFilterLayerRenderer.MIN_AREA_SORT_ORDER - 10;
        for (AreaObjectMapNode node : this.areaMapNodes) {
            if (node == null || node instanceof AreaGroupMapNode) continue;
            if (node.getAreaObject() != null && node.getAreaObject().equals(area)) {
                found = node;
            }
            if (node.getSortOrder() <= maxSortOrder) continue;
            maxSortOrder = node.getSortOrder();
        }
        if (found == null && addIfNotPresent) {
            found = new AreaObjectMapNode(area);
            Color color = AllObjectFilterLayerRenderer.AREAOBJECT_COLOR_CACHE.get(area);
            if (color == null) {
                color = this.currentAreaColor = GeoUtil.getNextColor(this.currentAreaColor);
                AllObjectFilterLayerRenderer.AREAOBJECT_COLOR_CACHE.put(area, color);
            }
            found.setColor(color);
            found.setSortOrder(maxSortOrder + 10);
            this.areaMapNodes.add(found);
        }
        return found;
    }

    private AreaGroupMapNode getAreaGroupMapNode(List<AreaObjectModel> areas, String groupName) {
        AreaGroupMapNode found = null;
        int maxSortOrder = AllObjectFilterLayerRenderer.MIN_AREA_SORT_ORDER - 10;
        for (AreaObjectMapNode node : this.areaMapNodes) {
            if (node == null || !(node instanceof AreaGroupMapNode)) continue;
            AreaGroupMapNode groupNode = (AreaGroupMapNode)node;
            if (groupNode.getGroupName().equals(groupName)) {
                found = groupNode;
            }
            if (node.getSortOrder() <= maxSortOrder) continue;
            maxSortOrder = node.getSortOrder();
        }
        if (found == null) {
            found = new AreaGroupMapNode(areas, groupName);
            Color color = AllObjectFilterLayerRenderer.AREAOBJECT_COLOR_CACHE.get(areas.get(0));
            if (color == null) {
                color = this.currentAreaColor = GeoUtil.getNextColor(this.currentAreaColor);
                AllObjectFilterLayerRenderer.AREAOBJECT_COLOR_CACHE.put(areas.get(0), color);
            }
            found.setColor(color);
            found.setSortOrder(maxSortOrder + 10);
            this.areaMapNodes.add(found);
        }
        return found;
    }

    private void loadAreaLegendPane() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.areaLegendTreeModel.getRoot();
        Set<DefaultMutableTreeNode> expandedNodes = this.getExpandedNodes(root);
        root.removeAllChildren();
        Collections.sort(this.areaMapNodes, new Comparator<AreaObjectMapNode>(){

            @Override
            public int compare(AreaObjectMapNode o1, AreaObjectMapNode o2) {
                String s1 = StringUtil.getNotNull(o1.getAreaObject() == null ? "" : o1.getAreaObject().getShortcut());
                String s2 = StringUtil.getNotNull(o2.getAreaObject() == null ? "" : o2.getAreaObject().getShortcut());
                return s1.compareToIgnoreCase(s2);
            }
        });
        TreePath rootPath = new TreePath(root);
        HashSet<TreePath> expandedTreePath = new HashSet<TreePath>();
        for (AreaObjectMapNode node : this.areaMapNodes) {
            if (node == null || node.getAreaObject() == null || node.getTourNodes().isEmpty()) continue;
            root.add(node);
            if (!expandedNodes.contains(node)) continue;
            TreePath nodePath = rootPath.pathByAddingChild(node);
            expandedTreePath.add(nodePath);
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                TreeNode n2 = node.getChildAt(i2);
                if (!expandedNodes.contains(n2)) continue;
                TreePath n2Path = nodePath.pathByAddingChild(n2);
                expandedTreePath.add(n2Path);
                for (int i3 = 0; i3 < n2.getChildCount(); ++i3) {
                    TreeNode n3 = n2.getChildAt(i3);
                    if (!expandedNodes.contains(n3)) continue;
                    expandedTreePath.add(n2Path.pathByAddingChild(n3));
                }
            }
        }
        this.areaLegendTreeModel.reload();
        for (TreePath treePath : expandedTreePath) {
            this.areaLegendTree.expandPath(treePath);
        }
    }

    public void clearAreaMapNodes() {
        for (AreaObjectMapNode node : this.areaMapNodes) {
            if (node == null) continue;
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                AreaObjectTourMapNode nextElement = (AreaObjectTourMapNode)children.nextElement();
                this.removeRenderer(nextElement.getAllObjectFilterLayerRenderer());
            }
        }
        this.areaMapNodes.clear();
        this.loadAreaLegendPane();
    }

    public void removeAreaTourMapNode(AreaObjectTourMapNode<?> tourNode) {
        for (AreaObjectMapNode node : this.areaMapNodes) {
            if (node == null || !node.getTourNodes().remove(tourNode)) continue;
            node.remove(tourNode);
        }
        this.removeRenderer(tourNode.getAllObjectFilterLayerRenderer());
        this.loadAreaLegendPane();
    }

    public JTree getAreaLegendTree() {
        return this.areaLegendTree;
    }

    public Set<AreaObjectLogisticTourMapNode> getChangedLogisticTourNodes() {
        return this.changedLogisticTourNodes;
    }

    public int getAreaSortOrder(AreaObjectModel area) {
        AreaObjectMapNode areaObjectMapNode = this.getAreaObjectMapNode(area, true);
        return areaObjectMapNode.getSortOrder();
    }

    public List<AreaObjectHistoryTourMapNode> getHistoryTourNodes() {
        ArrayList<AreaObjectHistoryTourMapNode> nodes = new ArrayList<AreaObjectHistoryTourMapNode>();
        for (AreaObjectMapNode areaNode : this.areaMapNodes) {
            for (AreaObjectTourMapNode<?> tourNode : areaNode.getTourNodes()) {
                if (!(tourNode instanceof AreaObjectHistoryTourMapNode)) continue;
                nodes.add((AreaObjectHistoryTourMapNode)tourNode);
            }
        }
        return nodes;
    }

    public List<AreaObjectLogisticTourMapNode> getLogisticTourNodes() {
        ArrayList<AreaObjectLogisticTourMapNode> nodes = new ArrayList<AreaObjectLogisticTourMapNode>();
        for (AreaObjectMapNode areaNode : this.areaMapNodes) {
            for (AreaObjectTourMapNode<?> tourNode : areaNode.getTourNodes()) {
                if (!(tourNode instanceof AreaObjectLogisticTourMapNode)) continue;
                nodes.add((AreaObjectLogisticTourMapNode)tourNode);
            }
        }
        return nodes;
    }

    public List<Model> getCurrentlyShownModelsForArea(AreaObjectModel area, AreaObjectTourLegendType tourLegendType) {
        List<AreaObjectTourMapNode<?>> tourNodes;
        AreaObjectMapNode areaObjectMapNode;
        if (tourLegendType != null && (areaObjectMapNode = this.getAreaObjectMapNode(area, false)) != null && (tourNodes = areaObjectMapNode.getTourNodes()) != null) {
            for (AreaObjectTourMapNode<?> tourNode : tourNodes) {
                if (tourNode.getType() != tourLegendType) continue;
                LinkedList<Model> models = new LinkedList<Model>();
                List<AreaStopNode<?>> allStopNodes = tourNode.getAllStopNodes();
                for (AreaStopNode<?> stopNode : allStopNodes) {
                    LegendObject legendObject = (LegendObject)stopNode.getAreaStop();
                    models.add((Model)legendObject.getM());
                }
                return models;
            }
        }
        return null;
    }
}

