/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.action.AreaManagerActions;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.type.UserRole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.ktde.util.datatypes.Tupel;

public class AreaManagerControlPane
extends JPanel {
    private static final long serialVersionUID = 6619022229822651115L;
    private AreaManagerCalendarGui areaManager;
    private AreaManagerActions actions;
    private JMenu filterSubMenu;

    public AreaManagerControlPane(AreaManagerCalendarGui areaManager) {
        super(new BorderLayout());
        this.areaManager = areaManager;
        this.actions = areaManager.getActions();
        this.initialize();
    }

    public void initialize() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createDisplayMenu());
        menuBar.add(this.createSearchMenu());
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.AREA_VIEWER, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            JMenu tourMenu = this.createTourMenu();
            menuBar.add(tourMenu);
        }
        menuBar.add(this.createPrintMenu());
        this.add((Component)menuBar, "Center");
    }

    private JMenu createSearchMenu() {
        JMenu searchAddressMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0]));
        Tupel<SearchLocationAction, Action> searchMenuEntries = SearchLocationAction.createButtonTupel(this.areaManager, this.areaManager.getCurrentNavigatorPanel(), this.areaManager.getModelEnviroment(), false, false);
        JMenuItem locationSearchItem = new JMenuItem(searchMenuEntries.getElement1());
        searchAddressMenu.add(locationSearchItem);
        searchAddressMenu.addSeparator();
        searchAddressMenu.add(searchMenuEntries.getElement2());
        Set<Action> actionsOnlyForMap = this.areaManager.getActionsOnlyForMap();
        actionsOnlyForMap.add(searchMenuEntries.getElement1());
        actionsOnlyForMap.add(searchMenuEntries.getElement2());
        searchAddressMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return searchAddressMenu;
    }

    private JMenu createPrintMenu() {
        JMenu printScheduleMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.print", new Serializable[0]));
        JMenuItem printItem = new JMenuItem(this.actions.getAllPrintAction());
        printScheduleMenu.add(printItem);
        printScheduleMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return printScheduleMenu;
    }

    private JMenu createDisplayMenu() {
        JMenu displayMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.display", new Serializable[0]));
        JMenuItem showSelectedTours = new JMenuItem(this.actions.getShowSelectedSchedulesAction());
        displayMenu.add(showSelectedTours);
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            displayMenu.addSeparator();
            Action showParcelAction = this.actions.getShowParcelAction();
            Action showSubscriptionAction = this.actions.getShowSubscriptionAction();
            Action showPostcodeAction = this.actions.getShowPostcodeAction();
            displayMenu.add(new JCheckBoxMenuItem(showParcelAction));
            displayMenu.add(new JCheckBoxMenuItem(showSubscriptionAction));
            displayMenu.add(new JCheckBoxMenuItem(showPostcodeAction));
            Set<Action> actionsOnlyForMap = this.areaManager.getActionsOnlyForMap();
            actionsOnlyForMap.add(showParcelAction);
            actionsOnlyForMap.add(showSubscriptionAction);
            actionsOnlyForMap.add(showPostcodeAction);
        }
        displayMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return displayMenu;
    }

    private JMenu createEditMenu() {
        JMenu edit = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]));
        JMenuItem saveChanges = new JMenuItem(this.actions.getSaveAction());
        edit.add(saveChanges);
        JMenuItem undo = new JMenuItem(this.actions.getUndoAction());
        edit.add(undo);
        JMenuItem redo = new JMenuItem(this.actions.getRedoAction());
        edit.add(redo);
        JMenuItem revertChanges = new JMenuItem(this.actions.getRevertAction());
        edit.add(revertChanges);
        edit.add(new JMenuItem(this.actions.getSaveSortOrderAction()));
        if (ModelEnviroment.getUserInformation().hasUserRole(UserRole.ADMIN)) {
            edit.add(new JMenuItem(this.actions.getClearDistanceMatrixAction()));
        }
        edit.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return edit;
    }

    private JMenu createTourMenu() {
        JMenu tourMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tours", new Serializable[0]));
        JMenuItem calculateAreas = new JMenuItem(this.actions.getCalculateAreasAction());
        tourMenu.add(calculateAreas);
        tourMenu.addSeparator();
        tourMenu.add(new JMenuItem(this.actions.getSetAreaTourRendererAction()));
        tourMenu.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return tourMenu;
    }

    public void loadFilterSubMenu() {
        this.filterSubMenu.removeAll();
        for (FilterEntity filterEntity : this.areaManager.getFilters()) {
            JMenuItem filterItem = new JMenuItem(this.actions.getFilterAction(filterEntity));
            this.filterSubMenu.add(filterItem);
        }
        this.filterSubMenu.revalidate();
        this.filterSubMenu.repaint();
    }
}

