/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.action.AreaManagerActions;
import de.datomino.peppergis.areamanager.gui.AreaDelivererTreeGui;
import de.datomino.peppergis.areamanager.gui.AreaManagerControlPane;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.AreaSchedulePlanTable;
import de.datomino.peppergis.areamanager.listener.AreaDelivererTreeListener;
import de.datomino.peppergis.areamanager.listener.SchedulePlanTableListener;
import de.datomino.peppergis.areamanager.model.AreaScheduleTimeBucketModel;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.blocking.BusyDialogShowingBusyHandler;
import de.datomino.peppergis.client.gui.common.FilteredListSelectorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.CalendarGui;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.manager.model.TimeExtractor;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.blocking.BusyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.IOUtils;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AreaManagerCalendarGui
extends JPanel {
    private static final long serialVersionUID = 6803525709827208920L;
    private CalendarGui calendarGui;
    private BusyHandler busyHandler;
    private ModelEnviroment modelEnviroment;
    private AreaManagerMapGui areaTourMapGui;
    private JTabbedPane tabbedPane;
    private AreaManagerControlPane controlGui;
    private AreaManagerActions actions;
    private List<FilterEntity> filters;
    private AreaSchedulePlanTable planTablePane;
    private AreaLayerModel currentLayer;
    private List<AreaObjectModel> areaObjects;
    private AreaScheduleTimeBucketModel scheduleBucketModel;
    private AreaDelivererTreeGui delivererGui;
    private Set<Action> actionsOnlyForMap;

    public AreaManagerCalendarGui(ModelEnviroment modelEnviroment, Long areaLayerId) throws IOException {
        super(new BorderLayout());
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.modelEnviroment = modelEnviroment;
        this.busyHandler = new BusyDialogShowingBusyHandler(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]));
        if (areaLayerId != null) {
            AreaCaller areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
            this.currentLayer = areaCaller.getAreaLayer(areaLayerId);
            this.areaObjects = areaCaller.fetchAreaObjectsByAreaLayer(this.currentLayer, true);
        } else {
            this.areaObjects = Collections.emptyList();
        }
        this.initialise();
    }

    private void initialise() throws IOException {
        this.calendarGui = new CalendarGui(){

            @Override
            public void update() {
                String dateString;
                super.update();
                if (AreaManagerCalendarGui.this.delivererGui == null || AreaManagerCalendarGui.this.planTablePane == null) {
                    return;
                }
                AreaManagerCalendarGui.this.delivererGui.getDelivererJTree().repaint();
                int dayOfWeek = this.calendar.get(7);
                if (dayOfWeek == 1) {
                    dayOfWeek = 8;
                }
                if (this.isSameWeek((dateString = AreaManagerCalendarGui.this.planTablePane.getColumnHeader()[dayOfWeek - 1].split("\n")[2]).split(" - "))) {
                    if (AreaManagerCalendarGui.this.scheduleBucketModel.isDayFilter()) {
                        AreaManagerCalendarGui.this.scheduleBucketModel.setCurrentDay(this.getCurrentDate());
                        AreaManagerCalendarGui.this.planTablePane.clearSelectedObjects();
                        AreaManagerCalendarGui.this.planTablePane.createPlanTable();
                    }
                    return;
                }
                this.calendar.add(5, 1 - dayOfWeek);
                int sumOfColumn = AreaManagerCalendarGui.this.planTablePane.getColumnHeader().length;
                for (int i = 1; i < sumOfColumn; ++i) {
                    String oldHeader = AreaManagerCalendarGui.this.planTablePane.getColumnHeader()[i];
                    this.calendar.add(5, 1);
                    ((AreaManagerCalendarGui)AreaManagerCalendarGui.this).planTablePane.getColumnHeader()[i] = this.changDayInHeader(oldHeader, this.calendar);
                }
                AreaManagerCalendarGui.this.planTablePane.clearSelectedObjects();
                AreaManagerCalendarGui.this.planTablePane.createPlanTable();
            }
        };
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)ClientSwingUtil.createPanelForComponent(this.calendarGui.createCalendarGui(), ModelEnviroment.getMessageResolver().resolveMessage("gui.date.monthlyCalendar", new Serializable[0])), "First");
        this.scheduleBucketModel = new AreaScheduleTimeBucketModel(new TimeExtractor<AreaScheduleEntity>(){

            @Override
            public Date getTime(AreaScheduleEntity schedule) {
                return schedule.getModel().iterator().next().getPlannedStartTime();
            }
        }, this.modelEnviroment, this.busyHandler, this.currentLayer);
        JPanel middlePanel = new JPanel(new BorderLayout());
        if (!NavigatorPanel.HEADLESS) {
            this.planTablePane = new AreaSchedulePlanTable(this);
            middlePanel.add(ClientSwingUtil.createPanelForComponent(this.planTablePane.createPlanPane("Gebiet", 2), ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plan", new Serializable[0])));
        }
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.delivererGui = new AreaDelivererTreeGui();
        List deliverers = this.currentLayer == null ? Collections.emptyList() : this.modelEnviroment.getAllCaller().getTourCaller().fetchAllAreaDeliverersForAreaLayer(Collections.singleton(this.currentLayer));
        List<BranchModel> allBranches = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs();
        HashSet<BranchModel> branches = new HashSet<BranchModel>();
        for (BranchModel branch : allBranches) {
            if (branch == null || branch.getBranchType() != BranchType.AREA_TOUR_DELIVERER) continue;
            branches.add(branch);
        }
        rightPanel.add(ClientSwingUtil.createPanelForComponent(this.delivererGui.createDelivererGui(new LinkedList<AreaDelivererModel>(deliverers), branches, this), ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.logisticII.list", new Serializable[0])));
        rightPanel.add(this.createLogoPanel(ModelEnviroment.getProperties().getProperty("companylogo")));
        JPanel areaFilterPane = this.createAreaFilterPane();
        leftPanel.add((Component)areaFilterPane, "Center");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel planPanel = new JPanel();
        planPanel.setLayout(new BorderLayout());
        planPanel.add((Component)middlePanel, "Center");
        planPanel.add((Component)rightPanel, "East");
        JSplitPane managementSplitPane = new JSplitPane(1, new JScrollPane(leftPanel), planPanel);
        managementSplitPane.setOneTouchExpandable(true);
        this.areaTourMapGui = new AreaManagerMapGui(this);
        this.areaTourMapGui.initialized(this.getStartCoordinate());
        this.tabbedPane = new JTabbedPane(3, 0);
        this.tabbedPane.addTab("Verwaltung", managementSplitPane);
        this.tabbedPane.addTab("Tourkarte", this.areaTourMapGui);
        this.controlGui = new AreaManagerControlPane(this);
        this.add((Component)this.controlGui, "North");
        this.add((Component)this.tabbedPane, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.areaTourMapGui.getNavigatorPanel().addKeyListenerToContainer(this);
        if (!NavigatorPanel.HEADLESS) {
            this.addListeners(managementSplitPane);
        }
        this.firePlanPaneSelection();
    }

    private JPanel createAreaFilterPane() {
        JPanel filterPane = new JPanel(new SpringLayout());
        JPanel subPane1 = new JPanel(new SpringLayout());
        int visibleRowCount = 4;
        subPane1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0])));
        final FilteredListSelectorPane<AreaObjectModel> areaNumberSelectorPane = new FilteredListSelectorPane<AreaObjectModel>(this.areaObjects, true, visibleRowCount){
            private static final long serialVersionUID = -9128691153665969587L;

            @Override
            protected String getString(AreaObjectModel t) {
                return StringUtil.getNotNull(t == null ? null : t.getShortcut());
            }
        };
        subPane1.add(areaNumberSelectorPane);
        subPane1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.name", new Serializable[0])));
        final FilteredListSelectorPane<AreaObjectModel> areaNameSelectorPane = new FilteredListSelectorPane<AreaObjectModel>(this.areaObjects, true, visibleRowCount){
            private static final long serialVersionUID = -9128691153665969587L;

            @Override
            protected String getString(AreaObjectModel t) {
                return StringUtil.getNotNull(t == null ? null : t.getDisplayname());
            }
        };
        subPane1.add(areaNameSelectorPane);
        subPane1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.personNumber", new Serializable[0])));
        final FilteredListSelectorPane<AreaDelivererModel> delivererNumberSelectorPane = new FilteredListSelectorPane<AreaDelivererModel>(this.delivererGui.getAllDeliverers(), true, visibleRowCount){
            private static final long serialVersionUID = 3288321106105815749L;

            @Override
            protected String getString(AreaDelivererModel t) {
                return StringUtil.getNotNull(t == null ? null : t.getDelivererNumber());
            }
        };
        subPane1.add(delivererNumberSelectorPane);
        subPane1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.personName", new Serializable[0])));
        final FilteredListSelectorPane<AreaDelivererModel> delivererNameSelectorPane = new FilteredListSelectorPane<AreaDelivererModel>(this.delivererGui.getAllDeliverers(), true, visibleRowCount){
            private static final long serialVersionUID = 3288321106105815749L;

            @Override
            protected String getString(AreaDelivererModel t) {
                return StringUtil.getNotNull(t == null ? null : t.getName());
            }
        };
        subPane1.add(delivererNameSelectorPane);
        JPanel subPane2 = new JPanel(new SpringLayout());
        final JCheckBox unplanned = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.schedule.unplannedAreas", new Serializable[0]));
        subPane2.add(unplanned);
        final JList<DelivererStatus> status = new JList<DelivererStatus>(new DelivererStatus[]{DelivererStatus.VACANT, DelivererStatus.OCCUPIED, DelivererStatus.ILLNESS, DelivererStatus.VACATION, DelivererStatus.RETRAINING, DelivererStatus.DELETED});
        status.setVisibleRowCount(visibleRowCount);
        status.setCellRenderer((ListCellRenderer<DelivererStatus>)new AbstractListCellRenderer<DelivererStatus>(){

            @Override
            protected String getStringFromValue(DelivererStatus object) {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(object);
            }
        });
        subPane2.add(new JScrollPane(status));
        subPane1.add(new JLabel(""));
        JPanel search1 = new JPanel(new FlowLayout(2));
        search1.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.clear", new Serializable[0])){
            private static final long serialVersionUID = -3454729640834788861L;

            @Override
            public void actionPerformed(ActionEvent e) {
                areaNumberSelectorPane.clearSelection();
                areaNameSelectorPane.clearSelection();
                delivererNumberSelectorPane.clearSelection();
                delivererNameSelectorPane.clearSelection();
                AreaManagerCalendarGui.this.scheduleBucketModel.clearWeekFilter();
                AreaManagerCalendarGui.this.planTablePane.clearSelectedObjects();
                AreaManagerCalendarGui.this.planTablePane.createPlanTable();
            }
        }));
        search1.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = -8564092251354633585L;

            @Override
            public void actionPerformed(ActionEvent e) {
                unplanned.setSelected(false);
                status.clearSelection();
                HashSet<AreaObjectModel> selectedAreas = new HashSet<AreaObjectModel>(areaNumberSelectorPane.getSelectedValues(false));
                selectedAreas.addAll(areaNameSelectorPane.getSelectedValues(false));
                if (selectedAreas.isEmpty() || selectedAreas.size() == 1 && selectedAreas.iterator().next() == null) {
                    selectedAreas = null;
                } else {
                    selectedAreas.remove(null);
                }
                HashSet<AreaDelivererModel> selectedDeliverers = new HashSet<AreaDelivererModel>(delivererNumberSelectorPane.getSelectedValues(false));
                selectedDeliverers.addAll(delivererNameSelectorPane.getSelectedValues(false));
                if (selectedDeliverers.isEmpty() || selectedDeliverers.size() == 1 && selectedDeliverers.iterator().next() == null) {
                    selectedDeliverers = null;
                } else {
                    selectedDeliverers.remove(null);
                }
                AreaManagerCalendarGui.this.scheduleBucketModel.activeWeekFilter(selectedAreas, selectedDeliverers);
                AreaManagerCalendarGui.this.planTablePane.clearSelectedObjects();
                AreaManagerCalendarGui.this.planTablePane.createPlanTable();
            }
        }));
        subPane1.add(search1);
        SpringUtilities.makeCompactGrid(subPane1, 5, 2, 5, 5, 5, 5);
        filterPane.add(ClientSwingUtil.createPanelForComponent(subPane1, ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.week", new Serializable[0])));
        JPanel search2 = new JPanel(new FlowLayout(2));
        search2.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.clear", new Serializable[0])){
            private static final long serialVersionUID = -7176129096081989169L;

            @Override
            public void actionPerformed(ActionEvent e) {
                unplanned.setSelected(false);
                status.clearSelection();
                AreaManagerCalendarGui.this.scheduleBucketModel.clearDayFilter();
                AreaManagerCalendarGui.this.planTablePane.clearSelectedObjects();
                AreaManagerCalendarGui.this.planTablePane.createPlanTable();
            }
        }));
        search2.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = -4730825946804790600L;

            @Override
            public void actionPerformed(ActionEvent e) {
                areaNumberSelectorPane.clearSelection();
                areaNameSelectorPane.clearSelection();
                delivererNumberSelectorPane.clearSelection();
                delivererNameSelectorPane.clearSelection();
                AreaManagerCalendarGui.this.scheduleBucketModel.setDayFilter(AreaManagerCalendarGui.this.calendarGui.getCurrentDate(), unplanned.isSelected(), status.getSelectedValuesList());
                AreaManagerCalendarGui.this.planTablePane.clearSelectedObjects();
                AreaManagerCalendarGui.this.planTablePane.createPlanTable();
            }
        }));
        subPane2.add(search2);
        SpringUtilities.makeCompactGrid(subPane2, 3, 1, 5, 5, 5, 5);
        filterPane.add(ClientSwingUtil.createPanelForComponent(subPane2, ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.day", new Serializable[0])));
        SpringUtilities.makeCompactGrid(filterPane, 2, 1, 0, 0, 0, 0);
        return filterPane;
    }

    private JPanel createLogoPanel(String companyLogo) {
        ImageIcon logoImageIconSource;
        if (companyLogo == null) {
            companyLogo = "/images/LOGO_BS.jpg";
        }
        try {
            logoImageIconSource = new ImageIcon(IOUtils.toByteArray(this.getClass().getResourceAsStream(companyLogo)));
        }
        catch (IOException e) {
            return new JPanel();
        }
        Image logoImage = logoImageIconSource.getImage().getScaledInstance(ClientFormUtil.SIZEOFLISTANDTREE.width, ClientFormUtil.SIZEOFLISTANDTREE.height, 1);
        JLabel logoLabel = new JLabel(new ImageIcon(logoImage));
        logoLabel.setPreferredSize(ClientFormUtil.SIZEOFLISTANDTREE);
        JPanel logoPanel = new JPanel();
        logoPanel.add(logoLabel);
        return logoPanel;
    }

    private Coordinate getStartCoordinate() {
        String startString = ModelEnviroment.getProperties().getProperty("navigator.startCoordinate");
        Coordinate startCoordinate = null;
        if (startString != null) {
            try {
                Tupel<String, String[]> tupel = StringUtil.parseTokens(startString);
                CoordinateFactory factory = CoordinateFactory.getInstance(tupel.getElement1());
                startCoordinate = factory.createCoordinate(Double.valueOf(tupel.getElement2()[0]), Double.valueOf(tupel.getElement2()[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        return startCoordinate;
    }

    private void addListeners(final JSplitPane managementSplitPane) {
        SchedulePlanTableListener areaTourPlanTableListener = new SchedulePlanTableListener(this);
        this.planTablePane.getPlanTable().addMouseListener(areaTourPlanTableListener);
        AreaDelivererTreeListener delivererTreeListener = new AreaDelivererTreeListener(this);
        this.delivererGui.getDelivererJTree().addMouseListener(delivererTreeListener);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComponent = AreaManagerCalendarGui.this.tabbedPane.getSelectedComponent();
                if (selectedComponent.equals(managementSplitPane)) {
                    AreaManagerCalendarGui.this.firePlanPaneSelection();
                } else if (selectedComponent.equals(AreaManagerCalendarGui.this.areaTourMapGui)) {
                    AreaManagerCalendarGui.this.fireMapPaneSelection();
                }
            }
        });
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.PERSONAL_PLANNER)) {
            try {
                new DropTarget(this.planTablePane.getPlanTable(), 3, areaTourPlanTableListener);
                new DropTarget(this.delivererGui.getDelivererJTree(), 3, delivererTreeListener);
                DragSource dragSource = new DragSource();
                dragSource.createDefaultDragGestureRecognizer(this.planTablePane.getPlanTable(), 3, areaTourPlanTableListener);
                dragSource.createDefaultDragGestureRecognizer(this.delivererGui.getDelivererJTree(), 3, delivererTreeListener);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }

    private void fireMapPaneSelection() {
        for (Action a : this.getActionsOnlyForMap()) {
            if (a == null) continue;
            a.setEnabled(true);
        }
    }

    private void firePlanPaneSelection() {
        for (Action a : this.getActionsOnlyForMap()) {
            if (a == null) continue;
            a.setEnabled(false);
        }
    }

    public void actionBeforeClose() {
    }

    public NavigatorPanel getCurrentNavigatorPanel() {
        return this.areaTourMapGui.getNavigatorPanel();
    }

    public AreaManagerControlPane getControlGui() {
        return this.controlGui;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public AreaManagerActions getActions() {
        if (this.actions == null) {
            this.actions = new AreaManagerActions(this);
        }
        return this.actions;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public AreaManagerMapGui getAreaManagerMapGui() {
        return this.areaTourMapGui;
    }

    public List<FilterEntity> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterEntity>();
        }
        return this.filters;
    }

    public AreaSchedulePlanTable getPlanTablePane() {
        return this.planTablePane;
    }

    public BusyHandler getBusyHandler() {
        return this.busyHandler;
    }

    public CalendarGui getCalendarGui() {
        return this.calendarGui;
    }

    public List<AreaObjectModel> getAreaObjects() {
        return this.areaObjects;
    }

    public AreaScheduleTimeBucketModel getScheduleBucketModel() {
        return this.scheduleBucketModel;
    }

    public AreaDelivererTreeGui getDelivererGui() {
        return this.delivererGui;
    }

    public AreaLayerModel getCurrentLayer() {
        return this.currentLayer;
    }

    public Set<Action> getActionsOnlyForMap() {
        if (this.actionsOnlyForMap == null) {
            this.actionsOnlyForMap = new HashSet<Action>();
        }
        return this.actionsOnlyForMap;
    }

    public void consumeApplicationMessage(ApplicationMessage<?> message) {
        switch (message.getMessage()) {
            case REFRESH_MODELS: {
                Map idMap = (Map)message.getPayload();
                for (Class key : idMap.keySet()) {
                    Collection ids = (Collection)idMap.get(key);
                    if (ids == null) continue;
                    for (Long id : ids) {
                        this.modelEnviroment.getModelCache().refreshRek(key, id);
                    }
                }
                this.repaint(1L);
                break;
            }
        }
    }

    public List<Model> getCurrentlyShownModelsForArea(AreaObjectModel area, AreaObjectTourLegendType tourLegendType) {
        return this.areaTourMapGui.getCurrentlyShownModelsForArea(area, tourLegendType);
    }
}

