/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.areamanager.gui.legend.AreaGroupMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectHistoryTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectMapAttributeNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectTourMapNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopAttributeNode;
import de.datomino.peppergis.areamanager.gui.legend.AreaStopNode;
import de.datomino.peppergis.areamanager.gui.legend.LogisticStopNode;
import de.datomino.peppergis.areamanager.listener.AreaLegendTreeListener;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.manager.legend.LegendObjectHelper;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.dto.exporter.AreaTourExportDto;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.ktde.util.StringUtil;

public class AreaLegendTreeRenderer
implements TreeCellRenderer {
    private DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        AreaLegendTreeListener listerner = null;
        for (MouseListener l : tree.getMouseListeners()) {
            if (!(l instanceof AreaLegendTreeListener)) continue;
            listerner = (AreaLegendTreeListener)l;
            break;
        }
        this.renderer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.renderer.setIcon(null);
        if (value != null) {
            DefaultMutableTreeNode node;
            if (value instanceof AreaGroupMapNode) {
                node = (AreaGroupMapNode)value;
                this.renderer.setText(((AreaGroupMapNode)node).getGroupName());
                this.renderer.setForeground(((AreaObjectMapNode)node).getColor());
            } else if (value instanceof AreaObjectMapNode) {
                node = (AreaObjectMapNode)value;
                this.renderer.setText(AreaObjectModelUtil.getShortcutAndDisplayname(((AreaObjectMapNode)node).getAreaObject()));
                this.renderer.setForeground(((AreaObjectMapNode)node).getColor());
            } else if (value instanceof AreaObjectTourMapNode) {
                node = (AreaObjectTourMapNode)value;
                AreaObjectModel areaObject = ((AreaObjectTourMapNode)node).getAreaObject();
                String areaName = AreaObjectModelUtil.getShortcutAndDisplayname(areaObject);
                if (node.getParent() instanceof AreaGroupMapNode) {
                    AreaGroupMapNode parent = (AreaGroupMapNode)node.getParent();
                    ArrayList<String> ss = new ArrayList<String>();
                    for (AreaObjectModel a : parent.getAreaObjects()) {
                        ss.add(a.getShortcut());
                    }
                    areaName = StringUtil.implode(ss, " - ");
                }
                String vehicle = ModelEnviroment.getMessageResolver().resolveMessageForEnum(((AreaObjectTourMapNode)node).getType());
                if (node instanceof AreaObjectHistoryTourMapNode) {
                    AreaObjectHistoryTourMapNode tourNode = (AreaObjectHistoryTourMapNode)node;
                    String deliveryRound = ((HistoryAreaTourModelWageResult)tourNode.getUserObject()).getModel().getDeliveryRound();
                    vehicle = vehicle + (deliveryRound == null ? "" : " - " + deliveryRound);
                }
                this.renderer.setText(areaName + " (" + vehicle + ")" + " -- ");
                this.renderer.setForeground(((AreaObjectTourMapNode)node).getColor());
            } else if (value instanceof AreaObjectMapAttributeNode) {
                AreaObjectMapAttributeNode attributeNode = (AreaObjectMapAttributeNode)value;
                AreaObjectTourMapNode node2 = attributeNode.getNode();
                Object o = node2.getUserObject();
                if (o instanceof AreaTourExportDto) {
                    AreaTourParameter parameter = ((AreaObjectLogisticTourMapNode)node2).getParameter();
                    LogisticTourDto<PointEntityId> tour = ((AreaTourExportDto)o).getLogisticTourDto();
                    this.setTextFromLogisticTour(attributeNode, parameter, tour);
                } else if (o instanceof HistoryAreaTourModelWageResult) {
                    this.setTextFromHistoryTour(attributeNode, (HistoryAreaTourModelWageResult)o);
                }
                this.renderer.setForeground(attributeNode.getColor());
            } else if (value instanceof AreaStopNode) {
                String text = "";
                AreaStopNode node3 = (AreaStopNode)value;
                if (node3.getAreaStop() instanceof LegendObject) {
                    LegendObjectHelper helper = new LegendObjectHelper(null);
                    LegendObject legendObject = (LegendObject)node3.getAreaStop();
                    String shortInformation = helper.getInfomation(legendObject);
                    text = legendObject.getSortOrder() + ". " + shortInformation;
                }
                this.renderer.setText(text);
                this.renderer.setForeground(listerner != null && listerner.getSelectedStopNodes().contains(node3) ? PeppergisConstants.SELECTION_COLOR : node3.getColor());
            } else if (!(value instanceof AreaStopAttributeNode)) {
                if (value instanceof LogisticStopNode) {
                    node = (LogisticStopNode)value;
                    LogisticLocationDto<PointEntityId> location = ((LogisticStopNode)node).getStop().getLocation();
                    this.renderer.setText(((LogisticStopNode)node).getOrder() + ". " + FormUtil.getAddressString(location.getCity(), location.getPostcode(), location.getStreet(), location.getHousenumber(), location.getExtension()));
                    this.renderer.setForeground(((LogisticStopNode)node).getColor());
                } else {
                    Object object = ((DefaultMutableTreeNode)value).getUserObject();
                    if (object instanceof LegendObject) {
                        LegendObjectHelper helper = new LegendObjectHelper(null);
                        String info = helper.getInfomation(object);
                        this.renderer.setText(((LegendObject)object).getSortOrder() + ". " + info);
                        this.renderer.setForeground(((LegendObject)object).getColor());
                    } else {
                        this.renderer.setText(object.toString());
                        this.renderer.setForeground(Color.BLACK);
                    }
                }
            }
        }
        return this.renderer;
    }

    private void setTextFromHistoryTour(AreaObjectMapAttributeNode<?> attributeNode, HistoryAreaTourModelWageResult result) {
        HistoryAreaTourModel historyTour = result.getModel();
        WageParameterModel parameter = historyTour.getParameter();
        switch (attributeNode.getAttribute()) {
            case DISTANCE: {
                int distanceSum = historyTour.getLength() == null ? 0 : historyTour.getLength();
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{ModelEnviroment.getMessageResolver().getNumberFormat().format(distanceSum)}));
                int accessDistance = historyTour.getParcelLength() == null ? 0 : historyTour.getParcelLength();
                int streetDistance = distanceSum - accessDistance;
                String s = ClientFormUtil.getDistanceDisplay(distanceSum, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
                s = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + s;
                s = s + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(streetDistance, "");
                s = s + "- " + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(accessDistance, "") + ")";
                this.renderer.setText(s);
                break;
            }
            case DURATION: {
                int durationSum = historyTour.getDuration() == null ? 0 : historyTour.getDuration();
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{ClientFormUtil.getSecondTimeString(durationSum)}));
                break;
            }
            case DIFFICULTY_LEVEL: {
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]) + ": " + historyTour.getDifficultyLevel());
                break;
            }
            case PARCEL_LOCATION: {
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.parcellocation", new Serializable[0]) + ": " + historyTour.getParcelLocation());
                break;
            }
            case TOUR_TYPE: {
                switch (parameter.getAreaTourType().getAreaObjectType()) {
                    case LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case PARCEL: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
                        break;
                    }
                    case PARCEL_WITH_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case PARCEL_WITHOUT_SUBSCRIPTION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
                        break;
                    }
                    case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case SUBSCRIPTION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
                        break;
                    }
                    case SUBSCRIPTION_WITH_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case PARCEL_SUBSCRIPTION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.parcel.parcels", "messages.subscription.subscriptions"), "/"));
                        break;
                    }
                    case PARCEL_SUBSCRIPTION_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.parcel.parcels", "messages.subscription.subscriptions", "messages.letter.letters"), "/"));
                    }
                }
                break;
            }
            case SUM: {
                AreaObjectTourMapNode<?> node = attributeNode.getNode();
                int sum = NumericUtil.getIntegerValue(node.getModelSum());
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.stopSum", new Serializable[0]) + ": " + sum);
            }
        }
    }

    private void setTextFromLogisticTour(AreaObjectMapAttributeNode<LogisticTourDto<PointEntityId>> attributeNode, AreaTourParameter parameter, LogisticTourDto<PointEntityId> logisticTour) {
        switch (attributeNode.getAttribute()) {
            case DISTANCE: {
                int distanceSum = logisticTour.getDistanceSum() == null ? 0 : logisticTour.getDistanceSum();
                int accessDistance = logisticTour.getAccessSum() == null ? 0 : logisticTour.getAccessSum();
                int streetDistance = distanceSum - accessDistance;
                String s = ClientFormUtil.getDistanceDisplay(distanceSum, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
                s = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + s;
                s = s + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(streetDistance, "");
                s = s + "- " + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(accessDistance, "") + ")";
                this.renderer.setText(s);
                break;
            }
            case DURATION: {
                int durationSum = logisticTour.getDurationSum() == null ? 0 : logisticTour.getDurationSum();
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{ClientFormUtil.getSecondTimeString(durationSum)}));
                break;
            }
            case DIFFICULTY_LEVEL: {
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]) + ": " + logisticTour.getDifficultLevel());
                break;
            }
            case PARCEL_LOCATION: {
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.parcellocation", new Serializable[0]) + ": " + logisticTour.getParcelLocation());
                break;
            }
            case TOUR_TYPE: {
                switch (parameter.getAreaTourType().getAreaObjectType()) {
                    case LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case PARCEL: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
                        break;
                    }
                    case PARCEL_WITH_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case PARCEL_WITHOUT_SUBSCRIPTION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
                        break;
                    }
                    case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case SUBSCRIPTION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
                        break;
                    }
                    case SUBSCRIPTION_WITH_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]) + "/" + ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
                        break;
                    }
                    case PARCEL_SUBSCRIPTION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.parcel.parcels", "messages.subscription.subscriptions"), "/"));
                        break;
                    }
                    case PARCEL_SUBSCRIPTION_LETTER: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.parcel.parcels", "messages.subscription.subscriptions", "messages.letter.letters"), "/"));
                    }
                }
                break;
            }
            case SUM: {
                AreaObjectTourMapNode<LogisticTourDto<PointEntityId>> node = attributeNode.getNode();
                int sum = NumericUtil.getIntegerValue(node.getModelSum());
                this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.stopSum", new Serializable[0]) + ": " + sum);
            }
        }
    }
}

