/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.model.AreaDelivererHistoryTourBucketModel;
import de.datomino.peppergis.areamanager.model.AreaScheduleTimeBucketModel;
import de.datomino.peppergis.areamanager.util.AreaScheduleEntity;
import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.gui.CompletableJTextField;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.AbstractDelivererTreeGui;
import de.datomino.peppergis.client.manager.model.AreaDelivererTreeModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.ktde.util.datatypes.Tupel;

public class AreaDelivererTreeGui
extends AbstractDelivererTreeGui<AreaDelivererModel> {
    private AreaDelivererHistoryTourBucketModel bucket;
    private Window parent;

    public JComponent createDelivererGui(List<AreaDelivererModel> deliverers, Collection<BranchModel> branches, final AreaManagerCalendarGui managerGui) {
        this.bucket = new AreaDelivererHistoryTourBucketModel(managerGui.getModelEnviroment(), 30, managerGui.getBusyHandler());
        JPanel pane = new JPanel(new BorderLayout());
        JPanel searchPane = new JPanel(new GridLayout(2, 1));
        searchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])));
        AbstractListCellRenderer<AreaDelivererModel> cellRenderer = new AbstractListCellRenderer<AreaDelivererModel>(){

            @Override
            protected String getStringFromValue(AreaDelivererModel object) {
                return object == null ? "" : object.getDelivererNumber() + " - " + object.getName();
            }
        };
        CompletableJTextField<AreaDelivererModel> searchField = new CompletableJTextField<AreaDelivererModel>((AbstractListCellRenderer)cellRenderer, this.parent){
            private static final long serialVersionUID = -4649028000257170251L;

            @Override
            public void makeSelection() {
                super.makeSelection();
                AreaDelivererTreeGui.this.gotoSelection((AreaDelivererModel)super.getSelectedObject());
            }
        };
        for (AreaDelivererModel deliverer : deliverers) {
            searchField.addCompletion(deliverer);
        }
        searchPane.add(searchField);
        searchPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        pane.add((Component)searchPane, "North");
        JScrollPane mainPane = this.createDelivererGui(deliverers, branches, new AreaDelivererTreeModel(new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.allAreaDeliverer", new Serializable[0]))), managerGui.getCalendarGui());
        pane.add((Component)mainPane, "Center");
        JPanel filterPane = new JPanel(new SpringLayout());
        filterPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.workTime.more", new Serializable[0])));
        final JFormattedTextField hourField = new JFormattedTextField(new NumberFormatter(ModelEnviroment.getMessageResolver().getNumberFormat()));
        filterPane.add(hourField);
        filterPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.clear", new Serializable[0])){
            private static final long serialVersionUID = -3454729640834788861L;

            @Override
            public void actionPerformed(ActionEvent e) {
                hourField.setValue(null);
                managerGui.getScheduleBucketModel().clearWeekFilter();
                managerGui.getPlanTablePane().clearSelectedObjects();
                managerGui.getPlanTablePane().createPlanTable();
                AreaDelivererTreeGui.super.setFilteredDeliverers(null);
                AreaDelivererTreeGui.super.createDelivererTree(managerGui.getCalendarGui().getCurrentDate());
            }
        }));
        filterPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0])){
            private static final long serialVersionUID = -8564092251354633585L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object value = hourField.getValue();
                if (value == null) {
                    return;
                }
                double limit = Double.valueOf(((Long)value).longValue()) * 60.0 * 60.0;
                Date currentDate = managerGui.getCalendarGui().getCurrentDate();
                Tupel<Date, Date> monthTupel = TimeUtil.getMonthTupel(currentDate);
                AreaScheduleTimeBucketModel bucketModel = managerGui.getScheduleBucketModel();
                Map<AreaObjectModel, Collection<AreaScheduleEntity>> found = bucketModel.findObjects(managerGui.getAreaObjects(), monthTupel.getElement1(), monthTupel.getElement2(), false);
                HashMap<AreaDelivererModel, Double> delivererTimeMap = new HashMap<AreaDelivererModel, Double>();
                for (Collection<AreaScheduleEntity> entitys : found.values()) {
                    for (AreaScheduleEntity entity : entitys) {
                        for (AreaTourScheduleModel schedule : entity.getModel()) {
                            AreaDelivererModel deliverer = schedule.getDeliverer();
                            Double time = (Double)delivererTimeMap.get(deliverer);
                            time = time == null ? 0.0 : time;
                            double newTime = 0.0;
                            for (HistoryAreaTourModelWageResult r : entity.getHistoryResult()) {
                                newTime += r.getTimeSum();
                            }
                            delivererTimeMap.put(deliverer, time + newTime);
                        }
                    }
                }
                HashSet<AreaDelivererModel> filteredDeliverers = new HashSet<AreaDelivererModel>(AreaDelivererTreeGui.super.getAllDeliverers());
                for (AreaDelivererModel deliverer : delivererTimeMap.keySet()) {
                    if (!((Double)delivererTimeMap.get(deliverer) >= limit)) continue;
                    filteredDeliverers.remove(deliverer);
                }
                bucketModel.activeWeekFilter(null, filteredDeliverers);
                managerGui.getPlanTablePane().clearSelectedObjects();
                managerGui.getPlanTablePane().createPlanTable();
                AreaDelivererTreeGui.super.setFilteredDeliverers(filteredDeliverers);
                AreaDelivererTreeGui.super.createDelivererTree(managerGui.getCalendarGui().getCurrentDate());
            }
        }));
        SpringUtilities.makeCompactGrid(filterPane, 2, 2, 5, 5, 5, 5);
        pane.add((Component)filterPane, "South");
        return pane;
    }

    private void gotoSelection(AreaDelivererModel selectedObject) {
        JTree delivererJTree = this.getDelivererJTree();
        DefaultMutableTreeNode found = this.findTreeNode(selectedObject, (DefaultMutableTreeNode)delivererJTree.getModel().getRoot());
        if (found != null) {
            TreePath path = new TreePath(found.getPath());
            delivererJTree.setSelectionPath(path);
            delivererJTree.scrollPathToVisible(path);
        }
    }

    private DefaultMutableTreeNode findTreeNode(AreaDelivererModel selectedObject, DefaultMutableTreeNode node) {
        DefaultMutableTreeNode found = null;
        Object userObject = node.getUserObject();
        if (userObject != null && userObject.equals(selectedObject)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount() && (found = this.findTreeNode(selectedObject, (DefaultMutableTreeNode)node.getChildAt(i))) == null; ++i) {
        }
        return found;
    }

    public AreaDelivererHistoryTourBucketModel getBucket() {
        return this.bucket;
    }
}

