/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.areamanager.gui.AreaDelivererDialog;
import de.datomino.peppergis.areamanager.model.AreaDelivererHistoryTourBucketModel;
import de.datomino.peppergis.areamanager.util.AreaDelivererHistoryResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.manager.handler.DisablingDoubleClickMouseListener;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.client.wage.HistoryAreaTourDialog;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.comparator.AbstractNumericalComparator;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.ktde.swing.navigator.DefaultMouseManipulator;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tupel;

public class AreaDelivererRewardHistoryPane
extends JPanel {
    private static final long serialVersionUID = 3778171434050705906L;
    private static final int RESULT_TABLE_COLUMN_SIZE = 10;
    private AreaDelivererDialog parent;
    private JTable resultTable;

    public AreaDelivererRewardHistoryPane(AreaDelivererDialog parent) {
        super(new BorderLayout());
        this.parent = parent;
        this.initialize();
    }

    private void initialize() {
        this.add(this.createSettingPane(), "North");
        this.createResultPane();
        JScrollPane scrollPane = new JScrollPane(this.resultTable);
        scrollPane.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.add((Component)scrollPane, "Center");
    }

    private Component createSettingPane() {
        Date now = new Date();
        final Tupel<Date, Date> timeWindow = TimeUtil.getMonthTupel(now);
        Holder<Tupel<Date, Date>> holder = new Holder<Tupel<Date, Date>>(timeWindow);
        JPanel pane = new JPanel(new BorderLayout());
        JPanel p1 = new JPanel(new FlowLayout());
        p1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.dateFrom", new Serializable[0])));
        p1.add(ClientSwingUtil.createParameterTextField(20, TimeUtil.formatDate(timeWindow.getElement1(), FormUtil.DATEFORMAT), true, "Element1", holder, this.parent, FormUtil.DATEFORMAT, Date.class));
        p1.add(new JLabel("     "));
        p1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.dateTo", new Serializable[0])));
        p1.add(ClientSwingUtil.createParameterTextField(20, TimeUtil.formatDate(timeWindow.getElement2(), FormUtil.DATEFORMAT), true, "Element2", holder, this.parent, FormUtil.DATEFORMAT, Date.class));
        pane.add((Component)p1, "Center");
        JButton calcButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.calculate", new Serializable[0])){
            private static final long serialVersionUID = 8220845791626232320L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaDelivererHistoryTourBucketModel bucket = AreaDelivererRewardHistoryPane.this.parent.getBucket();
                AreaDelivererModel deliverer = AreaDelivererRewardHistoryPane.this.parent.getDelivererModel();
                Collection<HistoryAreaTourModelWageResult> found = bucket.findObjects(deliverer, (Date)timeWindow.getElement1(), (Date)timeWindow.getElement2());
                AreaDelivererRewardHistoryPane.this.fillResult(found);
            }
        });
        pane.add((Component)calcButton, "East");
        return pane;
    }

    private void fillResult(Collection<HistoryAreaTourModelWageResult> histories) {
        ArrayList<HistoryAreaTourModelWageResult> list = new ArrayList<HistoryAreaTourModelWageResult>(histories);
        Collections.sort(list, new AbstractNumericalComparator<HistoryAreaTourModelWageResult>(){

            @Override
            protected String getCompareValue(HistoryAreaTourModelWageResult t) {
                Date date = t.getModel().getDate();
                return date == null ? "" : String.valueOf(date.getTime());
            }
        });
        Object[][] data = this.createTableData(list);
        DefaultTableModel tm = (DefaultTableModel)this.resultTable.getModel();
        tm.setDataVector(data, this.createColumnHeader());
        tm.fireTableDataChanged();
        this.setPlanTableStyle();
    }

    private Object[][] createTableData(Collection<HistoryAreaTourModelWageResult> histories) {
        Object[][] data = new Object[histories.size() + 2][10];
        int row = 0;
        HashMap<Integer, Double> colSumMap = new HashMap<Integer, Double>();
        for (HistoryAreaTourModelWageResult wageResult : histories) {
            data[row] = new Object[10];
            AreaDelivererHistoryResult result = new AreaDelivererHistoryResult(this.parent.getDelivererModel(), wageResult);
            HistoryAreaTourModel history = wageResult.getModel();
            Object o = null;
            for (int column = 0; column < 10; ++column) {
                switch (column) {
                    case 0: {
                        Date date = history.getDate();
                        o = new Tupel<String, AreaDelivererHistoryResult>(ClientFormUtil.dateToString(date, FormUtil.DATEFORMAT), result);
                        break;
                    }
                    case 1: {
                        o = history.getShortcut();
                        break;
                    }
                    case 2: {
                        o = history.getDeliveryRound();
                        break;
                    }
                    case 3: {
                        o = ModelEnviroment.getMessageResolver().resolveMessageForEnum(history.getVehicelTypeInArea());
                        break;
                    }
                    case 4: {
                        double timeSum = result.calcTimeSum();
                        o = TimeUtil.formatDurationSeparated((long)(timeSum * 1000.0));
                        break;
                    }
                    case 5: {
                        double timeReward = result.calcTimeReward();
                        this.sumColumn(column, timeReward, colSumMap);
                        o = ClientFormUtil.numberToString(timeReward, 2);
                        break;
                    }
                    case 6: {
                        double nightSucharge = result.calcNightSurcharge();
                        this.sumColumn(column, nightSucharge, colSumMap);
                        o = ClientFormUtil.numberToString(nightSucharge, 2);
                        break;
                    }
                    case 7: {
                        double sucharge = result.calctExtraSurcharge();
                        this.sumColumn(column, sucharge, colSumMap);
                        o = ClientFormUtil.numberToString(sucharge, 2);
                        break;
                    }
                    case 8: {
                        double kmReward = result.calctKmReward();
                        this.sumColumn(column, kmReward, colSumMap);
                        o = ClientFormUtil.numberToString(kmReward, 2);
                        break;
                    }
                    case 9: {
                        double rewardSum = result.calcRewardSum();
                        this.sumColumn(column, rewardSum, colSumMap);
                        o = ClientFormUtil.numberToString(rewardSum, 2);
                        break;
                    }
                }
                data[row][column] = o;
            }
            ++row;
        }
        data[++row][4] = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.sum", new Serializable[0]);
        Iterator<HistoryAreaTourModelWageResult> iterator = colSumMap.keySet().iterator();
        while (iterator.hasNext()) {
            int col = (Integer)((Object)iterator.next());
            data[row][col] = ClientFormUtil.numberToString((Double)colSumMap.get(col), 2);
        }
        return data;
    }

    private void sumColumn(int column, double toAdd, Map<Integer, Double> colSumMap) {
        Double d = NumericUtil.getDoubleValue(colSumMap.get(column));
        colSumMap.put(column, d + toAdd);
    }

    private void createResultPane() {
        DefaultTableModel tm = new DefaultTableModel(){
            private static final long serialVersionUID = 2840331207475852084L;

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        tm.setColumnIdentifiers(this.createColumnHeader());
        this.resultTable = new JTable(tm);
        this.resultTable.addMouseListener(new DisablingDoubleClickMouseListener(new DefaultMouseManipulator(){

            @Override
            public void mouseClickFinished(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
                if (mouseButton == MouseButton.BUTTON1 && clickCount == 2) {
                    int row = AreaDelivererRewardHistoryPane.this.resultTable.getSelectedRow();
                    Object o = AreaDelivererRewardHistoryPane.this.resultTable.getValueAt(row, 0);
                    if (o instanceof Tupel) {
                        AreaDelivererHistoryResult result = (AreaDelivererHistoryResult)((Tupel)o).getElement2();
                        Window window = SwingUtils.findWindowParent(AreaDelivererRewardHistoryPane.this);
                        ModelEnviroment modelEnviroment = AreaDelivererRewardHistoryPane.this.parent.getModelEnviroment();
                        HistoryAreaTourDialog.createAndShow(CollectionUtil.buildArrayList(result.getWageResult()), modelEnviroment, window);
                    }
                }
                AreaDelivererRewardHistoryPane.this.resultTable.clearSelection();
            }
        }));
        this.setPlanTableStyle();
    }

    private void setPlanTableStyle() {
        this.resultTable.setCellSelectionEnabled(false);
        this.resultTable.setRowHeight(25);
        this.resultTable.setRowMargin(5);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        int col = 0;
        Enumeration<TableColumn> enumeration = this.resultTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(280);
            tableColumn.setHeaderRenderer(headerHenderer);
            if (col == 0) {
                tableColumn.setCellRenderer(new AbstractTableRenderer(){

                    @Override
                    protected String getString(Object value) {
                        if (value == null) {
                            return "";
                        }
                        if (value instanceof Tupel) {
                            return (String)((Tupel)value).getElement1();
                        }
                        return value.toString();
                    }
                });
            }
            ++col;
        }
        this.resultTable.repaint(10L);
    }

    private String[] createColumnHeader() {
        String[] columnHeader = new String[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.default.date", new Serializable[0]) + "\n \n", ModelEnviroment.getMessageResolver().resolveMessage("messages.area.area1", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessageForEnum(RouteVehicleType.class), ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.tracking.time", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.timeReward", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.nightsurcharge", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.surcharge", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.kmReward", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.reward.dayReward", new Serializable[0])};
        return columnHeader;
    }
}

