/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.gui;

import de.datomino.peppergis.areamanager.gui.AreaDelivererRewardHistoryPane;
import de.datomino.peppergis.areamanager.gui.AreaDelivererRewardPane;
import de.datomino.peppergis.areamanager.model.AreaDelivererHistoryTourBucketModel;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.common.BranchComboBox;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.common.EnumItem;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.poi.PoiComboBox;
import de.datomino.peppergis.client.gui.tour.AbstractDelivererTimeIntervalDialog;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererFactorModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererRewardModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererStatusTimeWindowModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererStatusTimeWindowModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.type.BranchType;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.NumberFormatter;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class AreaDelivererDialog
extends CommonDialog {
    private static final long serialVersionUID = -7588101157989435813L;
    private ModelEnviroment modelEnviroment;
    private AreaDelivererModel delivererModel;
    private AreaDelivererHistoryTourBucketModel bucket;
    private JTextField delivererNumber;
    private JTextField name;
    private BranchComboBox branch;
    private PoiComboBox poi;
    private JList subStatuses;
    private DeleteSubStatusAction deleteSubStatusAction;
    private AddSubStatusAction addSubStatusAction;
    private JFormattedTextField factor;
    private boolean editable;
    private JPasswordField password1;
    private JPasswordField password2;
    private boolean pwWritten = false;
    private boolean forHistory = false;

    public AreaDelivererDialog(Window parent, ModelEnviroment modelEnviroment, boolean editable, AreaDelivererHistoryTourBucketModel bucket) {
        this(parent, modelEnviroment, AreaDelivererDialog.createNewDeliverer(modelEnviroment, parent), editable, false, bucket);
    }

    private static AreaDelivererModel createNewDeliverer(ModelEnviroment modelEnviroment, Window parent) {
        AreaDelivererModelImpl deliverer = new AreaDelivererModelImpl();
        TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        BranchModel mainBranch = tourCaller.fetchBranchByNameAndType("Zusteller-Hauptstandort", BranchType.AREA_TOUR_DELIVERER);
        if (mainBranch == null) {
            String message = ModelEnviroment.getMessageResolver().resolveMessage("errors.deliverer.noMainBranch", new Serializable[0]);
            String title = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]);
            JOptionPane.showMessageDialog(parent, message, title, 2);
        }
        return deliverer;
    }

    public AreaDelivererDialog(Window parent, ModelEnviroment modelEnviroment, AreaDelivererModel delivererModel, boolean editable, boolean forHistory, AreaDelivererHistoryTourBucketModel bucket) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.deliverer.areaDelivererWithNumber", new Serializable[]{StringUtil.nullToEmpty(delivererModel.getDelivererNumber()), StringUtil.nullToEmpty(delivererModel.getName())}), Dialog.ModalityType.APPLICATION_MODAL);
        this.delivererModel = delivererModel;
        this.modelEnviroment = modelEnviroment;
        this.editable = editable;
        this.forHistory = forHistory;
        this.bucket = bucket;
        super.buildLayout();
        this.fillValues();
        modelEnviroment.getUndoManager().startTransaction();
        this.pack();
        SwingUtils.center((Window)this, parent);
        this.setVisible(true);
    }

    private void fillValues() {
        this.delivererNumber.setText(StringUtil.nullToEmpty(this.delivererModel.getDelivererNumber()));
        this.name.setText(StringUtil.nullToEmpty(this.delivererModel.getName()));
        this.factor.setValue(DelivererModelUtil.getCurrentFactor(this.delivererModel));
        this.branch.setSelectedItem(this.delivererModel.getBranch());
        this.poi.setSelectedItem(this.delivererModel.getPoi());
        DefaultListModel dlmStatuses = (DefaultListModel)this.subStatuses.getModel();
        for (AreaDelivererStatusTimeWindowModel status : this.delivererModel.iterableStatusTimeWindows()) {
            dlmStatuses.addElement(status);
        }
    }

    private boolean adaptValuesToModel() {
        boolean b = true;
        String delivererNumber = this.delivererNumber.getText();
        Collection<AreaDelivererModel> dirtyModels = this.modelEnviroment.getModelCache().getCachedModels(AreaDelivererModel.class);
        String errorMessageKey = "";
        for (AreaDelivererModel areaDelivererModel : dirtyModels) {
            String dirtyDelivererNumber;
            if (areaDelivererModel.equals(this.delivererModel) || !PrimitiveUtil.equalsNullSafe(dirtyDelivererNumber = areaDelivererModel.getDelivererNumber(), delivererNumber)) continue;
            errorMessageKey = "messages.area.error.multipleAreaDelivererNumber";
            b = false;
            break;
        }
        if (b) {
            HashSet<Long> dirtyIds = new HashSet<Long>();
            for (AreaDelivererModel dirtyModel : dirtyModels) {
                dirtyIds.add(dirtyModel.getId());
            }
            dirtyIds.add(this.delivererModel.getId());
            b = this.modelEnviroment.getAllCaller().getValidateCaller().validateExistingAreaDelivererNumber(delivererNumber, dirtyIds);
            errorMessageKey = "messages.area.error.multipleAreaDelivererNumber";
        }
        if (b && this.pwWritten) {
            char[] pw1 = this.password1.getPassword();
            char[] cArray = this.password2.getPassword();
            b = Arrays.equals(pw1, cArray);
            errorMessageKey = "gui.userdialog.passwordnotequal";
            if (b && pw1.length == 0) {
                b = false;
                errorMessageKey = "gui.userdialog.passwordempty";
            }
        }
        if (b) {
            this.delivererModel.setDelivererNumber(delivererNumber);
            this.delivererModel.setName(this.name.getText());
            this.delivererModel.setBranch((BranchModel)this.branch.getSelectedItem());
            this.delivererModel.setPoi((PoiModel)this.poi.getSelectedItem());
            Object factorValue = this.factor.getValue();
            if (factorValue != null) {
                Double d = DelivererModelUtil.getCurrentFactor(this.delivererModel);
                Double newFactor = Double.parseDouble(factorValue.toString());
                if (d == null || d != newFactor) {
                    AreaDelivererFactorModelImpl factorModel = new AreaDelivererFactorModelImpl();
                    factorModel.setFactor(newFactor);
                    AreaDelivererEmploymentModel employment = this.delivererModel.getEmployment();
                    if (employment == null) {
                        employment = new AreaDelivererEmploymentModelImpl();
                        employment.setDeliverer(this.delivererModel);
                    }
                    employment.addFactor(factorModel);
                }
            }
            if (this.pwWritten) {
                char[] cArray = this.password1.getPassword();
                this.delivererModel.setDeliveryPassword(StringUtil.getMd5String(cArray));
            } else if (this.delivererModel.getDeliveryPassword() == null) {
                this.delivererModel.setDeliveryPassword(StringUtil.getMd5String(StringUtil.getRandomString(8)));
            }
        }
        if (b) {
            HashSet<AreaDelivererRewardModel> delRewards = new HashSet<AreaDelivererRewardModel>();
            for (AreaDelivererRewardModel m : this.delivererModel.iterableReward()) {
                if (NumericUtil.getDoubleValue(m.getHourReward()) != 0.0) continue;
                delRewards.add(m);
            }
            for (AreaDelivererRewardModel m : delRewards) {
                this.delivererModel.removeAReward(m);
            }
            errorMessageKey = DelivererModelUtil.checkRewards(this.delivererModel);
            boolean bl = b = errorMessageKey == null;
        }
        if (!b) {
            JOptionPane.showMessageDialog(this, ModelEnviroment.getMessageResolver().resolveMessage(errorMessageKey, new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
        }
        return b;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -4070510918061226363L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AreaDelivererDialog.this.adaptValuesToModel()) {
                    AreaDelivererDialog.this.doAfterOk();
                    AreaDelivererDialog.this.modelEnviroment.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.delivererEdited", new Serializable[]{AreaDelivererDialog.this.delivererModel.getDelivererNumber(), AreaDelivererDialog.this.delivererModel.getName()}));
                    AreaDelivererDialog.this.dispose();
                }
            }
        };
    }

    protected void doAfterOk() {
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -6666981717422203934L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaDelivererDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
                AreaDelivererDialog.this.delivererModel = null;
                AreaDelivererDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(this.createLabel("messages.areaDelivererNumber"));
        this.delivererNumber = new JTextField(20);
        this.delivererNumber.setEditable(this.editable && this.delivererModel.getDelivererNumber() == null);
        panel.add(this.delivererNumber);
        panel.add(this.createLabel("messages.default.name"));
        this.name = new JTextField(20);
        this.name.setEditable(this.editable);
        panel.add(this.name);
        panel.add(this.createLabel("messages.default.humanFactor"));
        NumberFormat format = NumberFormat.getNumberInstance(Locale.GERMANY);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(100));
        this.factor = new JFormattedTextField(formatter);
        this.factor.setColumns(10);
        this.factor.setEditable(this.editable);
        panel.add(this.factor);
        panel.add(this.createLabel("messages.default.group"));
        this.branch = new BranchComboBox((Collection<BranchModel>)this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs(), true);
        this.branch.setEnabled(this.editable);
        panel.add(this.branch);
        panel.add(this.createLabel("messages.default.depot"));
        this.poi = new PoiComboBox((Collection<PoiModel>)this.modelEnviroment.getAllCaller().getTourCaller().fetchPoisWithTypes(CollectionUtil.buildHashSet(PoiType.AREA_DELIVERER_LOCATION)), true);
        panel.add(this.poi);
        panel.add(this.createLabel("messages.default.status"));
        panel.add(this.createSubStatusPane());
        panel.add(this.createLabel("gui.userdialog.password"));
        this.password1 = new JPasswordField();
        panel.add(this.password1);
        panel.add(this.createLabel("gui.userdialog.password.repeat"));
        this.password2 = new JPasswordField();
        panel.add(this.password2);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AreaDelivererDialog.this.pwWritten = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AreaDelivererDialog.this.pwWritten = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AreaDelivererDialog.this.pwWritten = true;
            }
        };
        this.password1.getDocument().addDocumentListener(documentListener);
        this.password2.getDocument().addDocumentListener(documentListener);
        SpringUtilities.makeCompactGrid(panel, 8, 2, 5, 5, 2, 2);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)panel, "North");
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), p1);
        AreaDelivererRewardPane rewardPane = new AreaDelivererRewardPane(this.delivererModel, this);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)rewardPane, "North");
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.deliverer.wage", new Serializable[0]), new JScrollPane(p2));
        AreaDelivererRewardHistoryPane historyPane = new AreaDelivererRewardHistoryPane(this);
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)historyPane, "North");
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.history", new Serializable[0]), new JScrollPane(p3));
        if (this.forHistory) {
            tabbedPane.setSelectedComponent(p3.getParent().getParent());
        }
        return tabbedPane;
    }

    private JPanel createSubStatusPane() {
        JPanel substatusPane = new JPanel(new BorderLayout());
        this.subStatuses = new JList(new DefaultListModel());
        final ListCellRenderer cellRenderer = this.subStatuses.getCellRenderer();
        this.subStatuses.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                AreaDelivererStatusTimeWindowModel status;
                Object rValue = value;
                if (value instanceof AreaDelivererStatusTimeWindowModel && (status = (AreaDelivererStatusTimeWindowModel)value).getStatus() != null) {
                    EnumItem<DelivererStatus> item = new EnumItem<DelivererStatus>(status.getStatus());
                    String sValue = item.toString();
                    sValue = sValue + " (" + ClientFormUtil.dateToString(status.getStartTime(), FormUtil.DATEFORMAT) + " - " + ClientFormUtil.dateToString(status.getEndTime(), FormUtil.DATEFORMAT) + ")";
                    rValue = sValue;
                }
                return cellRenderer.getListCellRendererComponent(list, rValue, index, isSelected, cellHasFocus);
            }
        });
        this.subStatuses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indexes = AreaDelivererDialog.this.subStatuses.getSelectedIndices();
                AreaDelivererDialog.this.deleteSubStatusAction.setEnabled(AreaDelivererDialog.this.editable && indexes != null && indexes.length > 0);
            }
        });
        substatusPane.add((Component)new JScrollPane(this.subStatuses), "Center");
        JPanel buttonPane = new JPanel(new BorderLayout());
        this.deleteSubStatusAction = new DeleteSubStatusAction();
        JButton delete = new JButton(this.deleteSubStatusAction);
        this.deleteSubStatusAction.setEnabled(false);
        buttonPane.add((Component)delete, "West");
        this.addSubStatusAction = new AddSubStatusAction();
        JButton add = new JButton(this.addSubStatusAction);
        this.addSubStatusAction.setEnabled(this.editable);
        buttonPane.add((Component)add, "East");
        substatusPane.add((Component)buttonPane, "South");
        return substatusPane;
    }

    private JLabel createLabel(String key) {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]));
        label.setVerticalAlignment(1);
        return label;
    }

    public AreaDelivererModel getDelivererModel() {
        return this.delivererModel;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public AreaDelivererHistoryTourBucketModel getBucket() {
        return this.bucket;
    }

    private class AddSubStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = 7308306454662648296L;

        public AddSubStatusAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final EnumComboBox status = new EnumComboBox(DelivererStatus.class, false, (Enum[])DelivererStatus.values());
            status.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            AbstractDelivererTimeIntervalDialog dialog = new AbstractDelivererTimeIntervalDialog(AreaDelivererDialog.this.getParent(), status, "messages.default.status"){
                private static final long serialVersionUID = 7285990464599353619L;

                @Override
                protected void setTimeWindow(Set<Tupel<Date, Date>> timeWindows) {
                    for (Tupel<Date, Date> timeWindow : timeWindows) {
                        AreaDelivererStatusTimeWindowModelImpl subStatus = new AreaDelivererStatusTimeWindowModelImpl();
                        subStatus.setStatus((DelivererStatus)((Object)status.getSelectedValue()));
                        subStatus.setStartTime(timeWindow.getElement1());
                        subStatus.setEndTime(timeWindow.getElement2());
                        DefaultListModel dlm = (DefaultListModel)AreaDelivererDialog.this.subStatuses.getModel();
                        if (DelivererModelUtil.resolveTimeIntervalConflicts((Component)AreaDelivererDialog.this, AreaDelivererDialog.this.delivererModel, subStatus, dlm) == 1) {
                            subStatus.delete();
                            continue;
                        }
                        subStatus.setDeliverer(AreaDelivererDialog.this.delivererModel);
                        dlm.addElement(subStatus);
                    }
                }
            };
            dialog.setVisible(true);
        }
    }

    private class DeleteSubStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = -2103924914988322768L;

        public DeleteSubStatusAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues;
            DefaultListModel dlm = (DefaultListModel)AreaDelivererDialog.this.subStatuses.getModel();
            for (Object selectedValue : selectedValues = AreaDelivererDialog.this.subStatuses.getSelectedValues()) {
                dlm.removeElement(selectedValue);
                AreaDelivererStatusTimeWindowModel subStatus = (AreaDelivererStatusTimeWindowModel)selectedValue;
                subStatus.setDeliverer(null);
                subStatus.delete();
            }
        }
    }
}

