/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class ShowPostcodeAction
extends AbstractAction {
    private static final long serialVersionUID = -1759082207622549910L;
    private AreaManagerMapGui mapGui;

    public ShowPostcodeAction(AreaManagerMapGui mapGui) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]));
        this.mapGui = mapGui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton button = (AbstractButton)e.getSource();
        boolean selected = button.getModel().isSelected();
        if (selected) {
            this.showPostcodeOnMap(button);
        } else {
            this.removePostcodeOnMap();
        }
        this.mapGui.getNavigatorPanel().repaint();
    }

    private void removePostcodeOnMap() {
        this.mapGui.getPostcodeLayerRenderer().setActive(false);
    }

    private void showPostcodeOnMap(AbstractButton button) {
        Component pane = this.mapGui.getPane();
        if (pane != null && pane instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)pane;
            if (!tabbedPane.getSelectedComponent().equals(this.mapGui)) {
                JOptionPane.showMessageDialog(tabbedPane.getSelectedComponent(), ModelEnviroment.getMessageResolver().resolveMessage("gui.map.message.mapInactive", new Serializable[0]));
                button.setSelected(false);
                return;
            }
            tabbedPane.setSelectedComponent(this.mapGui);
        }
        if (this.mapGui.getPostcodeAreaLayer() == null) {
            AreaLayerModel postcodeLayer = null;
            String defaultLayerName = ModelEnviroment.getProperties().getProperty("postcodeAreaLayer");
            AreaCaller areaCaller = this.mapGui.getAreaManager().getModelEnviroment().getAllCaller().getAreaCaller();
            AreaObjectGenInfoDiscriminator[] discriminators = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE};
            Collection<AreaLayerModel> postcodeLayers = areaCaller.getAreaLayersForType(discriminators);
            if (defaultLayerName != null) {
                for (AreaLayerModel areaLayer : postcodeLayers) {
                    if (!areaLayer.getDisplayname().equals(defaultLayerName)) continue;
                    postcodeLayer = areaLayer;
                    break;
                }
            }
            if (postcodeLayer == null) {
                AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(this.mapGui.getAreaManager().getModelEnviroment(), false, discriminators);
                areaLayerComboBox.setSelectedIndex(0);
                int d = JOptionPane.showConfirmDialog(this.mapGui.getAreaManager(), areaLayerComboBox, "Bitte PLZ-Layer ausw\u00e4hlen: ", 2);
                switch (d) {
                    case 0: {
                        postcodeLayer = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
                        break;
                    }
                }
            }
            this.mapGui.setPostcodeAreaLayer(postcodeLayer);
        }
        this.mapGui.getPostcodeLayerRenderer().setActive(true);
    }
}

