/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.client.gui.common.AbstractCommonDialog;
import de.datomino.peppergis.client.gui.filter.LegendeRendererAttribute;
import de.datomino.peppergis.client.gui.filter.LegendeRendererPosition;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.filter.AllObjectFilterLayerRenderer;
import de.datomino.peppergis.client.manager.legend.AreaObjectTourLegendType;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Holder;

public class SetAreaTourRendererAction
extends AbstractAction {
    private static final long serialVersionUID = -997753929556577248L;
    private AreaManagerCalendarGui areaManager;
    private List<PositionGroup> positionlist;

    public SetAreaTourRendererAction(AreaManagerCalendarGui areaManager) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.renderer.configuration", new Serializable[0]));
        this.areaManager = areaManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractCommonDialog dialog = new AbstractCommonDialog(this.areaManager.getModelEnviroment(), this.areaManager, ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.renderer.configuration", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL){
            private static final long serialVersionUID = -215251783276659769L;

            @Override
            protected Component getMainComponent() {
                SetAreaTourRendererAction.this.positionlist = new ArrayList(AreaObjectTourLegendType.values().length);
                JPanel main = new JPanel(new SpringLayout());
                main.add(new JLabel());
                main.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.position.top", new Serializable[0])));
                main.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.position.middle1", new Serializable[0])));
                main.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.position.middle", new Serializable[0])));
                main.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.position.bottom", new Serializable[0])));
                main.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.lineWidth", new Serializable[0])));
                int index = 0;
                for (AreaObjectTourLegendType type : AreaObjectTourLegendType.values()) {
                    String[] typeText = ModelEnviroment.getMessageResolver().resolveMessageForEnum(type).split(" ");
                    main.add(new JLabel(typeText[typeText.length - 1]));
                    PositionGroup positionGroup = new PositionGroup(index, type);
                    SetAreaTourRendererAction.this.positionlist.add(positionGroup);
                    main.add(positionGroup.top);
                    main.add(positionGroup.middle1);
                    main.add(positionGroup.middle);
                    main.add(positionGroup.bottom);
                    main.add(ClientSwingUtil.createParameterTextField(5, String.valueOf(positionGroup.lineWidth.getElement()), true, "Element", new Holder<Holder>(positionGroup.lineWidth), main, null, Integer.class));
                    ++index;
                }
                SpringUtilities.makeCompactGrid(main, 5, 6, 5, 5, 5, 5);
                main.repaint(10L);
                return main;
            }

            @Override
            protected void fillData() {
            }

            @Override
            protected boolean close() {
                LegendeRendererAttribute history = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.HISTORY);
                LegendeRendererAttribute motor = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.MOTORCAR);
                LegendeRendererAttribute bike = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.BIKE);
                LegendeRendererAttribute foot = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.FOOT);
                block6: for (int i = 0; i < SetAreaTourRendererAction.this.positionlist.size(); ++i) {
                    LegendeRendererPosition currentPosition = null;
                    PositionGroup group = (PositionGroup)SetAreaTourRendererAction.this.positionlist.get(i);
                    if (group.top.isSelected()) {
                        currentPosition = LegendeRendererPosition.TOP;
                    } else if (group.middle.isSelected()) {
                        currentPosition = LegendeRendererPosition.MIDDLE;
                    } else if (group.middle1.isSelected()) {
                        currentPosition = LegendeRendererPosition.MIDDLE_1;
                    } else if (group.bottom.isSelected()) {
                        currentPosition = LegendeRendererPosition.BOTTOM;
                    }
                    switch (i) {
                        case 0: {
                            history.setPostion(currentPosition);
                            history.setLineWidth((Integer)group.lineWidth.getElement());
                            continue block6;
                        }
                        case 1: {
                            motor.setPostion(currentPosition);
                            motor.setLineWidth((Integer)group.lineWidth.getElement());
                            continue block6;
                        }
                        case 2: {
                            bike.setPostion(currentPosition);
                            bike.setLineWidth((Integer)group.lineWidth.getElement());
                            continue block6;
                        }
                        case 3: {
                            foot.setPostion(currentPosition);
                            foot.setLineWidth((Integer)group.lineWidth.getElement());
                            continue block6;
                        }
                    }
                }
                SetAreaTourRendererAction.this.areaManager.getAreaManagerMapGui().getNavigatorPanel().repaint(10L);
                return true;
            }
        };
        dialog.setVisible(true);
    }

    private JRadioButton createRadioButton(final int index, final LegendeRendererPosition position) {
        final JRadioButton radioButton = new JRadioButton();
        radioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (radioButton.isSelected()) {
                    ArrayList<LegendeRendererPosition> freePosition = CollectionUtil.buildArrayList(LegendeRendererPosition.values());
                    int found = -1;
                    for (int i = 0; i < SetAreaTourRendererAction.this.positionlist.size(); ++i) {
                        if (i == index) continue;
                        PositionGroup group = (PositionGroup)SetAreaTourRendererAction.this.positionlist.get(i);
                        LegendeRendererPosition currentPosition = group.getSelectedPosition();
                        if (currentPosition == position) {
                            found = i;
                        }
                        freePosition.remove((Object)currentPosition);
                    }
                    PositionGroup foundGroup = (PositionGroup)SetAreaTourRendererAction.this.positionlist.get(found);
                    foundGroup.setSelectedPosition((LegendeRendererPosition)((Object)freePosition.get(0)));
                }
            }
        });
        return radioButton;
    }

    private class PositionGroup
    extends ButtonGroup {
        private static final long serialVersionUID = -5887881538719872380L;
        private JRadioButton top;
        private JRadioButton middle1;
        private JRadioButton middle;
        private JRadioButton bottom;
        private Holder<Integer> lineWidth;

        private PositionGroup(int index, AreaObjectTourLegendType type) {
            LegendeRendererAttribute history = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.HISTORY);
            LegendeRendererAttribute motor = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.MOTORCAR);
            LegendeRendererAttribute bike = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.BIKE);
            LegendeRendererAttribute foot = AllObjectFilterLayerRenderer.LEGENDE_RENDERER_MAP.get((Object)AreaObjectTourLegendType.FOOT);
            this.top = SetAreaTourRendererAction.this.createRadioButton(index, LegendeRendererPosition.TOP);
            this.middle1 = SetAreaTourRendererAction.this.createRadioButton(index, LegendeRendererPosition.MIDDLE_1);
            this.middle = SetAreaTourRendererAction.this.createRadioButton(index, LegendeRendererPosition.MIDDLE);
            this.bottom = SetAreaTourRendererAction.this.createRadioButton(index, LegendeRendererPosition.BOTTOM);
            this.lineWidth = new Holder();
            LegendeRendererPosition position = null;
            switch (type) {
                case BIKE: {
                    position = bike.getPostion();
                    this.lineWidth.setElement(bike.getLineWidth());
                    break;
                }
                case FOOT: {
                    position = foot.getPostion();
                    this.lineWidth.setElement(foot.getLineWidth());
                    break;
                }
                case MOTORCAR: {
                    position = motor.getPostion();
                    this.lineWidth.setElement(motor.getLineWidth());
                    break;
                }
                case HISTORY: {
                    position = history.getPostion();
                    this.lineWidth.setElement(history.getLineWidth());
                }
            }
            switch (position) {
                case BOTTOM: {
                    this.bottom.setSelected(true);
                    break;
                }
                case MIDDLE: {
                    this.middle.setSelected(true);
                    break;
                }
                case MIDDLE_1: {
                    this.middle1.setSelected(true);
                    break;
                }
                case TOP: {
                    this.top.setSelected(true);
                }
            }
            this.add(this.top);
            this.add(this.middle1);
            this.add(this.middle);
            this.add(this.bottom);
        }

        private void setSelectedPosition(LegendeRendererPosition position) {
            switch (position) {
                case BOTTOM: {
                    this.bottom.setSelected(true);
                    break;
                }
                case MIDDLE: {
                    this.middle.setSelected(true);
                    break;
                }
                case MIDDLE_1: {
                    this.middle1.setSelected(true);
                    break;
                }
                case TOP: {
                    this.top.setSelected(true);
                }
            }
        }

        private LegendeRendererPosition getSelectedPosition() {
            LegendeRendererPosition p = null;
            if (this.top.isSelected()) {
                p = LegendeRendererPosition.TOP;
            } else if (this.middle1.isSelected()) {
                p = LegendeRendererPosition.MIDDLE_1;
            } else if (this.middle.isSelected()) {
                p = LegendeRendererPosition.MIDDLE;
            } else if (this.bottom.isSelected()) {
                p = LegendeRendererPosition.BOTTOM;
            }
            return p;
        }
    }
}

