/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.peppergis.areamanager.action.ObjectFilterSettingActions;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.client.manager.filter.ObjectFilterEntity;
import de.datomino.peppergis.client.manager.filter.ObjectFilterSettingDialog;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.type.AttributeValueType;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class CreateFilterDialogAction
extends AbstractAction {
    private static final long serialVersionUID = 7804085871774735907L;
    private FilterEntity filterEntity;
    private AreaManagerCalendarGui areaManager;

    public CreateFilterDialogAction(FilterEntity filterEntity, String key, AreaManagerCalendarGui tourManager) {
        super(key);
        this.filterEntity = filterEntity;
        this.areaManager = tourManager;
        if (this.filterEntity == null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 8192));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ObjectFilterSettingActions parcelActions = new ObjectFilterSettingActions(this.areaManager);
        HashSet<ParcelAttributeValueDescriptorModel> blockDescriptors = new HashSet<ParcelAttributeValueDescriptorModel>();
        Collection<ParcelAttributeValueDescriptorModel> descriptors = this.areaManager.getModelEnviroment().getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        for (ParcelAttributeValueDescriptorModel descriptor : descriptors) {
            if (descriptor.getAttributeValueType() != AttributeValueType.BOOLEAN) continue;
            blockDescriptors.add(descriptor);
        }
        ObjectFilterSettingDialog.createAndShowDialog((ObjectFilterEntity)this.filterEntity, parcelActions, this.areaManager.getModelEnviroment(), blockDescriptors, this.areaManager, this.areaManager.getCurrentLayer());
    }
}

