/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.areamanager.action;

import de.datomino.peppergis.areamanager.action.CalculateAreasAction;
import de.datomino.peppergis.areamanager.action.ClearSelectedSchedulesAction;
import de.datomino.peppergis.areamanager.action.CreateFilterDialogAction;
import de.datomino.peppergis.areamanager.action.SetAreaTourRendererAction;
import de.datomino.peppergis.areamanager.action.ShowPostcodeAction;
import de.datomino.peppergis.areamanager.action.ShowSelectedSchedulesAction;
import de.datomino.peppergis.areamanager.gui.AreaDelivererDialog;
import de.datomino.peppergis.areamanager.gui.AreaManagerCalendarGui;
import de.datomino.peppergis.areamanager.gui.AreaManagerMapGui;
import de.datomino.peppergis.areamanager.gui.legend.AreaObjectLogisticTourMapNode;
import de.datomino.peppergis.areamanager.gui.sortOrder.SavingSortOrderDialog;
import de.datomino.peppergis.areamanager.printer.AllPrintAction;
import de.datomino.peppergis.areamanager.printer.AreaDelivererWeekPrintAction;
import de.datomino.peppergis.client.action.ClearDistanceMatrixAction;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.handler.ShowParcelAction;
import de.datomino.peppergis.client.manager.handler.ShowSubscriptionAction;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.UndoManagerEvent;
import de.datomino.peppergis.client.model.UndoManagerListener;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.util.swing.SwingUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class AreaManagerActions {
    private AreaManagerCalendarGui areaManager;
    private TourCaller tourCaller;
    private AreaCaller areaCaller;
    private StreetNetCaller streetNetCaller;
    private UndoManager undoManager;
    private Action clearSelectedSchedulesAction;
    private Action showSelectedSchedulesAction;
    private Action searchLocationAction;
    private Action showSubscriptionAction;
    private Action showParcelAction;
    private Action showPostcodeAction;
    private Action removeFilterOnMapAction;
    private Action allPrintAction;
    private Action areaDelivererWeekPrintAction;

    public AreaManagerActions(AreaManagerCalendarGui areaManager) {
        this.areaManager = areaManager;
        this.initialize(this.areaManager.getModelEnviroment());
    }

    private void initialize(ModelEnviroment modelEnviroment) {
        final AreaManagerMapGui areaManagerMapGui = this.areaManager.getAreaManagerMapGui();
        this.undoManager = modelEnviroment.getUndoManager();
        this.undoManager.addUndoManagerListener(new UndoManagerListener(){

            @Override
            public void undone(UndoManagerEvent event) {
                AreaManagerActions.this.repaint();
            }

            @Override
            public void redone(UndoManagerEvent event) {
                AreaManagerActions.this.repaint();
            }
        });
        this.tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        this.areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
        this.streetNetCaller = modelEnviroment.getAllCaller().getStreetNetCaller();
        this.clearSelectedSchedulesAction = new ClearSelectedSchedulesAction(areaManagerMapGui);
        this.showSelectedSchedulesAction = new ShowSelectedSchedulesAction(this.areaManager);
        this.allPrintAction = new AllPrintAction(areaManagerMapGui);
        this.areaDelivererWeekPrintAction = new AreaDelivererWeekPrintAction(areaManagerMapGui, ModelEnviroment.getMessageResolver().resolveMessage("messages.print.areaDelivererWeek", new Serializable[0]));
        this.showParcelAction = new ShowParcelAction(areaManagerMapGui);
        this.showSubscriptionAction = new ShowSubscriptionAction(areaManagerMapGui);
        this.showPostcodeAction = new ShowPostcodeAction(areaManagerMapGui);
        this.searchLocationAction = new SearchLocationAction(areaManagerMapGui, areaManagerMapGui.getNavigatorPanel(), modelEnviroment, false, false){
            private static final long serialVersionUID = -4352659602604593024L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaManagerActions.this.areaManager.getTabbedPane().setSelectedComponent(areaManagerMapGui);
                super.actionPerformed(e);
            }
        };
        this.removeFilterOnMapAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.removefrommap", new Serializable[0])){
            private static final long serialVersionUID = -9169311427594403850L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.removeFilterOnMapAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 8192));
    }

    public Action getClearSelectedSchedulesAction() {
        return this.clearSelectedSchedulesAction;
    }

    public Action getShowSelectedSchedulesAction() {
        return this.showSelectedSchedulesAction;
    }

    public Action getSearchLocationAction() {
        return this.searchLocationAction;
    }

    public Action getShowParcelAction() {
        return this.showParcelAction;
    }

    public Action getShowSubscriptionAction() {
        return this.showSubscriptionAction;
    }

    public Action getAllPrintAction() {
        return this.allPrintAction;
    }

    public Action getShowPostcodeAction() {
        return this.showPostcodeAction;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public Action getUndoAction() {
        return this.getUndoManager().getUndoAction();
    }

    public Action getRedoAction() {
        return this.getUndoManager().getRedoAction();
    }

    public Action getSaveAction() {
        return this.getUndoManager().getSaveAction();
    }

    public Action getRevertAction() {
        return this.getUndoManager().getRevertAction();
    }

    public Action getAreaDelivererWeekPrintAction() {
        return this.areaDelivererWeekPrintAction;
    }

    public TourCaller getTourCaller() {
        return this.tourCaller;
    }

    private void repaint() {
        this.areaManager.getPlanTablePane().createPlanTable();
        this.areaManager.getAreaManagerMapGui().repaintGui(false);
    }

    public AreaCaller getAreaCaller() {
        return this.areaCaller;
    }

    public StreetNetCaller getStreetNetCaller() {
        return this.streetNetCaller;
    }

    public Action getFilterAction(FilterEntity filterEntity) {
        String key = filterEntity == null ? "Neuer Filter" : filterEntity.getKey();
        return new CreateFilterDialogAction(filterEntity, key, this.areaManager);
    }

    public Action getRemoveFilterOnMapAction() {
        return this.removeFilterOnMapAction;
    }

    public Action getClearDistanceMatrixAction() {
        String title = ModelEnviroment.getMessageResolver().resolveMessage("gui.distanceMatrix.clear", new Serializable[0]);
        return new ClearDistanceMatrixAction(title, this.areaManager.getBusyHandler(), this.areaManager.getCurrentNavigatorPanel(), this.areaManager.getModelEnviroment(), this.areaManager);
    }

    public Action getCalculateAreasAction() {
        return new CalculateAreasAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatours.display", new Serializable[0]), this.areaManager);
    }

    public Action getClearSelectedAreasAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.removeAreasOnMap", new Serializable[0])){
            private static final long serialVersionUID = 6696438798700950599L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaManagerActions.this.areaManager.getAreaManagerMapGui().clearAreaMapNodes();
            }
        };
    }

    public Action getSetAreaTourRendererAction() {
        return new SetAreaTourRendererAction(this.areaManager);
    }

    public Action getNewAreaDelivererAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.areaDeliverer.add", new Serializable[0])){
            private static final long serialVersionUID = -6157067085623714645L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaManagerActions.this.undoManager.startTransaction();
                new AreaDelivererDialog(SwingUtils.findWindowParent(AreaManagerActions.this.areaManager), AreaManagerActions.this.areaManager.getModelEnviroment(), true, null){
                    private static final long serialVersionUID = -4254372056345449339L;

                    @Override
                    protected void doAfterOk() {
                        super.doAfterOk();
                        AreaManagerActions.this.areaManager.getDelivererGui().addNewDeliverer(this.getDelivererModel());
                    }
                };
            }
        };
    }

    public Action getSaveSortOrderAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.areatours.sortOrder.save", new Serializable[0])){
            private static final long serialVersionUID = 9205628560797384281L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaManagerActions.this.undoManager.startTransaction();
                Window parent = SwingUtils.findWindowParent(AreaManagerActions.this.areaManager);
                List<AreaObjectLogisticTourMapNode> nodes = AreaManagerActions.this.areaManager.getAreaManagerMapGui().getLogisticTourNodes();
                SavingSortOrderDialog.createAndShow(nodes, AreaManagerActions.this.areaManager.getModelEnviroment(), parent);
            }
        };
    }
}

