/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.printer;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;
import org.w3c.dom.Document;

public class PrintRenderer {
    private NavigatorRenderer navigatorRenderer;
    private Coordinate topLeft;
    private Coordinate bottomRight;
    private Double forcedUpp;

    public PrintRenderer(NavigatorPanel navigatorPanel, NavigatorRenderer navigatorRenderer, Coordinate topLeft, Coordinate bottomRight) {
        this(navigatorPanel, navigatorRenderer, topLeft, bottomRight, null);
    }

    public PrintRenderer(NavigatorPanel navigatorPanel, NavigatorRenderer navigatorRenderer, Coordinate topLeft, Coordinate bottomRight, Double forcedUpp) {
        this.navigatorRenderer = navigatorRenderer;
        CoordinateFactory panelFactory = navigatorPanel.getCoordinateFactory();
        this.topLeft = panelFactory.createCoordinate(topLeft);
        this.bottomRight = panelFactory.createCoordinate(bottomRight);
        System.out.println("N: " + navigatorPanel.getUpp());
        this.forcedUpp = forcedUpp;
    }

    public Tupel<SVGGraphics2D, Double> render(int width, int height) {
        double diag = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        double diagReal = Math.sqrt(Math.pow(this.bottomRight.getX() - this.topLeft.getX(), 2.0) + Math.pow(this.bottomRight.getY() - this.topLeft.getY(), 2.0));
        double scale = diag / diagReal;
        try {
            double upp;
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            SVGGraphics2D subGraphics = new SVGGraphics2D(newDocument);
            AffineTransform orig = subGraphics.getTransform();
            AffineTransform transform = PrintRenderer.getTransform(scale, this.topLeft, this.bottomRight);
            if (this.forcedUpp == null) {
                double fcosp = transform.getScaleX();
                double fsinp = -transform.getShearX();
                double f = Math.sqrt(Math.pow(fcosp, 2.0) + Math.pow(fsinp, 2.0));
                upp = this.floorToSquare(1.0 / f);
            } else {
                upp = this.forcedUpp;
            }
            System.out.println("P: " + upp);
            subGraphics.setTransform(transform);
            Point2D.Double bottomLeft = new Point2D.Double(this.topLeft.getX(), this.bottomRight.getY());
            Point2D.Double topRight = new Point2D.Double(this.bottomRight.getX(), this.topLeft.getY());
            this.navigatorRenderer.prepare(bottomLeft, topRight, upp);
            this.navigatorRenderer.paintOnto(subGraphics, bottomLeft, topRight, upp);
            subGraphics.setTransform(orig);
            return new Tupel<SVGGraphics2D, Double>(subGraphics, scale);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    private double floorToSquare(double d) {
        return Math.pow(Math.floor(Math.sqrt(d)), 2.0);
    }

    private static AffineTransform getTransform(double scale, Coordinate topLeft, Coordinate bottomRight) {
        AffineTransform transform = AffineTransform.getScaleInstance(scale, -scale);
        Point2D.Double topLeftPoint = new Point2D.Double(topLeft.getX(), topLeft.getY());
        Point2D.Double topLeftPointT = new Point2D.Double();
        transform.transform(topLeftPoint, topLeftPointT);
        transform.translate(-topLeftPointT.getX() / scale, topLeftPointT.getY() / scale);
        return transform;
    }
}

