/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.engine;

import de.datomino.pdf.printer.ImageInfoBox;
import de.datomino.pdf.printer.PrintingInformation;
import de.datomino.util.ValueChangeObservable;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class VelocityUtils {
    public String escapeXml(String string) {
        return StringEscapeUtils.escapeXml(string);
    }

    public String makeFopBreaks(String string, String openTag, String endTag) {
        if (string == null) {
            return openTag + endTag;
        }
        StringBuilder sb = new StringBuilder(openTag);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                sb.append(endTag).append(openTag);
                continue;
            }
            if (c == ' ') {
                sb.append("&#x20;");
                continue;
            }
            sb.append(c);
        }
        sb.append(endTag);
        return sb.toString();
    }

    public String getDoubleQuote() {
        return "\"";
    }

    public String concatenate(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    public String getAttributeString(PrintingInformation<ValueChangeObservable> printingInformation) {
        String s = "";
        for (ValueChangeObservable o : printingInformation.getOs()) {
            List<Tupel<String, String>> attributes = printingInformation.getAttributes(o);
            if (attributes == null) continue;
            for (Tupel<String, String> attribute : attributes) {
                s = s + this.escapeXml(attribute.getElement1() + ": " + attribute.getElement2() + "/n");
            }
        }
        return s;
    }

    public String getFontStyle(Font font) {
        String style = "normal";
        switch (font.getStyle()) {
            case 2: 
            case 3: {
                style = "italic";
                break;
            }
        }
        return style;
    }

    public String getFontWeight(Font font) {
        String weight = "400";
        switch (font.getStyle()) {
            case 1: 
            case 3: {
                weight = "700";
                break;
            }
        }
        return weight;
    }

    public String getFontAttributes(Font font) {
        return this.getFontAttributes(font, this.getFontWeight(font));
    }

    public String getFontAttributes(Font font, String weight) {
        int size = font.getSize();
        return "font-family=\"" + font.getName() + "\" font-size=\"" + size + "pt\" font-style=\"" + this.getFontStyle(font) + "\" font-weight=\"" + weight + "\" line-height=\"" + (size + 1) + "pt\"";
    }

    public String getImageInfoBoxAttributes(ImageInfoBox imageInfoBox, String imageWidthMM, String imageHeightMM) {
        double top = 0.0;
        double left = 0.0;
        double imageWidth = Double.parseDouble(imageWidthMM.replaceAll("mm", ""));
        double imageHeight = Double.parseDouble(imageHeightMM.replaceAll("mm", ""));
        switch (imageInfoBox.getPosition()) {
            case TOP_LEFT: {
                top -= 19.5;
                break;
            }
            case TOP_RIGHT: {
                top -= 19.5;
                left = imageWidth - imageInfoBox.getWidth();
                break;
            }
            case BOTTOM_LEFT: {
                top = imageHeight - imageInfoBox.getHeight() - 3.5;
                break;
            }
            case BOTTOM_RIGHT: {
                top = imageHeight - imageInfoBox.getHeight() - 3.5;
                left = imageWidth - imageInfoBox.getWidth();
            }
        }
        return "top=\"" + top + "mm\" height=\"" + imageInfoBox.getHeight() + "mm\" left=\"" + left + "mm\" width=\"" + imageInfoBox.getWidth() + "mm\"";
    }

    public String getColorCode(Color c) {
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }

    public boolean isBlank(String string) {
        return StringUtil.isBlank(string);
    }
}

