/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.engine;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.ktde.util.StringUtil;

public class VelocityPdfUtils {
    public String escXml(String string) {
        return StringEscapeUtils.escapeXml(string);
    }

    public String getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String r = this.escXml(cal.get(5) + ". " + this.getMonthName(cal.get(2)) + " " + cal.get(1));
        return r;
    }

    private String getMonthName(int month) {
        switch (month) {
            case 0: {
                return "Januar";
            }
            case 1: {
                return "Februar";
            }
            case 2: {
                return "M\u00e4rz";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "Mai";
            }
            case 5: {
                return "Juni";
            }
            case 6: {
                return "Juli";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "Oktober";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "Dezember";
            }
        }
        return "";
    }

    public boolean isBlank(String string) {
        return StringUtil.isBlank(string);
    }

    public String breakAndEscape(String string, String blockAttributes) {
        String dBlockAttributes = blockAttributes.replace('~', '\"');
        return "<fo:block " + dBlockAttributes + ">\n" + this.escXml(string) + "\n</fo:block>\n";
    }

    public String formatNumberWith1000Dots(Integer number) {
        if (number == 0) {
            return "0";
        }
        String r = "";
        for (int n = Math.abs(number); n != 0; n /= 1000) {
            r = "." + StringUtils.leftPad(Integer.toString(n % 1000), 3, '0') + r;
        }
        r = r.substring(1);
        while (r.charAt(0) == '0') {
            r = r.substring(1);
        }
        return (number < 0 ? "-" : "") + r;
    }
}

