/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.engine;

import de.datomino.pdf.engine.PdfCreator;
import de.datomino.pdf.engine.VelocityPdfUtils;
import de.datomino.pdf.engine.VelocityUtils;
import de.datomino.pdf.engine.processors.PdfVelocityEmitter;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.XmlMessageResolverImpl;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.velocity.VelocityContext;

public class PdfCreatorImpl
implements PdfCreator {
    public static final Integer DPI = 150;
    public static final Double INCH_PER_CM = 2.54;
    public static final Double MARGIN_X = 1.0;
    public static final Double MARGIN_Y = 1.0;
    public static final Double A4_LANDSCAPE_PAGEWIDTH = 21.0;
    public static final Double A4_LANDSCAPE_PAGEHEIGHT = 29.7;
    public static final Double A4_PORTRAIT_PAGEWIDTH_CM = A4_LANDSCAPE_PAGEWIDTH - MARGIN_X;
    public static final Double A4_PORTRAIT_PAGEHEIGHT_CM = A4_LANDSCAPE_PAGEHEIGHT - MARGIN_Y;
    public static final Double A4_PORTRAIT_PAGEWIDTH = A4_PORTRAIT_PAGEWIDTH_CM * (double)DPI.intValue() / INCH_PER_CM;
    public static final Double A4_PORTRAIT_PAGEHEIGHT = A4_PORTRAIT_PAGEHEIGHT_CM * (double)DPI.intValue() / INCH_PER_CM;
    private FopFactory fopFactory;
    private Integer lastDpi;
    private static final Map<String, String> ESCAPE_CHAR_MAP = new HashMap<String, String>();

    @Override
    public InputStream createPdf(String templateName, Map<String, Object> inputData, Map<String, Image> inputImages, MessageResolver messageResolver, int dpi) throws Exception {
        Map<String, Collection<Image>> emptyMap = Collections.emptyMap();
        return this.createPdf(templateName, inputData, inputImages, emptyMap, messageResolver, dpi);
    }

    @Override
    public InputStream createPdf(String templateName, Map<String, Object> inputData, Map<String, Image> inputImages, MessageResolver messageResolver) throws Exception {
        return this.createPdf(templateName, inputData, inputImages, messageResolver, DPI);
    }

    @Override
    public InputStream createPdf(String templateName, Map<String, ? extends Object> inputData, Map<String, Image> inputImages, Map<String, Collection<Image>> inputImageCollections, MessageResolver messageResolver, int dpi) throws Exception {
        StringReader foStringReader = this.createFoStringReader(templateName, inputData, inputImages, inputImageCollections, messageResolver);
        return this.convertFo2Pdf(foStringReader, dpi);
    }

    @Override
    public InputStream createPdf(String templateName, Map<String, ? extends Object> inputData, Map<String, Image> inputImages, Map<String, Collection<Image>> inputImageCollections, MessageResolver messageResolver) throws Exception {
        return this.createPdf(templateName, inputData, inputImages, inputImageCollections, messageResolver, DPI);
    }

    private InputStream convertFo2Pdf(StringReader foStringReader, int dpi) throws FOPException, TransformerFactoryConfigurationError, TransformerException, IOException {
        FopFactory fopFactory = this.getFopFactory(dpi);
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        ByteArrayOutputStream tempPdfFileOutputStream = new ByteArrayOutputStream();
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, tempPdfFileOutputStream);
        SAXResult tempPdfFileResult = new SAXResult(fop.getDefaultHandler());
        StreamSource tempFoFileSource = new StreamSource(foStringReader);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(tempFoFileSource, tempPdfFileResult);
        foStringReader.close();
        tempPdfFileOutputStream.close();
        return new ByteArrayInputStream(tempPdfFileOutputStream.toByteArray());
    }

    private synchronized FopFactory getFopFactory(int dpi) {
        boolean create;
        boolean bl = create = this.fopFactory == null || this.lastDpi == null || dpi != this.lastDpi;
        if (create) {
            File tmp = new File(System.getProperty("java.io.tmpdir"));
            FopFactoryBuilder fopFactoryBuilder = new FopFactoryBuilder(tmp.toURI());
            fopFactoryBuilder.setTargetResolution(dpi);
            fopFactoryBuilder.setSourceResolution(dpi);
            this.fopFactory = fopFactoryBuilder.build();
            this.lastDpi = dpi;
        }
        return this.fopFactory;
    }

    private StringReader createFoStringReader(String templateName, Map<String, ? extends Object> inputData, Map<String, Image> inputImages, Map<String, Collection<Image>> inputImageCollections, MessageResolver messageResolver) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        if (inputData != null && !inputData.isEmpty()) {
            for (Map.Entry<String, ? extends Object> entry : inputData.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    value = this.replaceEscapeChars((String)value);
                }
                velocityContext.put(entry.getKey(), value);
            }
        }
        if (inputImages != null && !inputImages.isEmpty()) {
            for (Map.Entry<String, ? extends Object> entry : inputImages.entrySet()) {
                velocityContext.put(entry.getKey(), PdfCreatorImpl.saveImageToTempFile((Image)entry.getValue()));
            }
        }
        if (inputImageCollections != null && !inputImageCollections.isEmpty()) {
            for (Map.Entry<String, ? extends Object> entry : inputImageCollections.entrySet()) {
                velocityContext.put(entry.getKey(), this.createImagePathCollection(entry));
            }
        }
        velocityContext.put("messageResolver", new XmlMessageResolverImpl(messageResolver));
        velocityContext.put("velocityUtils", new VelocityUtils());
        velocityContext.put("velocityPdfUtils", new VelocityPdfUtils());
        PdfVelocityEmitter pdfVelocityEmitter = new PdfVelocityEmitter(velocityContext, templateName);
        return pdfVelocityEmitter.callVelocity();
    }

    private String replaceEscapeChars(String s) {
        for (String k : ESCAPE_CHAR_MAP.keySet()) {
            s = s.replaceAll(k, ESCAPE_CHAR_MAP.get(k));
        }
        return s;
    }

    private List<String> createImagePathCollection(Map.Entry<String, Collection<Image>> imageCollectionEntry) throws IOException {
        ArrayList<String> imagePaths = new ArrayList<String>(imageCollectionEntry.getValue().size());
        for (Image image : imageCollectionEntry.getValue()) {
            imagePaths.add(PdfCreatorImpl.saveImageToTempFile(image));
        }
        return imagePaths;
    }

    public static String saveImageToTempFile(Image image) throws IOException {
        int origWidth = image.getWidth(null);
        int origHeight = image.getHeight(null);
        int resizedWidth = origWidth;
        int resizedHeight = origHeight;
        BufferedImage bi = new BufferedImage(resizedWidth, resizedHeight, 2);
        Graphics2D gc = bi.createGraphics();
        gc.drawImage(image, 0, 0, resizedWidth, resizedHeight, null);
        gc.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "PNG", baos);
        image.flush();
        bi.flush();
        StringBuilder builder = new StringBuilder();
        builder.append("data:image/png;base64,");
        builder.append(new String(Base64.encodeBase64(baos.toByteArray()), "ISO-8859-1"));
        return builder.toString();
    }

    static {
        ESCAPE_CHAR_MAP.put("\"", "&quot;");
        ESCAPE_CHAR_MAP.put("'", "&apos;");
        ESCAPE_CHAR_MAP.put("<", "&lt;");
        ESCAPE_CHAR_MAP.put(">", "&gt;");
        ESCAPE_CHAR_MAP.put("&", " &amp;");
    }
}

