/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.pdf.engine;

import java.text.ParseException;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.util.datatypes.Tupel;

public final class Format
implements Comparable<Format> {
    public static final Double MM_PER_INCH = 25.4;
    private static final int A_WIDTH_START = 841;
    private static final int A_HEIGHT_START = 1189;
    private static final int B_WIDTH_START = 1000;
    private static final int B_HEIGHT_START = 1414;
    private static final int C_WIDTH_START = 917;
    private static final int C_HEIGHT_START = 1297;
    private static final int D_WIDTH_START = 771;
    private static final int D_HEIGHT_START = 1091;
    private final DinRow dinRow;
    private final Type type;
    private final int clazz;
    private Tupel<Integer, Integer> size;

    public Format(DinRow dinRow, Type type, int clazz) {
        this.dinRow = dinRow;
        this.type = type;
        this.clazz = clazz;
    }

    public Tupel<Integer, Integer> getSizes() {
        if (this.size == null) {
            this.size = Format.getFormat(this.dinRow, this.type, this.clazz);
        }
        return this.size;
    }

    public Tupel<Double, Double> getSizes(int dpi, double marginX, double marginY) {
        Tupel<Integer, Integer> tupel = this.getSizes();
        double w = tupel.getElement1().intValue();
        double h = tupel.getElement2().intValue();
        return new Tupel<Double, Double>((w -= marginX) * ((double)dpi / MM_PER_INCH), (h -= marginY) * ((double)dpi / MM_PER_INCH));
    }

    public static Tupel<Integer, Integer> getFormat(DinRow row, Type type, int clazz) {
        int startWidth = 0;
        int startHeight = 0;
        switch (row) {
            case A: {
                startWidth = 841;
                startHeight = 1189;
                break;
            }
            case B: {
                startWidth = 1000;
                startHeight = 1414;
                break;
            }
            case C: {
                startWidth = 917;
                startHeight = 1297;
                break;
            }
            case D: {
                startWidth = 771;
                startHeight = 1091;
            }
        }
        for (int i = 0; i < clazz; ++i) {
            int newWidth;
            int newHeight = startWidth;
            startWidth = newWidth = startHeight / 2;
            startHeight = newHeight;
        }
        if (type == Type.LANDSCAPE) {
            int swap = startHeight;
            startHeight = startWidth;
            startWidth = swap;
        }
        return new Tupel<Integer, Integer>(startWidth, startHeight);
    }

    public DinRow getDinRow() {
        return this.dinRow;
    }

    public Type getType() {
        return this.type;
    }

    public int getClazz() {
        return this.clazz;
    }

    @Override
    public int compareTo(Format o) {
        int tt = 0;
        int to = 0;
        switch (this.getType()) {
            case PORTRAIT: {
                tt = 0;
                break;
            }
            case LANDSCAPE: {
                tt = 1;
            }
        }
        switch (o.getType()) {
            case PORTRAIT: {
                to = 0;
                break;
            }
            case LANDSCAPE: {
                to = 1;
            }
        }
        return new CompareToBuilder().append(this.getDinRow().name(), o.getDinRow().name()).append(this.getClazz(), o.getClazz()).append(tt, to).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Format) {
            Format other = (Format)obj;
            return new EqualsBuilder().append((Object)this.getDinRow(), (Object)other.getDinRow()).append((Object)this.getType(), (Object)other.getType()).append(this.getClazz(), other.getClazz()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getDinRow()).append((Object)this.getType()).append(this.getClazz()).toHashCode();
    }

    public static Format parseFormat(String formatString) throws ParseException {
        try {
            int length = formatString.length();
            if (length >= 2 && length <= 3) {
                String s = String.valueOf(formatString.charAt(0)).toUpperCase();
                DinRow dinRow = DinRow.valueOf(s);
                int clazz = Integer.parseInt(String.valueOf(formatString.charAt(1)));
                Type type = Type.PORTRAIT;
                if (length == 3) {
                    char t = Character.toUpperCase(formatString.charAt(2));
                    switch (t) {
                        case 'L': {
                            type = Type.LANDSCAPE;
                            break;
                        }
                        case 'P': {
                            break;
                        }
                        default: {
                            throw new ParseException(formatString, 0);
                        }
                    }
                }
                return new Format(dinRow, type, clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ParseException(formatString, 0);
    }

    public static enum Type {
        PORTRAIT,
        LANDSCAPE;

    }

    public static enum DinRow {
        A,
        B,
        C,
        D;

    }
}

