/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.DBConnector;
import de.datomino.osm.OsmUtil;
import de.datomino.osm.geodata.datamodel.Changeset;
import de.datomino.osm.geodata.datamodel.Node;
import de.datomino.osm.geodata.datamodel.Osm;
import de.datomino.osm.geodata.datamodel.Relation;
import de.datomino.osm.geodata.datamodel.Way;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Date;
import javax.xml.bind.Unmarshaller;

public class ImportOsmListener
extends Unmarshaller.Listener {
    protected int sumNodes = 0;
    protected int sumWays = 0;
    protected int sumRelations = 0;
    protected int sumChangeset = 0;
    protected int proStep = 100000;
    protected int nextStep = 100000;
    protected long stepStartTime = System.currentTimeMillis();
    protected long stepLastTime = System.currentTimeMillis();
    protected long stepEndTime = System.currentTimeMillis();
    protected Date startTime = new Date(System.currentTimeMillis());
    protected DBConnector databasis;
    private String logfile;

    public ImportOsmListener(DBConnector databasis, String logfile) throws ClassNotFoundException, SQLException {
        this.databasis = databasis;
        this.logfile = logfile;
        if (this.logfile == null) {
            try {
                File tempFile = File.createTempFile("importOsm", "txt");
                this.logfile = tempFile.getAbsolutePath();
                System.out.println("Logfile - " + this.logfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void afterUnmarshal(Object target, Object parent) {
        if (target instanceof Node) {
            Node node = (Node)target;
            if (node.getUid() == null) {
                node.setUid(BigInteger.ZERO);
                node.setUser("");
            }
            try {
                this.databasis.writeNodeToQuery(node);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                OsmUtil.writeFile(this.logfile, e.getLocalizedMessage() + "/nFailed Node - " + node.getId(), true);
            }
            ((Osm)parent).getNode().clear();
            ++this.sumNodes;
        } else if (target instanceof Way) {
            Way way = (Way)target;
            if (way.getUid() == null) {
                way.setUid(BigInteger.ZERO);
                way.setUser("");
            }
            try {
                this.databasis.writeWayToQuery(way);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                OsmUtil.writeFile(this.logfile, e.getLocalizedMessage() + "/nFailed Way - " + way.getId(), true);
            }
            ((Osm)parent).getWay().clear();
            ++this.sumWays;
        } else if (target instanceof Relation) {
            Relation relation = (Relation)target;
            if (relation.getUid() == null) {
                relation.setUid(BigInteger.ZERO);
                relation.setUser("");
            }
            try {
                this.databasis.writeRelationToQuery(relation);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                OsmUtil.writeFile(this.logfile, e.getLocalizedMessage() + "/nFailed Relation - " + relation.getId(), true);
            }
            ((Osm)parent).getRelation().clear();
            ++this.sumRelations;
        } else if (target instanceof Changeset) {
            ((Osm)parent).getChangeset().clear();
            ++this.sumChangeset;
        }
        this.store();
    }

    protected void store() {
        if (this.sumNodes + this.sumWays + this.sumRelations + this.sumChangeset >= this.nextStep) {
            this.databasis.batchExecute();
            this.stepLastTime = this.stepEndTime;
            this.stepEndTime = System.currentTimeMillis();
            System.out.println(new Date() + " - Nodes: " + this.sumNodes + ", Ways: " + this.sumWays + ", Relations: " + this.sumRelations + ", Changsets: " + this.sumChangeset);
            System.out.println("Duration: " + OsmUtil.formatLongToTimeStr(this.stepEndTime - this.stepStartTime) + "(Last Step: " + OsmUtil.formatLongToTimeStr(this.stepEndTime - this.stepLastTime) + ")");
            OsmUtil.writeFile(this.logfile, "Nodes: " + this.sumNodes + ", Ways: " + this.sumWays + ", Relations: " + this.sumRelations + ", Changsets: " + this.sumChangeset, true);
            OsmUtil.writeFile(this.logfile, "Duration: " + OsmUtil.formatLongToTimeStr(this.stepEndTime - this.stepStartTime) + "(Last Step: " + OsmUtil.formatLongToTimeStr(this.stepEndTime - this.stepLastTime) + ")", true);
            this.nextStep += this.proStep;
        }
    }

    public void writeLogForStart() {
        System.out.println("Start at: " + this.startTime);
        OsmUtil.writeFile(this.logfile, "Start at: " + this.startTime, false);
    }

    public void writeLogForEnd() {
        System.out.println("Sum of entrys: " + (this.sumChangeset + this.sumNodes + this.sumRelations + this.sumWays));
        System.out.println("Nodes: " + this.sumNodes + ", Ways: " + this.sumWays + ", Relations: " + this.sumRelations + ", Changsets: " + this.sumChangeset);
        OsmUtil.writeFile(this.logfile, "Sum of entrys: " + (this.sumChangeset + this.sumNodes + this.sumRelations + this.sumWays), true);
        OsmUtil.writeFile(this.logfile, "Nodes: " + this.sumNodes + ", Ways: " + this.sumWays + ", Relations: " + this.sumRelations + ", Changsets: " + this.sumChangeset, true);
        Date endTime = new Date(System.currentTimeMillis());
        System.out.println("End at:" + endTime);
        OsmUtil.writeFile(this.logfile, "End at:" + endTime, true);
        System.out.println("Total Duration: " + OsmUtil.formatLongToTimeStr(endTime.getTime() - this.startTime.getTime()));
        OsmUtil.writeFile(this.logfile, "Total Duration: " + OsmUtil.formatLongToTimeStr(endTime.getTime() - this.startTime.getTime()), true);
    }
}

