/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.DBConnector;
import de.datomino.osm.ImportOsmListener;
import de.datomino.osm.geodata.datamodel.Changeset;
import de.datomino.osm.geodata.datamodel.Node;
import de.datomino.osm.geodata.datamodel.Osm;
import de.datomino.osm.geodata.datamodel.Relation;
import de.datomino.osm.geodata.datamodel.Tag;
import de.datomino.osm.geodata.datamodel.Way;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.List;

public class ImportHighwayListener
extends ImportOsmListener {
    public ImportHighwayListener(DBConnector databasis, String logfile) throws ClassNotFoundException, SQLException {
        super(databasis, logfile);
    }

    @Override
    public void afterUnmarshal(Object target, Object parent) {
        if (target instanceof Node) {
            Node node = (Node)target;
            if (node.getUid() == null) {
                node.setUid(BigInteger.ZERO);
                node.setUser("");
            }
            if (node.getChangeset() == null) {
                node.setChangeset(BigInteger.ZERO);
            }
            try {
                this.databasis.writeNodeToQuery(node);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            ((Osm)parent).getNode().clear();
            ++this.sumNodes;
        } else if (target instanceof Way) {
            Way way = (Way)target;
            if (way.getChangeset() == null) {
                way.setChangeset(BigInteger.ZERO);
            }
            List<Tag> tags = way.getTag();
            for (Tag tag : tags) {
                if (!tag.getK().equals("highway")) continue;
                if (way.getUid() == null) {
                    way.setUid(BigInteger.ZERO);
                    way.setUser("");
                }
                try {
                    this.databasis.writeWayToQuery(way);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                break;
            }
            ((Osm)parent).getWay().clear();
            ++this.sumWays;
        } else if (target instanceof Relation) {
            ((Osm)parent).getRelation().clear();
            ++this.sumRelations;
        } else if (target instanceof Changeset) {
            ((Osm)parent).getChangeset().clear();
            ++this.sumChangeset;
        }
        super.store();
    }
}

