/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.DBConnector;
import de.datomino.osm.ImportOsmListener;
import de.datomino.osm.geodata.datamodel.Changeset;
import de.datomino.osm.geodata.datamodel.Node;
import de.datomino.osm.geodata.datamodel.Osm;
import de.datomino.osm.geodata.datamodel.Relation;
import de.datomino.osm.geodata.datamodel.Tag;
import de.datomino.osm.geodata.datamodel.Way;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.List;

public class ExtractPlaceNameListener
extends ImportOsmListener {
    public ExtractPlaceNameListener(DBConnector databasis, String logfile) throws ClassNotFoundException, SQLException {
        super(databasis, logfile);
    }

    @Override
    public void afterUnmarshal(Object target, Object parent) {
        if (target instanceof Node) {
            Node node = (Node)target;
            List<Tag> tags = node.getTag();
            for (Tag tag : tags) {
                if (!tag.getK().equals("place")) continue;
                if (node.getUid() == null) {
                    node.setUid(new BigInteger("0"));
                    node.setUser("");
                }
                try {
                    this.databasis.writeNodeToQuery(node);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                break;
            }
            ((Osm)parent).getNode().clear();
            ++this.sumNodes;
        } else if (target instanceof Way) {
            Way way = (Way)target;
            List<Tag> tags = way.getTag();
            for (Tag tag : tags) {
                if (!tag.getK().equals("place")) continue;
                if (way.getUid() == null) {
                    way.setUid(new BigInteger("0"));
                    way.setUser("");
                }
                try {
                    this.databasis.writeWayToQuery(way);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                break;
            }
            ((Osm)parent).getWay().clear();
            ++this.sumWays;
        } else if (target instanceof Relation) {
            Relation relation = (Relation)target;
            List<Tag> tags = relation.getTag();
            for (Tag tag : tags) {
                if (!tag.getK().equals("place")) continue;
                if (relation.getUid() == null) {
                    relation.setUid(new BigInteger("0"));
                    relation.setUser("");
                }
                try {
                    this.databasis.writeRelationToQuery(relation);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ((Osm)parent).getRelation().clear();
            ++this.sumRelations;
        } else if (target instanceof Changeset) {
            ((Osm)parent).getChangeset().clear();
            ++this.sumChangeset;
        }
        super.store();
    }
}

