/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.osm;

import de.datomino.osm.DBConnector;
import de.datomino.osm.geodata.datamodel.Member;
import de.datomino.osm.geodata.datamodel.Nd;
import de.datomino.osm.geodata.datamodel.Node;
import de.datomino.osm.geodata.datamodel.Relation;
import de.datomino.osm.geodata.datamodel.Tag;
import de.datomino.osm.geodata.datamodel.Way;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class DBConnectorImpl
extends HibernateDaoSupport
implements DBConnector {
    private List<String> batches = new LinkedList<String>();
    private Schema schema;
    private boolean executeBatch;

    @Override
    public Set<BigInteger> getPostcodeWayIdList() {
        final HashSet<BigInteger> list = new HashSet<BigInteger>();
        this.getSession().doWork(new Work(){

            @Override
            public void execute(Connection connection) throws SQLException {
                Statement statement = connection.createStatement();
                statement.setPoolable(true);
                ResultSet resultSet = statement.executeQuery("select way_id from " + DBConnectorImpl.this.schema.name() + ".t_relation_members where way_id IS NOT NULL");
                while (resultSet.next()) {
                    list.add(BigInteger.valueOf(resultSet.getLong(1)));
                }
                resultSet.close();
                statement.close();
            }
        });
        return list;
    }

    @Override
    public void batchExecute() {
        this.getSession().doWork(new Work(){

            @Override
            public void execute(Connection connection) throws SQLException {
                Statement statement = connection.createStatement();
                statement.setPoolable(true);
                for (String batch : DBConnectorImpl.this.batches) {
                    statement.addBatch(batch);
                }
                statement.executeBatch();
                statement.clearBatch();
                statement.close();
            }
        });
        this.batches = new LinkedList<String>();
    }

    @Override
    public void writeNodeToQuery(Node node) throws SQLException {
        String sql = "insert into " + this.schema.name() + ".t_nodes (id, version, user_id, tstamp, changeset_id, geom) values('" + node.getId() + "', '" + node.getVersion() + "', '" + node.getUid() + "', '" + node.getTimestamp().toGregorianCalendar().getTimeInMillis() + "', '" + node.getChangeset() + "', st_geomfromtext ( 'POINT ( " + node.getLon() + " " + node.getLat() + " )', 4326 ) )";
        this.addSql(sql);
        for (Tag tag : node.getTag()) {
            this.writeNodeTagToQuery(node.getId(), tag.getK(), tag.getV());
        }
    }

    private void writeNodeTagToQuery(BigInteger node_id, String k, String v) throws SQLException {
        v = v.replaceAll("'", "").replace("\\", " ");
        String sql = "insert into " + this.schema.name() + ".t_node_tags (id, node_id, key, value) values('0', '" + node_id + "', '" + k + "', '" + v + "')";
        this.addSql(sql);
    }

    @Override
    public void writeWayToQuery(Way way) throws SQLException {
        String sql = "insert into " + this.schema.name() + ".t_ways (id, version, user_id, tstamp, changeset_id) values('" + way.getId() + "', '" + way.getVersion() + "', '" + way.getUid() + "', '" + way.getTimestamp().toGregorianCalendar().getTimeInMillis() + "', '" + way.getChangeset() + "')";
        this.addSql(sql);
        for (Tag tag : way.getTag()) {
            this.writeWayTagToQuery(way.getId(), tag.getK(), tag.getV());
        }
        int sequence = 0;
        for (Nd nd : way.getNd()) {
            this.writeWayNodeToQuery(way.getId(), nd.getRef(), sequence++);
        }
    }

    private void writeWayTagToQuery(BigInteger way_id, String k, String v) throws SQLException {
        v = v.replaceAll("'", "").replace("\\", " ");
        String sql = "insert into " + this.schema.name() + ".t_way_tags (id, way_id, key, value) values('0', '" + way_id + "', '" + k + "', '" + v + "')";
        this.addSql(sql);
    }

    private void writeWayNodeToQuery(BigInteger way_id, BigInteger node_id, int sequence_id) throws SQLException {
        String sql = "insert into " + this.schema.name() + ".t_way_nodes (id, way_id, node_id, sequence_id) values('0', '" + way_id + "', '" + node_id + "', '" + sequence_id + "')";
        this.addSql(sql);
    }

    @Override
    public void writeRelationToQuery(Relation relation) throws SQLException {
        String sql = "insert into " + this.schema.name() + ".t_relations (id, version, user_id, tstamp, changeset_id) values('" + relation.getId() + "', '" + relation.getVersion() + "', '" + relation.getUid() + "', '" + relation.getTimestamp().toGregorianCalendar().getTimeInMillis() + "', '" + relation.getChangeset() + "')";
        this.addSql(sql);
        for (Tag tag : relation.getTag()) {
            this.writeRelationTagToQuery(relation.getId(), tag.getK(), tag.getV());
        }
        int sequence = 0;
        for (Member member : relation.getMember()) {
            this.writeRelationMemberToQuery(relation.getId(), member.getRef(), member.getType(), member.getRole(), sequence++);
        }
    }

    private void writeRelationTagToQuery(BigInteger relation_id, String k, String v) throws SQLException {
        v = v.replaceAll("'", "").replace("\\", " ");
        String sql = "insert into " + this.schema.name() + ".t_relation_tags (id, relation_id, key, value) values('0', '" + relation_id + "', '" + k + "', '" + v + "')";
        this.addSql(sql);
    }

    private void writeRelationMemberToQuery(BigInteger relation_id, BigInteger member_id, String member_type, String member_role, int sequence_id) throws SQLException {
        if (member_type.toLowerCase().charAt(0) == 'n') {
            String sql = "insert into " + this.schema.name() + ".t_relation_members (id, parent_relation_id, member_id, member_role, sequence_id, node_id) values('0', '" + relation_id + "', '" + member_id + "', '" + member_role + "', '" + sequence_id + "', '" + member_id + "')";
            this.addSql(sql);
        } else if (member_type.toLowerCase().charAt(0) == 'w') {
            String sql = "insert into " + this.schema.name() + ".t_relation_members (id, parent_relation_id, member_id, member_role, sequence_id, way_id) values('0', '" + relation_id + "', '" + member_id + "', '" + member_role + "', '" + sequence_id + "', '" + member_id + "')";
            this.addSql(sql);
        } else if (member_type.toLowerCase().charAt(0) == 'r') {
            String sql = "insert into " + this.schema.name() + ".t_relation_members (id, parent_relation_id, member_id, member_role, sequence_id, relation_id) values('0', '" + relation_id + "', '" + member_id + "', '" + member_role + "', '" + sequence_id + "', '" + member_id + "')";
            this.addSql(sql);
        }
    }

    private void addSql(final String sql) {
        if (this.executeBatch) {
            this.batches.add(sql);
        } else {
            this.getSession().doWork(new Work(){

                @Override
                public void execute(Connection connection) throws SQLException {
                    Statement statement = connection.createStatement();
                    statement.execute(sql);
                    statement.close();
                }
            });
        }
    }

    @Override
    public void executeSqlQuerys(String sqlQuerys) {
        for (String sqlQuery : sqlQuerys.split(";")) {
            sqlQuery = sqlQuery.replace("[[SCHEMA]]", this.schema.name());
            this.addSql(sqlQuery);
        }
        this.batchExecute();
    }

    @Override
    public void setSchema(String schema) {
        this.schema = Schema.valueOf(schema);
        if (this.schema == null) {
            System.err.println("invalid schema");
            System.exit(-1);
        }
    }

    @Override
    public void clearBatch() {
        this.batches.clear();
    }

    public void setExecuteBatch(boolean executeBatch) {
        this.executeBatch = executeBatch;
    }

    private static enum Schema {
        osm_highway,
        osm_plain,
        osm_placename,
        street_postdirekt;

    }
}

