/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.tsp.aglorithm;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTimeWindowDto;
import de.datomino.logistic.tsp.aglorithm.AbstractSimulatedAnnealingAlgorithm;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.collections.IteratorUtils;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwTspFinder<T extends Serializable, N extends LogisticStopDto<T>>
extends AbstractSimulatedAnnealingAlgorithm<N, N> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwTspFinder.class);
    private double pr = 0.06;
    private double k = 0.9999;
    private Vector<Edge<?>> bestCompatibleTour;

    public TwTspFinder(Graph graph, N start, N target, Long randomSeed) {
        super(graph, LogisticServicesUtil.createNode(start, StopType.POI_START, new double[0]), LogisticServicesUtil.createNode(target, StopType.POI_END, new double[0]), 1, 0, randomSeed);
        this.r = 0.95;
        this.stepLimit = 30000;
        this.initializeAllowedStopMap();
    }

    @Override
    protected int algoImpl(int minIndex, int maxIndex, Random random) {
        if (this.tour.size() < 3 || maxIndex - minIndex <= 0) {
            return 0;
        }
        Vector bestTour = null;
        List<Node<N>> compatibleNodes = this.findCompatibleNodes(this.tour);
        if (compatibleNodes.isEmpty()) {
            this.tour = null;
            return 0;
        }
        this.bestCompatibleTour = super.createEdgeList(compatibleNodes);
        if (this.tour.size() == compatibleNodes.size() - 1) {
            bestTour = this.tour;
        }
        double p = 0.0;
        double maxP = this.k / (1.0 - this.k);
        double t = this.initTemperature(minIndex, maxIndex, random, maxP);
        int step = 0;
        int nochangedStep = 0;
        boolean turned = true;
        while (nochangedStep < 100) {
            ++nochangedStep;
            LOGGER.info("T" + ++step + " - " + t);
            LOGGER.info("P" + step + " - " + p);
            for (int i = 0; i < this.stepLimit; ++i) {
                Vector<Edge<?>> newTour = null;
                try {
                    newTour = this.randomInterchange(this.tour, minIndex, maxIndex, turned, random);
                }
                catch (Exception e) {
                    continue;
                }
                double length = this.getPathLengthWithPenalty(this.tour, p);
                double newLength = this.getPathLengthWithPenalty(newTour, p);
                double dE = length - newLength;
                if (dE > 0.0 || Math.exp(dE / t) > random.nextDouble()) {
                    this.tour = newTour;
                }
                compatibleNodes = this.findCompatibleNodes(newTour);
                double d = this.compareTourLength(bestTour, newTour);
                if (this.tour.size() == compatibleNodes.size() - 1 && d > 0.0) {
                    LOGGER.info("New Length of Tour: " + d);
                    bestTour = new Vector(newTour);
                    nochangedStep = 0;
                    continue;
                }
                if (this.tour.size() == compatibleNodes.size() - 1 && d == 0.0) {
                    if (!(this.getPathCost(newTour) < this.getPathCost(bestTour))) continue;
                    LOGGER.info("New Length of Tour: " + d);
                    bestTour = new Vector(newTour);
                    nochangedStep = 0;
                    continue;
                }
                if (this.bestCompatibleTour.size() < compatibleNodes.size() - 1) {
                    this.bestCompatibleTour = super.createEdgeList(compatibleNodes);
                    continue;
                }
                if (this.bestCompatibleTour.size() != compatibleNodes.size() - 1) continue;
                Vector<Edge<?>> newEdgeList = super.createEdgeList(compatibleNodes);
                double subD = this.compareTourLength(this.bestCompatibleTour, newEdgeList);
                if (subD > 0.0) {
                    this.bestCompatibleTour = newEdgeList;
                    continue;
                }
                if (subD != 0.0 || !(this.getPathCost(newEdgeList) < this.getPathCost(this.bestCompatibleTour))) continue;
                this.bestCompatibleTour = newEdgeList;
            }
            turned = !turned;
            t *= this.r;
            double penalty = this.getPenalty(this.tour, p);
            if (penalty != 0.0) {
                double length = this.getPathLength(this.tour);
                double newP = length / penalty * this.k / (1.0 - this.k);
                maxP = maxP < newP ? newP : maxP;
            }
            p = maxP * (1.0 - Math.exp(-1.0 * this.pr * (double)step));
        }
        this.tour = bestTour;
        LOGGER.info("Length of the best tour: " + this.getPathCost(this.tour) + " (after " + step + " steps)");
        return step;
    }

    private double compareTourLength(Vector<Edge<?>> t1, Vector<Edge<?>> t2) {
        double length1 = 0.0;
        if (t1 == null) {
            length1 = Double.MAX_VALUE;
        } else {
            for (Edge<?> edge : t1) {
                length1 += edge.getCostAt(0);
            }
        }
        double length2 = 0.0;
        if (t2 == null) {
            length2 = Double.MAX_VALUE;
        } else {
            for (Edge<?> edge : t2) {
                length2 += edge.getCostAt(0);
            }
        }
        return length1 - length2;
    }

    private double initTemperature(int minIndex, int maxIndex, Random random, double p) {
        int n = 1000;
        double[] lengths = new double[n];
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            try {
                Vector<Edge<?>> t = this.randomInterchange(this.tour, minIndex, maxIndex, true, random);
                lengths[i] = this.getPathLengthWithPenalty(t, p);
                sum += lengths[i];
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        double average = sum / (double)n;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.abs(lengths[i] - average);
        }
        return d / (double)n / Math.log(1.0638297872340425);
    }

    private double getPathCost(Vector<Edge<?>> edges) {
        if (edges == null || edges.isEmpty()) {
            return Double.MAX_VALUE;
        }
        long firstArrivalTime = -1L;
        long arrivalTime = this.tourStartTime;
        Node<?> first = edges.get(0).getStart();
        Tupel<Long, Long> firstTw = this.getNearbyTimeWindow((LogisticStopDto)first.getAssociatedObject(), arrivalTime);
        if (firstTw.getElement2() != -1L && firstTw.getElement1() > arrivalTime) {
            firstArrivalTime = arrivalTime = firstTw.getElement1().longValue();
        }
        arrivalTime += Math.round(first.getCostAt(this.costIndexNode));
        for (Edge<?> edge : edges) {
            long succ = arrivalTime + Math.round(edge.getCostAt(this.costIndexEdge));
            Node<?> t = edge.getTarget();
            Tupel<Long, Long> tw = this.getNearbyTimeWindow((LogisticStopDto)t.getAssociatedObject(), succ);
            succ = Math.max(tw.getElement1(), succ);
            arrivalTime = succ + Math.round(t.getCostAt(this.costIndexNode));
            if (firstArrivalTime != -1L) continue;
            firstArrivalTime = tw.getElement1();
        }
        return arrivalTime - (firstArrivalTime == -1L ? this.tourStartTime : firstArrivalTime);
    }

    private double getPenalty(List<Edge<?>> edges, double p) {
        double d = 0.0;
        long arrivalTime = this.tourStartTime;
        Node<?> first = edges.get(0).getStart();
        Tupel<Long, Long> firstTw = this.getNearbyTimeWindow((LogisticStopDto)first.getAssociatedObject(), arrivalTime);
        if (firstTw.getElement2() != -1L) {
            d += (double)Math.max(0L, arrivalTime - firstTw.getElement2());
            arrivalTime = Math.max(firstTw.getElement1(), arrivalTime);
        }
        arrivalTime += arrivalTime == -1L ? 0L : Math.round(first.getCostAt(this.costIndexNode));
        for (Edge<?> edge : edges) {
            Node<?> t = edge.getTarget();
            Tupel<Long, Long> tw = this.getNearbyTimeWindow((LogisticStopDto)t.getAssociatedObject(), arrivalTime += arrivalTime == -1L ? 0L : Math.round(edge.getCostAt(this.costIndexEdge)));
            if (tw.getElement2() != -1L) {
                d += (double)Math.max(0L, arrivalTime - tw.getElement2());
                arrivalTime = Math.max(tw.getElement1(), arrivalTime);
            }
            arrivalTime += arrivalTime == -1L ? 0L : Math.round(t.getCostAt(this.costIndexNode));
        }
        return d * p;
    }

    private double getPathLengthWithPenalty(List<Edge<?>> edges, double p) {
        return this.getPathLength(edges) + this.getPenalty(edges, p);
    }

    @Override
    public void findMinTsp(Random random) {
        if (this.tour == null) {
            return;
        }
        LOGGER.info("Tour size: " + (this.tour.size() + 1) + " nodes");
        LOGGER.info("Length of Tour: " + this.getPathCost(this.tour) + " (before)");
        int minIndex = this.startFix ? 1 : 0;
        int maxIndex = this.targetFix ? this.tour.size() - 1 : this.tour.size();
        int step = this.algoImpl(minIndex, maxIndex, random);
        if (this.tour == null) {
            if (this.bestCompatibleTour == null && this.bestCompatibleTour.isEmpty()) {
                LOGGER.error("Failed tour");
            } else {
                LOGGER.info("Size of the compatible tour: " + (this.bestCompatibleTour.size() + 1));
                LOGGER.info("Length of the compatible tour: " + this.getPathCost(this.bestCompatibleTour) + " (after " + step + " steps)");
                this.tour = this.bestCompatibleTour;
                List<Node<N>> compatibleNodes = this.getNodeList(this.bestCompatibleTour);
                Iterator<Node<?>> nodeIter = this.graph.getNodeIterator();
                while (nodeIter.hasNext()) {
                    Node<?> node = nodeIter.next();
                    if (compatibleNodes.contains(node)) continue;
                    ((LogisticStopDto)node.getAssociatedObject()).setBadTimeWindow(true);
                    compatibleNodes.add(node);
                }
                this.tour = super.createEdgeList(compatibleNodes);
            }
        }
    }

    @Override
    public void buildInitializedTour() {
        Vector twTour = new Vector();
        this.buildInitializedTwTour(twTour);
        List<Node<N>> twList = this.getNodeList(twTour);
        if (this.startFix && !twList.contains(this.start)) {
            twList.remove(this.start);
            twList.add(0, this.start);
        }
        Iterator<Node<?>> nodeIter = this.graph.getNodeIterator();
        while (nodeIter.hasNext()) {
            Node<?> node = nodeIter.next();
            if (twList.contains(node)) continue;
            twList.add(node);
        }
        if (this.targetFix) {
            twList.remove(this.target);
            twList.add(this.target);
        }
        if (twList.size() < 3) {
            return;
        }
        this.tour = super.createEdgeList(twList);
    }

    private void buildInitializedTwTour(Vector<Edge<?>> twTour) {
        Node<Object> pred = this.start == null ? null : this.start;
        HashSet<Node<N>> tabuSet = new HashSet<Node<N>>();
        if (this.targetFix) {
            tabuSet.add(this.target);
        }
        while (pred == null) {
            Iterator<Node<?>> nodeIterator = this.graph.getNodeIterator();
            if (this.nearbyNodeMap.isEmpty()) {
                pred = nodeIterator.next();
                continue;
            }
            pred = this.findEarlest(IteratorUtils.toList(nodeIterator), tabuSet);
            if (!((Collection)this.nearbyNodeMap.get(pred)).isEmpty()) continue;
            tabuSet.add(pred);
        }
        while (twTour.size() != this.nearbyNodeMap.size()) {
            tabuSet.addAll(this.getNodeList(twTour));
            tabuSet.add(pred);
            Node<N> next = this.findEarlest(this.nearbyNodeMap.keySet(), tabuSet);
            if (next == null) break;
            twTour.addElement(this.getEdge(pred, next));
            pred = next;
        }
    }

    private Node<N> findEarlest(Collection<Node<N>> nodes, Collection<Node<N>> tabuSet) {
        Node<N> earlest = null;
        long earliestTime = Long.MAX_VALUE;
        long endTime = Long.MAX_VALUE;
        if (nodes == null) {
            nodes = this.nearbyNodeMap.keySet();
        }
        for (Node<N> node : nodes) {
            Tupel<Long, Long> timeTupel;
            LogisticStopDto n = (LogisticStopDto)node.getAssociatedObject();
            if (tabuSet.contains(node) || !this.hasTimeWindow(n) || (timeTupel = this.getNearbyTimeWindow(n, -1L)).getElement1() >= earliestTime && (timeTupel.getElement1() != earliestTime || timeTupel.getElement2() >= endTime)) continue;
            earlest = node;
            earliestTime = timeTupel.getElement1();
            endTime = timeTupel.getElement2();
        }
        return earlest;
    }

    private void initializeAllowedStopMap() {
        this.nearbyNodeMap = new HashMap();
        Iterator<Node<?>> iter1 = this.graph.getNodeIterator();
        while (iter1.hasNext()) {
            Node<?> node1 = iter1.next();
            LogisticStopDto n1 = (LogisticStopDto)node1.getAssociatedObject();
            if (!this.hasTimeWindow(n1)) continue;
            this.nearbyNodeMap.put(node1, new HashSet());
            Iterator<Node<?>> iter2 = this.graph.getNodeIterator();
            while (iter2.hasNext()) {
                Node<?> node2 = iter2.next();
                LogisticStopDto n2 = (LogisticStopDto)node2.getAssociatedObject();
                if (!this.hasTimeWindow(n2) || !this.timeAccessible(node1, node2)) continue;
                ((Collection)this.nearbyNodeMap.get(node1)).add(node2);
            }
        }
    }

    private boolean timeAccessible(Node<N> node1, Node<N> node2) {
        LogisticStopDto n2;
        LogisticStopDto n1 = (LogisticStopDto)node1.getAssociatedObject();
        if (n1.equals(n2 = (LogisticStopDto)node2.getAssociatedObject())) {
            return false;
        }
        List<LogisticTimeWindowDto> tws1 = n1.getTimeWindows();
        List<LogisticTimeWindowDto> tws2 = n2.getTimeWindows();
        if (tws1.isEmpty() || tws2.isEmpty()) {
            return true;
        }
        double duration = node1.getCostAt(this.costIndexNode) + super.getEdge(node1, node2).getCostAt(this.costIndexEdge);
        for (LogisticTimeWindowDto tw1 : tws1) {
            if (tw1.getStartTime() != null && !this.checkTimeFeasibility(this.addSeconds(tw1.getStartTime(), duration), tws2)) continue;
            return true;
        }
        return false;
    }

    private List<Node<N>> findCompatibleNodes(Vector<Edge<?>> edges) {
        ArrayList<Node<N>> compatibleNodes = new ArrayList<Node<N>>();
        if (this.tourEndTime != -1L && this.tourEndTime < this.tourStartTime) {
            return compatibleNodes;
        }
        long arrivalTime = this.tourStartTime;
        for (Edge<?> edge : edges) {
            Node<?> startNode = edge.getStart();
            LogisticStopDto n = (LogisticStopDto)startNode.getAssociatedObject();
            long earliestTime = this.getNearbyTimeWindow(n, arrivalTime).getElement1();
            if (earliestTime != -1L && !this.checkTimeFeasibility(arrivalTime, n.getTimeWindows())) continue;
            compatibleNodes.add(startNode);
            arrivalTime = Math.max(earliestTime, arrivalTime) + Math.round(startNode.getCostAt(this.costIndexNode)) + Math.round(edge.getCostAt(this.costIndexEdge));
        }
        Node<?> lastNode = edges.get(edges.size() - 1).getTarget();
        if (!this.hasTimeWindow((LogisticStopDto)lastNode.getAssociatedObject())) {
            compatibleNodes.add(lastNode);
        } else if (this.checkTimeFeasibility(arrivalTime, ((LogisticStopDto)lastNode.getAssociatedObject()).getTimeWindows()) && (this.tourEndTime == -1L || (arrivalTime += Math.round(lastNode.getCostAt(this.costIndexNode))) <= this.tourEndTime)) {
            compatibleNodes.add(lastNode);
        }
        return compatibleNodes;
    }

    private long addSeconds(Date date, double amount) {
        if (date == null) {
            return -1L;
        }
        return date.getTime() / 1000L + Math.round(amount);
    }

    private List<Node<N>> getNodeList(List<Edge<?>> edges) {
        ArrayList<Node<N>> nodeList = new ArrayList<Node<N>>(edges.size() + 1);
        for (Edge<?> edge : edges) {
            if (nodeList.isEmpty()) {
                nodeList.add(edge.getStart());
            }
            nodeList.add(edge.getTarget());
        }
        return nodeList;
    }

    @Override
    protected List<N> getNodeObjectList(List<Edge<?>> edges) {
        List<Node<N>> nodeList = this.getNodeList(edges);
        ArrayList ls = new ArrayList(edges.size() + 1);
        CollectionUtil.transform(nodeList, ls, new Transformer<Node<N>, N>(){

            @Override
            public N transform(Node<N> t) {
                return (LogisticStopDto)t.getAssociatedObject();
            }
        });
        return ls;
    }
}

