/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.tsp.aglorithm;

import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.tsp.aglorithm.AbstractSimulatedAnnealingAlgorithm;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.logistic.util.StreetSideEntity;
import de.datomino.util.collection.CollectionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetSideSAMinTspFinder<T extends Serializable, N extends StreetSideEntity<T>, R extends LogisticStopDto<T>>
extends AbstractSimulatedAnnealingAlgorithm<N, R> {
    private static Logger LOGGER = LoggerFactory.getLogger(StreetSideSAMinTspFinder.class);

    public StreetSideSAMinTspFinder(Graph graph, N start, N target, Long randomSeed) {
        this(graph, start, target, 0, -1, randomSeed);
    }

    public StreetSideSAMinTspFinder(Graph graph, Node<N> startNode, Node<N> targetNode, Long randomSeed) {
        super(graph, startNode, targetNode, 0, -1, randomSeed);
    }

    public StreetSideSAMinTspFinder(Graph graph, N start, N target, int costIndexEdge, int costIndexNode, Long randomSeed) {
        super(graph, LogisticServicesUtil.createNode(start, StopType.POI_START, new double[0]), LogisticServicesUtil.createNode(target, StopType.POI_END, new double[0]), costIndexEdge, costIndexNode, randomSeed);
    }

    @Override
    public void findMinTsp(Random random) {
        Vector<Edge<?>> bestTour = this.cutAndFind(random);
        this.tour = bestTour == null ? this.findMinTsp(0.0, false, random) : bestTour;
    }

    private Vector<Edge<?>> cutAndFind(Random random) {
        Vector<Edge<?>> tour2;
        double averageLength = this.getPathLength(this.tour) / (double)this.tour.size();
        LOGGER.info("The average length between stops: " + averageLength);
        Vector<Edge<?>> bestTour = this.findMinTsp(averageLength / 1.0, false, random);
        Vector<Edge<?>> tour1 = this.findMinTsp(averageLength / 2.0, false, random);
        if (tour1 != null && (bestTour == null || this.getPathLength(tour1) < this.getPathLength(bestTour))) {
            bestTour = tour1;
        }
        if ((tour2 = this.findMinTsp(averageLength / 3.0, false, random)) != null && (bestTour == null || this.getPathLength(tour2) < this.getPathLength(bestTour))) {
            bestTour = tour2;
        }
        this.min = 1.0E17;
        this.forcedBreak = true;
        bestTour = this.findMinTsp(0.0, true, random);
        this.forcedBreak = false;
        return bestTour;
    }

    private Vector<Edge<?>> findMinTsp(double length, boolean initailized, Random random) {
        this.nearbyNodeMap = new HashMap();
        if (!initailized) {
            this.buildInitializedTour();
        }
        if (this.tour == null) {
            return null;
        }
        LOGGER.info("First tour size: " + (this.tour.size() + 1) + " nodes");
        LOGGER.info("Length of Tour: " + this.getPathLength(this.tour) + " (before)");
        int step = this.algoImpl(1, this.tour.size() - 1, random);
        LOGGER.info("After the first phase: size " + (this.tour.size() + 1) + " nodes");
        LOGGER.info("Length of the tour: " + this.getPathLength(this.tour) + " (after " + step + " steps)");
        this.complementTour(random);
        if (this.tour == null) {
            return null;
        }
        LOGGER.info("After complement: ");
        LOGGER.info("The tour size: " + (this.tour.size() + 1));
        LOGGER.info("Length of the tour: " + this.getPathLength(this.tour));
        return new Vector(this.tour);
    }

    private void complementTour(Random random) {
        Vector<Edge<?>> newTour;
        this.r = 0.9;
        this.min = 1.0E9;
        for (Node node : this.nearbyNodeMap.keySet()) {
            Node<?> targetNode;
            Edge edge;
            int index = 0;
            Iterator edgeIter = this.tour.iterator();
            while (edgeIter.hasNext() && !(edge = (Edge)edgeIter.next()).getTarget().equals(node)) {
                ++index;
            }
            if (index >= this.tour.size()) {
                index = -1;
            }
            ArrayList part1 = index < 0 ? null : new ArrayList(this.tour.subList(0, index));
            ArrayList part2 = index + 2 > this.tour.size() ? null : new ArrayList(this.tour.subList(index + 2, this.tour.size()));
            Edge lastEdgeOfPart1 = index < 0 ? null : (Edge)this.tour.elementAt(index);
            Edge firstEdgeOfPart2 = part2 == null ? null : (Edge)this.tour.elementAt(index + 1);
            Node<?> startNode = lastEdgeOfPart1 == null ? null : lastEdgeOfPart1.getOther(node);
            Node<?> node2 = targetNode = firstEdgeOfPart2 == null ? null : firstEdgeOfPart2.getOther(node);
            if (part1 == null) {
                startNode = null;
                targetNode = ((Edge)this.tour.get(0)).getOther(node);
            }
            List<Edge<?>> newPart = this.buildEdges(startNode, targetNode, (Collection)this.nearbyNodeMap.get(node));
            this.tour.clear();
            if (part1 != null) {
                this.tour.addAll(part1);
            }
            this.tour.addAll(newPart);
            if (part2 != null) {
                this.tour.addAll(part2);
            }
            int startIndex = part1 == null ? 0 : part1.size();
            int step = this.algoImpl(startIndex == 0 ? (startIndex = 1) : startIndex, startIndex + newPart.size() - 1, random);
            LOGGER.info("Complement: " + (newPart.size() - 1) + " nodes");
            LOGGER.info("Length of the tour: " + this.getPathLength(this.tour) + " (after " + step + " steps)");
        }
        int size = this.tour.size();
        if (!this.startFix) {
            int i;
            for (i = 1; i < size + 1; ++i) {
                Vector<Edge<?>> newTour2 = super.interchangeNodes(this.tour, 0, i);
                if (!(this.getPathLength(newTour2) < this.getPathLength(this.tour)) || !this.checkFeasibility(newTour2)) continue;
                this.tour = newTour2;
                LOGGER.info("Length of the best tour: " + this.getPathLength(this.tour) + " (change start)");
            }
            for (i = 1; i < size + 1; ++i) {
                int start = 0;
                newTour = null;
                for (int end = i; start < end; ++start, --end) {
                    newTour = super.interchangeNodes(this.tour, start, end);
                }
                if (newTour == null || !(this.getPathLength(newTour) < this.getPathLength(this.tour)) || !this.checkFeasibility(newTour)) continue;
                this.tour = newTour;
                LOGGER.info("Length of the best tour: " + this.getPathLength(this.tour) + " (change start)");
            }
        }
        if (!this.targetFix) {
            int i;
            for (i = 0; i < size; ++i) {
                Vector<Edge<?>> newTour3 = super.interchangeNodes(this.tour, i, size);
                if (!(this.getPathLength(newTour3) < this.getPathLength(this.tour)) || !this.checkFeasibility(newTour3)) continue;
                this.tour = newTour3;
                LOGGER.info("Length of the best tour: " + this.getPathLength(this.tour) + " (change target)");
            }
            for (i = 0; i < size; ++i) {
                int start = i;
                newTour = null;
                for (int end = size; start < end; ++start, --end) {
                    newTour = super.interchangeNodes(this.tour, start, end);
                }
                if (newTour == null || !(this.getPathLength(newTour) < this.getPathLength(this.tour)) || !this.checkFeasibility(newTour)) continue;
                this.tour = newTour;
                LOGGER.info("Length of the best tour: " + this.getPathLength(this.tour) + " (change target)");
            }
        }
    }

    @Override
    public void buildInitializedTour() {
        Edge maxEdge = this.getMaxEdge();
        if (maxEdge == null) {
            return;
        }
        this.tour = new Vector();
        Node<?> prev = this.start;
        while (true) {
            this.findTooShortEdges(prev);
            Edge<Tupel<Object, Object>> shortestEdge = this.getEdgeWithoutTarget(prev, CollectionUtil.buildHashSet(this.target));
            if (shortestEdge == null) {
                int count = this.graph.getOutEdgeCount(prev);
                for (int i = 0; i < count; ++i) {
                    Edge<?> edge = this.graph.getOutEdgeAt(prev, i);
                    if (!this.target.equals(edge.getTarget())) continue;
                    shortestEdge = edge;
                    break;
                }
                this.tour.add(shortestEdge);
                break;
            }
            this.tour.add(shortestEdge);
            prev = shortestEdge.getOther(prev);
        }
        while (!(this.checkFeasibility(this.tour) && this.checkCompleteness() || this.tour == null)) {
            this.edgeTabuSet.add(maxEdge);
            this.buildInitializedTour();
        }
    }

    private void findTooShortEdges(Node<N> node) {
        if (node.equals(this.start) || node.equals(this.target)) {
            return;
        }
        int count = this.graph.getOutEdgeCount(node);
        for (int i = 0; i < count; ++i) {
            Edge<?> edge = this.graph.getOutEdgeAt(node, i);
            if (this.isNodeOnPath(edge.getTarget(), this.tour) || !(edge.getCostAt(this.costIndexEdge) < 0.0)) continue;
            if (this.nearbyNodeMap.keySet().contains(edge.getStart())) {
                ((Collection)this.nearbyNodeMap.get(edge.getStart())).add(edge.getTarget());
                continue;
            }
            ArrayList list = new ArrayList();
            list.add(node);
            list.add(edge.getTarget());
            this.nearbyNodeMap.put(edge.getStart(), list);
        }
    }

    @Override
    public Double getMaxCost(Edge<Tupel<N, N>> edge) {
        return edge.getCostAt(this.costIndexEdge);
    }

    @Override
    protected List<R> getNodeObjectList(List<Edge<?>> edges) {
        ArrayList<StreetSideEntity> ls = new ArrayList<StreetSideEntity>(edges.size() + 1);
        for (Edge<?> edge : edges) {
            if (ls.isEmpty()) {
                ls.add((StreetSideEntity)edge.getStart().getAssociatedObject());
            }
            ls.add((StreetSideEntity)edge.getTarget().getAssociatedObject());
        }
        ArrayList rs = new ArrayList();
        for (StreetSideEntity n : ls) {
            rs.add(n.getStart());
            rs.add(n.getEnd());
        }
        return rs;
    }
}

