/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.tsp.aglorithm;

import de.datomino.logistic.tsp.AbstractLogisticMinTspFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.DijkstraPathFinder;
import org.ktde.util.algorithm.AlgorithmException;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimulatedAnnealingAlgorithm<N, R>
extends AbstractLogisticMinTspFinder<N, R> {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractSimulatedAnnealingAlgorithm.class);
    protected Map<Node<N>, Collection<Node<N>>> nearbyNodeMap = new HashMap<Node<N>, Collection<Node<N>>>();
    protected Set<Edge<Tupel<N, N>>> edgeTabuSet;
    protected double r = 0.9;
    protected double min = 1.0E11;
    protected boolean forcedBreak = false;
    protected int stepLimit = 100000;
    private Long randomSeed;
    private boolean forCircle = false;

    public AbstractSimulatedAnnealingAlgorithm(Graph graph, Node<N> start, Node<N> target, int costIndexEdge, int costIndexNode, Long randomSeed) {
        super(graph, start, target, costIndexEdge, costIndexNode);
        if (this.start.getAssociatedObject() != null) {
            this.startFix = true;
        } else {
            this.startFix = false;
            this.start = null;
        }
        if (this.target.getAssociatedObject() != null) {
            this.targetFix = true;
        } else {
            this.targetFix = false;
            this.target = null;
        }
        this.edgeTabuSet = new HashSet<Edge<Tupel<N, N>>>();
        this.randomSeed = randomSeed;
    }

    @Override
    protected void perform() throws AlgorithmException {
        this.buildInitializedTour();
        if (this.tour == null) {
            this.errorMessage = "time windows are invalid";
            return;
        }
        Random random = this.randomSeed == null ? new Random() : new Random(this.randomSeed);
        this.findMinTsp(random);
        if (this.tour == null) {
            this.errorMessage = "find no tour";
            return;
        }
        if (!(!this.forCircle || this.startFix && this.targetFix)) {
            Vector noCircle = this.tour;
            this.findMinTspForCircle(random);
            Double oldLength = this.getPathLength(noCircle);
            Double newLength = this.getPathLength(this.tour);
            if (oldLength <= newLength) {
                this.tour = noCircle;
            }
        }
    }

    private void findMinTspForCircle(Random random) throws AlgorithmException {
        int removeIndex = 0;
        if (this.targetFix) {
            this.start = new Node<String>("Start");
            this.addCloneNode(this.target, this.start);
        } else {
            if (!this.startFix) {
                this.start = ((Edge)this.tour.get(0)).getStart();
            }
            this.target = new Node<String>("Target");
            this.addCloneNode(this.start, this.target);
            removeIndex = this.tour.size();
        }
        this.startFix = true;
        this.targetFix = true;
        this.buildInitializedTour();
        this.findMinTsp(random);
        this.tour.remove(removeIndex);
    }

    private void addCloneNode(Node<?> node, Node<?> clone) {
        int inEdgeCount = this.graph.getInEdgeCount(node);
        for (int i = 0; i < inEdgeCount; ++i) {
            Edge<?> edge = this.graph.getInEdgeAt(node, i);
            this.addEdge(edge.getOther(node), clone, edge.isDirected(), edge.getCost());
        }
        int outEdgeCount = this.graph.getOutEdgeCount(node);
        for (int i = 0; i < outEdgeCount; ++i) {
            Edge<?> edge = this.graph.getOutEdgeAt(node, i);
            this.addEdge(clone, edge.getOther(node), edge.isDirected(), edge.getCost());
        }
        this.addEdge(node, clone, false, 0.0, 0.0);
        this.addEdge(clone, node, false, 0.0, 0.0);
    }

    private void addEdge(Node<? extends Object> start, Node<? extends Object> target, boolean bilateral, double ... cost) {
        Tupel<Object, Object> associatedObject = new Tupel<Object, Object>(start.getAssociatedObject(), target.getAssociatedObject());
        Edge<Tupel<Object, Object>> edge = new Edge<Tupel<Object, Object>>(associatedObject, start, target, bilateral, cost);
        this.graph.addEdge(edge);
    }

    protected int algoImpl(int minIndex, int maxIndex, Random random) {
        if (this.tour.size() < 3) {
            return 0;
        }
        Vector<Edge<Object>> bestTour = new Vector(this.tour);
        if (minIndex < 0 && this.startFix) {
            minIndex = 1;
        }
        if (maxIndex > this.tour.size() - 1 && this.targetFix) {
            maxIndex = this.tour.size() - 1;
        }
        if (maxIndex - minIndex <= 0) {
            return 0;
        }
        double t = this.getPathLength(this.tour.subList(minIndex, maxIndex));
        double minT = t / this.min;
        int step = 0;
        int nochangedStep = 0;
        boolean turned = true;
        while (t > minT) {
            boolean isChanged = false;
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < (maxIndex - minIndex + 1) * 5; ++i) {
                    ++step;
                    ++nochangedStep;
                    Vector<Edge<?>> newTour = null;
                    try {
                        newTour = this.randomInterchange(this.tour, minIndex, maxIndex, turned, random);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    double dE = this.getPathLength(this.tour) - this.getPathLength(newTour);
                    if (dE >= 0.0) {
                        this.tour = newTour;
                        isChanged = true;
                        if (!(this.getPathLength(this.tour) < this.getPathLength(bestTour)) || !this.checkFeasibility(newTour)) continue;
                        bestTour = new Vector(this.tour);
                        nochangedStep = 0;
                        continue;
                    }
                    if (!(Math.exp(dE / t) > random.nextDouble())) continue;
                    this.tour = newTour;
                    isChanged = true;
                }
                turned = !turned;
                t = this.r * t;
            }
            if (!isChanged) {
                LOGGER.info("No change. Optimization is aborted");
                break;
            }
            if (!this.forcedBreak || nochangedStep <= this.stepLimit) continue;
            LOGGER.info("Over step limit. Optimization is aborted");
            break;
        }
        this.tour = bestTour;
        LOGGER.info("Length of the best tour: " + this.getPathLength(this.tour) + " - " + this.tour.size() + " (after " + step + " steps)");
        return step;
    }

    protected Vector<Edge<?>> interchangeNodes(Vector<Edge<?>> edges, int index1, int index2) {
        ArrayList part1 = new ArrayList(edges.subList(0, index1));
        ArrayList part2 = new ArrayList(edges.subList(index1, index2));
        ArrayList part3 = new ArrayList(edges.subList(index2, edges.size()));
        Edge lastEdgeOfPart1 = part1.isEmpty() ? null : (Edge)part1.remove(part1.size() - 1);
        Edge firstEdgeOfPart2 = (Edge)part2.remove(0);
        Edge lastEdgeOfPart2 = null;
        if (!part2.isEmpty()) {
            lastEdgeOfPart2 = (Edge)part2.remove(part2.size() - 1);
        }
        Edge firstEdgeOfPart3 = part3.isEmpty() ? null : (Edge)part3.remove(0);
        Node<?> connectedNode1 = lastEdgeOfPart1 == null ? firstEdgeOfPart2.getStart() : this.getConnectedNode(lastEdgeOfPart1, firstEdgeOfPart2);
        Node<?> connectedNode2 = firstEdgeOfPart2.getOther(connectedNode1);
        if (lastEdgeOfPart2 != null) {
            Node<?> node = connectedNode2 = firstEdgeOfPart3 == null ? lastEdgeOfPart2.getTarget() : this.getConnectedNode(lastEdgeOfPart2, firstEdgeOfPart3);
        }
        if (lastEdgeOfPart1 != null) {
            part1.add(this.getShortestPath(lastEdgeOfPart1.getOther(connectedNode1), connectedNode2));
        }
        if (lastEdgeOfPart2 != null) {
            part2.add(0, this.getShortestPath(connectedNode2, firstEdgeOfPart2.getOther(connectedNode1)));
            part2.add(this.getShortestPath(lastEdgeOfPart2.getOther(connectedNode2), connectedNode1));
        } else {
            part2.add(this.getShortestPath(connectedNode2, connectedNode1));
        }
        if (firstEdgeOfPart3 != null) {
            part3.add(0, this.getShortestPath(connectedNode1, firstEdgeOfPart3.getOther(connectedNode2)));
        }
        Vector newTour = new Vector(edges.size());
        newTour.addAll(part1);
        newTour.addAll(part2);
        newTour.addAll(part3);
        return newTour;
    }

    protected Vector<Edge<?>> interchangeEdges(Vector<Edge<?>> edges, int startIndex, int endIndex, int insertIndex) {
        Node<?> newLastNode;
        Node<?> connectedNode2;
        ArrayList part1 = new ArrayList(edges.subList(0, startIndex));
        ArrayList part2 = new ArrayList(edges.subList(startIndex, endIndex));
        ArrayList part3 = new ArrayList(edges.subList(endIndex, edges.size()));
        Edge firstEdgeOfPart2 = (Edge)part2.get(0);
        Edge lastEdgeOfPart2 = (Edge)part2.get(part2.size() - 1);
        Edge lastEdgeOfPart1 = part1.isEmpty() ? null : (Edge)part1.remove(part1.size() - 1);
        Edge firstEdgeOfPart3 = part3.isEmpty() ? null : (Edge)part3.remove(0);
        Node<?> connectedNode1 = lastEdgeOfPart1 == null ? firstEdgeOfPart2.getStart() : this.getConnectedNode(lastEdgeOfPart1, firstEdgeOfPart2);
        Node<?> node = connectedNode2 = firstEdgeOfPart3 == null ? lastEdgeOfPart2.getTarget() : this.getConnectedNode(lastEdgeOfPart2, firstEdgeOfPart3);
        if (connectedNode1 == null || connectedNode2 == null) {
            return null;
        }
        Node<?> newFirstNode = lastEdgeOfPart1 == null ? null : lastEdgeOfPart1.getOther(connectedNode1);
        Node<?> node2 = newLastNode = firstEdgeOfPart3 == null ? null : firstEdgeOfPart3.getOther(connectedNode2);
        if (newFirstNode != null && newLastNode != null) {
            part1.add(this.getShortestPath(newFirstNode, newLastNode));
        }
        Vector newTour = new Vector(edges.size());
        newTour.addAll(part1);
        newTour.addAll(part3);
        Edge insertEdge = (Edge)newTour.remove(insertIndex);
        part2.add(0, this.getShortestPath(insertEdge.getStart(), connectedNode1));
        part2.add(this.getShortestPath(connectedNode2, insertEdge.getTarget()));
        newTour.addAll(insertIndex, part2);
        return newTour;
    }

    @Override
    public Vector<Edge<?>> randomInterchange(Vector<Edge<?>> edges, int minIndex, int maxIndex, boolean changeEdge, Random random) throws Exception {
        int size = maxIndex - minIndex;
        long random1 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
        long random2 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
        while (random1 == random2) {
            random1 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
            random2 = Math.round(random.nextDouble() * (double)size) + (long)minIndex;
        }
        int startIndex = (int)Math.min(random1, random2);
        int endIndex = (int)Math.max(random1, random2);
        int insertIndex = (int)(Math.round(random.nextDouble() * (double)(size - endIndex + startIndex - 1)) + (long)minIndex);
        if (changeEdge) {
            return this.interchangeEdges(edges, startIndex, endIndex, insertIndex);
        }
        return this.interchangeNodes(edges, startIndex, endIndex);
    }

    @Override
    public boolean checkFeasibility(Vector<Edge<?>> edges) {
        boolean b = true;
        if (this.checkCompleteness()) {
            if (this.startFix) {
                Node<?> first = edges.get(0).getStart();
                b = first.equals(this.start);
            } else if (this.targetFix) {
                Node<?> last = edges.get(edges.size() - 1).getTarget();
                b = last.equals(this.target);
            }
        }
        return b;
    }

    protected Edge<Tupel<N, N>> getMaxEdge() {
        this.tour = null;
        Double maxLength = null;
        Edge maxEdge = null;
        Iterator<Edge<?>> edgeIter = this.graph.getEdgeIterator();
        while (edgeIter.hasNext()) {
            Double pathLength;
            Edge edge = edgeIter.next();
            if (this.edgeTabuSet.contains(edge)) continue;
            if (this.startFix && this.targetFix) {
                if (!this.start.equals(edge.getStart()) || !this.target.equals(edge.getTarget())) continue;
                if (this.checkFeasibility(new Vector(Arrays.asList(edge)))) {
                    maxEdge = edge;
                    break;
                }
                return null;
            }
            if (this.startFix && !this.targetFix) {
                if (!this.start.equals(edge.getStart())) continue;
                pathLength = this.getMaxCost(edge);
                if (maxLength != null && !(maxLength < pathLength) || !this.checkFeasibility(new Vector(Arrays.asList(edge)))) continue;
                maxLength = pathLength;
                maxEdge = edge;
                continue;
            }
            if (!this.startFix && this.targetFix) {
                if (!this.target.equals(edge.getTarget())) continue;
                pathLength = this.getMaxCost(edge);
                if (maxLength != null && !(maxLength < pathLength) || !this.checkFeasibility(new Vector(Arrays.asList(edge)))) continue;
                maxLength = pathLength;
                maxEdge = edge;
                continue;
            }
            pathLength = this.getMaxCost(edge);
            if (maxLength != null && !(maxLength < pathLength) || !this.checkFeasibility(new Vector(Arrays.asList(edge)))) continue;
            maxLength = pathLength;
            maxEdge = edge;
        }
        if (maxEdge != null) {
            this.start = maxEdge.getStart();
            this.target = maxEdge.getTarget();
        }
        return maxEdge;
    }

    protected List<Edge<?>> buildEdges(Node<?> start, Node<?> target, Collection<Node<N>> nodes) {
        ArrayList edges = new ArrayList(nodes.size() + 2);
        Node<Object> pred = start;
        Iterator<Node<N>> nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            if (pred == null) {
                pred = nodeIter.next();
                continue;
            }
            Node<N> succ = nodeIter.next();
            edges.add(this.getShortestPath(pred, succ));
            pred = succ;
        }
        if (target != null) {
            edges.add(this.getShortestPath(pred, target));
        }
        return edges;
    }

    protected Vector<Edge<?>> invertPath(List<Edge<?>> path) {
        Vector invertedPath = new Vector();
        for (int i = path.size() - 1; i >= 0; --i) {
            Edge<?> edge = path.get(i);
            invertedPath.add(this.getShortestPath(edge.getTarget(), edge.getStart()));
        }
        return invertedPath;
    }

    protected Node<?> getConnectedNode(Edge<?> edge1, Edge<?> edge2) {
        Node<?> node = edge1.getStart();
        if (node.equals(edge2.getStart()) || node.equals(edge2.getTarget())) {
            return node;
        }
        node = edge1.getTarget();
        if (node.equals(edge2.getStart()) || node.equals(edge2.getTarget())) {
            return node;
        }
        return null;
    }

    protected boolean checkCompleteness() {
        if (this.tour == null) {
            return false;
        }
        Iterator<Node<?>> nodeIter = this.graph.getNodeIterator();
        while (nodeIter.hasNext()) {
            boolean complete = false;
            Node<?> node = nodeIter.next();
            for (Edge edge : this.tour) {
                if (!node.equals(edge.getStart()) && !node.equals(edge.getTarget())) continue;
                complete = true;
                break;
            }
            for (Collection collection : this.nearbyNodeMap.values()) {
                if (collection == null || !collection.contains(node)) continue;
                complete = true;
                break;
            }
            if (complete) continue;
            return false;
        }
        return true;
    }

    protected Edge<Tupel<N, N>> getEdgeWithoutTarget(Node<N> startNode, Collection<?> targets) {
        Edge<?> shortestEdge = null;
        int count = this.graph.getOutEdgeCount(startNode);
        for (int i = 0; i < count; ++i) {
            Edge<?> edge = this.graph.getOutEdgeAt(startNode, i);
            if (this.isNodeOnPath(edge.getTarget(), this.tour) || targets.contains(edge.getTarget()) || !this.checkFeasibility(new Vector(Arrays.asList(edge)))) continue;
            shortestEdge = edge;
            break;
        }
        return shortestEdge;
    }

    protected boolean isNodeOnPath(Node<?> node, Collection<Edge<?>> path) {
        if (node.equals(this.start) || node.equals(this.target)) {
            return true;
        }
        for (Edge<?> edge : path) {
            if (!edge.getStart().equals(node) && !edge.getTarget().equals(node)) continue;
            return true;
        }
        if (this.nearbyNodeMap == null) {
            return false;
        }
        for (Collection collection : this.nearbyNodeMap.values()) {
            if (collection == null) continue;
            for (Node n : collection) {
                if (!n.equals(node)) continue;
                return true;
            }
        }
        return false;
    }

    protected Edge<?> getShortestPath(Node<?> startNode, Node<?> targetNode) {
        int count = this.graph.getOutEdgeCount(startNode);
        for (int i = 0; i < count; ++i) {
            Edge<?> edge = this.graph.getOutEdgeAt(startNode, i);
            if (!targetNode.equals(edge.getTarget())) continue;
            return edge;
        }
        DijkstraPathFinder finder = new DijkstraPathFinder(this.graph, startNode, targetNode, this.costIndexEdge, this.costIndexNode);
        Vector<Edge<?>> path = finder.findTour();
        double[] cost = new double[]{0.0, 0.0};
        cost[this.costIndexNode] = this.getPathLength(path);
        Tupel tupel = new Tupel(startNode.getAssociatedObject(), targetNode.getAssociatedObject());
        Edge newEdge = new Edge(tupel, startNode, targetNode, true, cost);
        this.graph.addEdge(newEdge);
        return newEdge;
    }

    protected Double getPathLength(Collection<Edge<?>> path) {
        if (path == null) {
            return Double.MAX_VALUE;
        }
        double length = 0.0;
        for (Edge<?> edge : path) {
            length += edge.getCostAt(this.costIndexEdge);
        }
        return length;
    }

    protected Edge<Tupel<?, ?>> getEdge(Node<?> startNode, Node<?> endNode) {
        int count = this.graph.getOutEdgeCount(startNode);
        for (int i = 0; i < count; ++i) {
            Edge<Tupel<?, ?>> edge = this.graph.getOutEdgeAt(startNode, i);
            if (!edge.getTarget().equals(endNode)) continue;
            return edge;
        }
        return null;
    }

    protected Vector<Edge<?>> createEdgeList(List<Node<N>> nodeList) {
        Vector edges = new Vector();
        Iterator<Node<N>> iter = nodeList.iterator();
        Node<N> pred = iter.next();
        while (iter.hasNext()) {
            Node<N> succ = iter.next();
            edges.addElement(this.getEdge(pred, succ));
            pred = succ;
        }
        return edges;
    }

    @Override
    public void setForCircle(boolean forCircle) {
        this.forCircle = forCircle;
    }
}

