/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.impl;

import de.datomino.logistic.LocationQualifier;
import de.datomino.logistic.LogisticException;
import de.datomino.logistic.LogisticRoute;
import de.datomino.logistic.LogisticRoutingServicesInterface;
import de.datomino.logistic.dto.DistanceEntityDto;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.dto.TourPartType;
import de.datomino.logistic.tsp.LogisticMinTspFinder;
import de.datomino.logistic.tsp.aglorithm.BranchAndCutSAMinTspFinder;
import de.datomino.logistic.tsp.aglorithm.StreetSideSAMinTspFinder;
import de.datomino.logistic.tsp.aglorithm.TwTspFinder;
import de.datomino.logistic.type.RangeType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.LogisticServicesUtil;
import de.datomino.logistic.util.StreetSideEntity;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class LogisticRoutingServicesImpl<T extends Serializable>
implements LogisticRoutingServicesInterface<T> {
    private LocationQualifier locationQualifier;
    private LogisticRoute<T> logisticRouteService;
    private Long randomSeed;
    private boolean forCircle;

    @Override
    public LogisticQualifiedLocationDto validateLocation(LogisticLocationDto<?> logisticLocationDto) throws LogisticException {
        return this.locationQualifier.validateLocation(logisticLocationDto);
    }

    @Override
    public List<LogisticQualifiedLocationDto> findLocations(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, boolean exact, String userLoginName) throws LogisticException {
        return this.locationQualifier.findLocations(logisticLocationDto, maxCount, exact, userLoginName);
    }

    @Override
    public List<LogisticQualifiedLocationDto> findRange(LogisticLocationDto<?> logisticLocationDto, Tupel<Tupel<Integer, String>, Tupel<Integer, String>> range, RangeType rangeType, Integer maxCount) throws LogisticException {
        return this.locationQualifier.findRange(logisticLocationDto, range, rangeType, maxCount);
    }

    @Override
    @Deprecated
    public LogisticTourDto<T> calculateTour(LogisticTourDto<T> logisticTourDto) throws LogisticException {
        return this.logisticRouteService.calculateTour(logisticTourDto);
    }

    @Override
    public LogisticTourDto<T> optimizeTour(LogisticTourDto<T> logisticTourDto, OptimizationAlgorithmType optimizationAlgorithmType) throws LogisticException {
        if (logisticTourDto == null) {
            return logisticTourDto;
        }
        for (LogisticTourPartDto<T> tourPart : logisticTourDto.getTourParts()) {
            if (tourPart == null || tourPart.getStopDtos() == null || tourPart.getStopDtos().isEmpty() || tourPart.getStopDtos().size() < 3) continue;
            List<LogisticStopDto<T>> stops = tourPart.getStopDtos();
            LogisticStopDto<T> startStop = null;
            if (tourPart.getRoutingType().isStartFix()) {
                startStop = stops.get(0);
            }
            LogisticStopDto<T> endStop = null;
            if (tourPart.getRoutingType().isEndFix()) {
                endStop = stops.get(stops.size() - 1);
            }
            LogisticMinTspFinder<Serializable, LogisticStopDto<T>> logisticMinTspFinder = null;
            switch (optimizationAlgorithmType) {
                case DEFAULT: 
                case DEFAULT_SEGMENT_MIDDLE: 
                case CLUSTERING: 
                case TOURPARTS_SEGMENT_MIDDLE: 
                case AREA_GROUP: {
                    logisticMinTspFinder = this.optimizeDefault(logisticTourDto, startStop, stops, endStop, false);
                    logisticMinTspFinder.setForCircle(this.forCircle);
                    break;
                }
                case CLUSTERING_TIME: 
                case DEFAULT_TIME: 
                case SEGMENT_TIME: {
                    logisticMinTspFinder = this.optimizeDefault(logisticTourDto, startStop, stops, endStop, true);
                    break;
                }
                case DEFAULT_STREET_SIDE: 
                case CLUSTERING_STREET_SIDE: {
                    logisticMinTspFinder = this.optimizeStreetSide(logisticTourDto, startStop, stops, endStop);
                    break;
                }
                case TIME_WINDOW: {
                    logisticMinTspFinder = this.optimizeTimeWindow(logisticTourDto, startStop, stops, endStop);
                    break;
                }
                case NONE: 
                case CHRISTOFIDES: {
                    return logisticTourDto;
                }
            }
            List tspTour = logisticMinTspFinder.getTour();
            tourPart.getStopDtos().clear();
            for (LogisticStopDto stop : tspTour) {
                tourPart.getStopDtos().add(stop);
            }
        }
        return logisticTourDto;
    }

    private LogisticMinTspFinder<LogisticStopDto<T>, LogisticStopDto<T>> optimizeTimeWindow(LogisticTourDto<T> logisticTourDto, LogisticStopDto<T> startStop, List<LogisticStopDto<T>> stops, LogisticStopDto<T> endStop) throws LogisticException {
        Graph graph = this.buildGraphFromStops(stops, startStop, logisticTourDto);
        TwTspFinder twTspFinder = new TwTspFinder(graph, startStop, endStop, this.randomSeed);
        if (logisticTourDto.getStartTime() != null) {
            twTspFinder.setTourStartTime(logisticTourDto.getStartTime());
        }
        if (logisticTourDto.getEndTime() != null) {
            twTspFinder.setTourEndTime(logisticTourDto.getEndTime());
        }
        return twTspFinder;
    }

    private LogisticMinTspFinder<StreetSideEntity<T>, LogisticStopDto<T>> optimizeStreetSide(LogisticTourDto<T> logisticTourDto, LogisticStopDto<T> startStop, List<LogisticStopDto<T>> stops, LogisticStopDto<T> endStop) throws LogisticException {
        Graph graph = new Graph();
        StreetSideEntity<T> startSide = startStop == null ? null : startStop.getStreetSide();
        StreetSideEntity<T> endSide = endStop == null ? null : endStop.getStreetSide();
        HashSet<StreetSideEntity<T>> streetSideSet = new HashSet<StreetSideEntity<T>>();
        for (LogisticStopDto<T> logisticStopDto : stops) {
            StreetSideEntity<T> streetSideEntity = logisticStopDto.getStreetSide();
            streetSideSet.add(streetSideEntity);
        }
        if (startStop != null && !stops.contains(startStop)) {
            Node<StreetSideEntity<T>> predNode = LogisticServicesUtil.createNode(startStop.getStreetSide(), StopType.POI_START, new double[0]);
            for (StreetSideEntity streetSideEntity : streetSideSet) {
                Node<StreetSideEntity> sideStartNode = LogisticServicesUtil.createNode(streetSideEntity, streetSideEntity.getStops().get(0).getStopType(), new double[0]);
                this.addEdge(graph, predNode, sideStartNode, false, this.getEdgeCosts(startSide.getEnd(), streetSideEntity.getStart(), logisticTourDto));
            }
        }
        for (StreetSideEntity streetSideEntity : streetSideSet) {
            Node<StreetSideEntity> node = LogisticServicesUtil.createNode(streetSideEntity, streetSideEntity.getStops().get(0).getStopType(), new double[0]);
            LogisticStopDto sideStart1 = streetSideEntity.getStart();
            Coordinate sideStartCoordinate1 = ((ImmutablePoint)sideStart1.getLocation().getAccessGeom().getGeoObject()).getCoordinate();
            LogisticStopDto sideEnd1 = streetSideEntity.getEnd();
            Coordinate sideEndCoordinate1 = ((ImmutablePoint)sideEnd1.getLocation().getAccessGeom().getGeoObject()).getCoordinate();
            for (StreetSideEntity streetSideEntity2 : streetSideSet) {
                if (streetSideEntity.equals(streetSideEntity2)) continue;
                Node<StreetSideEntity> sideNode2 = LogisticServicesUtil.createNode(streetSideEntity2, streetSideEntity2.getStops().get(0).getStopType(), new double[0]);
                LogisticStopDto sideStart2 = streetSideEntity2.getStart();
                Coordinate sideStartCoordinate2 = ((ImmutablePoint)sideStart2.getLocation().getAccessGeom().getGeoObject()).getCoordinate();
                LogisticStopDto sideEnd2 = streetSideEntity2.getEnd();
                Coordinate sideEndCoordinate2 = ((ImmutablePoint)sideEnd2.getLocation().getAccessGeom().getGeoObject()).getCoordinate();
                this.addEdge(graph, node, sideNode2, false, this.getEdgeCosts(sideEnd1, sideStart2, logisticTourDto));
                this.addEdge(graph, sideNode2, node, false, this.getEdgeCosts(sideEnd2, sideStart1, logisticTourDto));
            }
        }
        return new StreetSideSAMinTspFinder(graph, startSide, endSide, this.randomSeed);
    }

    private LogisticMinTspFinder<LogisticStopDto<T>, LogisticStopDto<T>> optimizeDefault(LogisticTourDto<T> logisticTourDto, LogisticStopDto<T> startStop, List<LogisticStopDto<T>> stops, LogisticStopDto<T> endStop, boolean checkTimeWindow) throws LogisticException {
        Graph graph = this.buildGraphFromStops(stops, startStop, logisticTourDto);
        BranchAndCutSAMinTspFinder tspFinder = new BranchAndCutSAMinTspFinder(graph, startStop, endStop, this.randomSeed);
        if (checkTimeWindow) {
            tspFinder.setTourStartTime(logisticTourDto.getStartTime());
            tspFinder.setCheckTimeWindow(true);
        }
        return tspFinder;
    }

    private Graph buildGraphFromStops(List<LogisticStopDto<T>> stops, LogisticStopDto<T> startStop, LogisticTourDto<T> logisticTourDto) throws LogisticException {
        Graph graph = new Graph();
        if (startStop != null && !stops.contains(startStop)) {
            StopType stopType = startStop == null ? null : startStop.getStopType();
            Node<LogisticStopDto<T>> predNode = LogisticServicesUtil.createNode(startStop, stopType, new double[0]);
            for (int i = 0; i < stops.size(); ++i) {
                int cost = stops.get(i).getDurationInSecond() == null ? 0 : stops.get(i).getDurationInSecond();
                Node<LogisticStopDto<T>> succNode = LogisticServicesUtil.createNode(stops.get(i), stops.get(i).getStopType(), cost);
                this.addEdge(graph, predNode, succNode, true, this.getEdgeCosts(startStop, stops.get(i), logisticTourDto));
                this.addEdge(graph, succNode, predNode, true, this.getEdgeCosts(stops.get(i), startStop, logisticTourDto));
            }
        }
        for (int i = 0; i < stops.size(); ++i) {
            int costI = stops.get(i).getDurationInSecond() == null ? 0 : stops.get(i).getDurationInSecond();
            Node<LogisticStopDto<T>> predNode = LogisticServicesUtil.createNode(stops.get(i), stops.get(i).getStopType(), costI);
            for (int j = 0; j < stops.size(); ++j) {
                if (i == j) continue;
                int costJ = stops.get(j).getDurationInSecond() == null ? 0 : stops.get(j).getDurationInSecond();
                Node<LogisticStopDto<T>> succNode = LogisticServicesUtil.createNode(stops.get(j), stops.get(j).getStopType(), costJ);
                this.addEdge(graph, predNode, succNode, true, this.getEdgeCosts(stops.get(i), stops.get(j), logisticTourDto));
                this.addEdge(graph, succNode, predNode, true, this.getEdgeCosts(stops.get(j), stops.get(i), logisticTourDto));
            }
        }
        return graph;
    }

    private void addEdge(Graph graph, Node<? extends Object> start, Node<? extends Object> target, boolean bilateral, double ... cost) {
        Tupel<Object, Object> associatedObject = new Tupel<Object, Object>(start.getAssociatedObject(), target.getAssociatedObject());
        Edge<Tupel<Object, Object>> edge = new Edge<Tupel<Object, Object>>(associatedObject, start, target, bilateral, cost);
        graph.addEdge(edge);
    }

    private double[] getEdgeCosts(LogisticStopDto<T> startStop, LogisticStopDto<T> endStop, LogisticTourDto<T> logisticTourDto) throws LogisticException {
        ImmutablePoint endGeom;
        DistanceEntityDto distanceEntity = logisticTourDto.getDistanceMap().get(new Tupel(startStop.getId(), endStop.getId()));
        if (startStop.equals(endStop)) {
            return new double[]{0.0, 0.0};
        }
        ImmutablePoint startGeom = (ImmutablePoint)startStop.getLocation().getGeom().getGeoObject();
        if (GeoUtils.areSamedPoints(startGeom, endGeom = (ImmutablePoint)endStop.getLocation().getGeom().getGeoObject(), (Double)1.0)) {
            return new double[]{0.0, 0.0};
        }
        ImmutablePoint startPoint = (ImmutablePoint)startStop.getLocation().getAccessGeom().getGeoObject();
        ImmutablePoint endPoint = (ImmutablePoint)endStop.getLocation().getAccessGeom().getGeoObject();
        double distance = -1.0;
        double duration = -1.0;
        if (distanceEntity != null && distanceEntity.getDistance() != null) {
            distance = distanceEntity.getDistance().intValue();
            if (distanceEntity.getDuration() != null) {
                duration = distanceEntity.getDuration().intValue();
            }
        }
        if (distance == -1.0) {
            distance = GeoUtils.getDistanceInMeter(startPoint.getCoordinate(), endPoint.getCoordinate());
        }
        if (duration == -1.0) {
            distance = LogisticServicesUtil.calculateDuration(distance, this.getVehicleTupel(startStop, endStop, logisticTourDto).getElement1());
        }
        double accessDistance = GeoUtils.getDistanceInMeter(startPoint.getCoordinate(), startGeom.getCoordinate()) + GeoUtils.getDistanceInMeter(endPoint.getCoordinate(), endGeom.getCoordinate());
        double accessDuration = accessDistance * logisticTourDto.getParcelLocation() / 1.3888888888888888 / 100.0;
        return new double[]{distance + accessDistance, duration * logisticTourDto.getDifficultLevel() / 100.0 + accessDuration};
    }

    private Tupel<RouteVehicleType, RouteType> getVehicleTupel(LogisticStopDto<T> pred, LogisticStopDto<T> succ, LogisticTourDto<T> tour) {
        Tupel<Object, Object> tupel = new Tupel<Object, Object>(null, null);
        LogisticTourPartDto<T> predPart = null;
        LogisticTourPartDto<T> succPart = null;
        for (LogisticTourPartDto<T> tourPart : tour.getTourParts()) {
            if (tourPart.getStopDtos().contains(pred)) {
                predPart = tourPart;
            }
            if (tourPart.getStopDtos().contains(succ)) {
                succPart = tourPart;
            }
            if (predPart == null || succPart == null) continue;
            break;
        }
        if (predPart != null && succPart != null) {
            if (predPart.equals(succPart)) {
                tupel.setElement1(predPart.getRouteVehicleType());
                tupel.setElement2(predPart.getRouteType());
            } else if (predPart.getTourPartType() != TourPartType.NO_LINK) {
                tupel.setElement1(predPart.getRouteVehicleType());
                tupel.setElement2(predPart.getRouteType());
            } else if (succPart.getTourPartType() != TourPartType.NO_LINK) {
                tupel.setElement1(succPart.getRouteVehicleType());
                tupel.setElement2(succPart.getRouteType());
            }
        }
        return tupel;
    }

    public void setLogisticRouteService(LogisticRoute logisticRouteService) {
        this.logisticRouteService = logisticRouteService;
    }

    public void setLocationQualifier(LocationQualifier locationQualifier) {
        this.locationQualifier = locationQualifier;
    }

    @Override
    public boolean isIdentifyable() {
        return this.locationQualifier.isIdentifyable();
    }

    @Override
    public boolean isRangeable() {
        return this.locationQualifier.isRangeable();
    }

    @Override
    public String getName() {
        return this.locationQualifier.getName();
    }

    @Override
    public Long getGap() {
        return this.locationQualifier.getGap();
    }

    public void setRandomSeed(String randomSeed) {
        if (!StringUtil.isBlank(randomSeed)) {
            this.randomSeed = Long.valueOf(randomSeed);
        }
    }

    public void setForCircle(String forCircle) {
        this.forCircle = StringUtil.isTrue(forCircle);
    }

    @Override
    public List<LogisticQualifiedLocationDto> findLocationsWithWildcard(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, String userLoginName) throws LogisticException {
        throw new RuntimeException("Method not allowed");
    }

    @Override
    public boolean supportsWildcard() {
        return false;
    }
}

