/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.dto;

import de.datomino.logistic.dto.AbstractLogisticDto;
import de.datomino.logistic.dto.DistanceEntityDto;
import de.datomino.logistic.dto.LogisticDelivererDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.logistic.dto.LogisticTourPartDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ktde.util.datatypes.Tupel;

public class LogisticTourDto<T extends Serializable>
extends AbstractLogisticDto<Long> {
    private static final long serialVersionUID = -9089739338313971165L;
    private Date startTime;
    private Date endTime;
    private Integer durationSum;
    private Integer distanceSum;
    private Integer accessSum;
    private LogisticDelivererDto deliverer;
    private List<LogisticTourPartDto<T>> tourParts;
    private Map<Tupel<T, T>, DistanceEntityDto> distanceMap = new HashMap<Tupel<T, T>, DistanceEntityDto>();
    private boolean saved = true;

    public LogisticTourDto(Long id) {
        super(id);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public List<LogisticTourPartDto<T>> getTourParts() {
        if (this.tourParts == null) {
            this.tourParts = new ArrayList<LogisticTourPartDto<T>>();
        }
        return this.tourParts;
    }

    public void setTourParts(List<LogisticTourPartDto<T>> tourParts) {
        this.tourParts = tourParts;
    }

    public LogisticDelivererDto getDeliverer() {
        return this.deliverer;
    }

    public void setDeliverer(LogisticDelivererDto deliverer) {
        this.deliverer = deliverer;
    }

    public Integer getDurationSum() {
        return this.durationSum;
    }

    public void setDurationSum(Integer durationSum) {
        this.durationSum = durationSum;
    }

    public Integer getDistanceSum() {
        return this.distanceSum;
    }

    public void setDistanceSum(Integer distanceSum) {
        this.distanceSum = distanceSum;
    }

    public Integer getAccessSum() {
        return this.accessSum;
    }

    public void setAccessSum(Integer accessSum) {
        this.accessSum = accessSum;
    }

    public Map<Tupel<T, T>, DistanceEntityDto> getDistanceMap() {
        if (this.distanceMap == null) {
            this.distanceMap = new HashMap<Tupel<T, T>, DistanceEntityDto>();
        }
        return this.distanceMap;
    }

    public synchronized void putDistanceEntity(LogisticStopDto<T> start, LogisticStopDto<T> target, DistanceEntityDto entity) {
        this.getDistanceMap().put(new Tupel(start.getId(), target.getId()), entity);
    }

    public void setDistanceMap(Map<Tupel<T, T>, DistanceEntityDto> distanceMap) {
        this.distanceMap = distanceMap;
    }

    public Integer countStopDto() {
        Integer count = 0;
        for (LogisticTourPartDto<T> tourPart : this.getTourParts()) {
            count = count + tourPart.getStopDtos().size();
        }
        return count;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public Double getDifficultLevel() {
        if (this.tourParts == null) {
            return 100.0;
        }
        return this.tourParts.get(0).getDifficultLevel();
    }

    public Double getParcelLocation() {
        if (this.tourParts == null) {
            return 100.0;
        }
        return this.tourParts.get(0).getParcelLocation();
    }
}

