/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.dto;

import de.datomino.logistic.dto.AbstractLogisticDto;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticServiceDto;
import de.datomino.logistic.dto.LogisticTimeWindowDto;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.logistic.type.StopType;
import de.datomino.logistic.util.StreetSideEntity;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class LogisticStopDto<T extends Serializable>
extends AbstractLogisticDto<T> {
    private static final long serialVersionUID = -578977402539870688L;
    private StopType stopType;
    private Date timeOfArrival;
    private Integer durationInSecond;
    private Integer streetMileageMetersFromStart;
    private Integer secondsFromStart;
    private LogisticLocationDto<T> location;
    private StreetSideEntity<T> streetSide;
    private List<LogisticTimeWindowDto> timeWindows;
    private List<LogisticServiceDto> services;
    private Map<LogisticServiceDto, Object> serviceWeightMap;
    private Integer sortOrder;
    private boolean badTimeWindow = false;
    private RouteVehicleType otherRouteVehicleType;
    private RouteType otherRouteType;
    private Double accessDistanceFromPred;

    public LogisticStopDto(T id) {
        super(id);
    }

    public LogisticStopDto(T id, LogisticLocationDto<T> location) {
        super(id);
        this.location = location;
    }

    public Integer getStreetMileageMetersFromStart() {
        return this.streetMileageMetersFromStart == null ? 0 : this.streetMileageMetersFromStart;
    }

    public void setStreetMileageMetersFromStart(Integer streetMileageMetersFromStart) {
        this.streetMileageMetersFromStart = streetMileageMetersFromStart;
    }

    public Integer getSecondsFromStart() {
        return this.secondsFromStart;
    }

    public void setSecondsFromStart(Integer secondsFromStart) {
        this.secondsFromStart = secondsFromStart;
    }

    public Date getTimeOfArrival() {
        return this.timeOfArrival;
    }

    public void setTimeOfArrival(Date timeOfArrival) {
        this.timeOfArrival = timeOfArrival;
    }

    public Integer getDurationInSecond() {
        return this.durationInSecond;
    }

    public void setDurationInSecond(Integer durationInSecond) {
        this.durationInSecond = durationInSecond;
    }

    public LogisticLocationDto<T> getLocation() {
        return this.location;
    }

    public void setLocation(LogisticLocationDto<T> location) {
        this.location = location;
    }

    public StreetSideEntity<T> getStreetSide() {
        return this.streetSide;
    }

    public void setStreetSide(StreetSideEntity<T> streetSide) {
        if (streetSide == null && this.streetSide != null) {
            this.streetSide.getStops().remove(this);
            this.streetSide = null;
        } else if (streetSide != null) {
            this.streetSide = streetSide;
            this.streetSide.getStops().add(this);
        }
    }

    public List<LogisticTimeWindowDto> getTimeWindows() {
        if (this.timeWindows == null) {
            this.timeWindows = new ArrayList<LogisticTimeWindowDto>();
        }
        return this.timeWindows;
    }

    public void setTimeWindows(List<LogisticTimeWindowDto> timeWindows) {
        this.timeWindows = timeWindows;
    }

    public List<LogisticServiceDto> getServices() {
        if (this.services == null) {
            this.services = new ArrayList<LogisticServiceDto>();
        }
        return this.services;
    }

    public void setServices(List<LogisticServiceDto> services) {
        this.services = services;
    }

    public Map<LogisticServiceDto, Object> getServiceWeightMap() {
        if (this.serviceWeightMap == null) {
            this.serviceWeightMap = new HashMap<LogisticServiceDto, Object>();
        }
        return this.serviceWeightMap;
    }

    public void setServiceWeightMap(Map<LogisticServiceDto, Object> serviceWeightMap) {
        this.serviceWeightMap = serviceWeightMap;
    }

    public StopType getStopType() {
        if (this.stopType == null) {
            this.stopType = StopType.NORMAL;
        }
        return this.stopType;
    }

    public void setStopType(StopType stopType) {
        this.stopType = stopType;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean isBadTimeWindow() {
        return this.badTimeWindow;
    }

    public void setBadTimeWindow(boolean badTimeWindow) {
        this.badTimeWindow = badTimeWindow;
    }

    public RouteVehicleType getOtherRouteVehicleType() {
        return this.otherRouteVehicleType;
    }

    public void setOtherRouteVehicleType(RouteVehicleType otherRouteVehicleType) {
        this.otherRouteVehicleType = otherRouteVehicleType;
    }

    public RouteType getOtherRouteType() {
        return this.otherRouteType;
    }

    public void setOtherRouteType(RouteType otherRouteType) {
        this.otherRouteType = otherRouteType;
    }

    public Double getAccessDistanceFromPred() {
        return this.accessDistanceFromPred == null ? 0.0 : this.accessDistanceFromPred;
    }

    public void setAccessDistanceFromPred(Double accessDistanceFromPred) {
        this.accessDistanceFromPred = accessDistanceFromPred;
    }

    public String toString() {
        if (this.location == null) {
            return "" + this.getId();
        }
        ToStringBuilder toStringBuilder = this.location.createToStringBuilder();
        if (this.timeWindows != null) {
            int counter = 0;
            for (LogisticTimeWindowDto logisticServiceTimeWindowDto : this.timeWindows) {
                toStringBuilder.append("Window " + counter, logisticServiceTimeWindowDto);
                ++counter;
            }
        }
        return this.getId() + "-" + toStringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof LogisticStopDto) {
            LogisticStopDto logisticStopDto = (LogisticStopDto)o;
            if (new EqualsBuilder().append(this.getId(), logisticStopDto.getId()).isEquals() && this.sameStopType(logisticStopDto)) {
                return true;
            }
        }
        return false;
    }

    private boolean sameStopType(LogisticStopDto<T> logisticStopDto) {
        if (this.stopType == null && logisticStopDto.getStopType() == null) {
            return true;
        }
        return this.stopType == logisticStopDto.getStopType();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getId()).toHashCode();
    }

    public LogisticStopDto<T> clone(T id) {
        LogisticStopDto<T> clone = new LogisticStopDto<T>(id);
        for (Field field : LogisticStopDto.class.getDeclaredFields()) {
            try {
                if (Modifier.isFinal(field.getModifiers())) continue;
                field.set(clone, field.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        clone.location = this.location.clone(id);
        return clone;
    }
}

