/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic.dto;

import de.datomino.logistic.dto.AbstractLogisticDto;
import de.datomino.logistic.searchevaluation.SearchEvaluationAddressWrapper;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ktde.util.StringUtil;

public class LogisticLocationDto<T extends Serializable>
extends AbstractLogisticDto<T>
implements SearchEvaluationAddressWrapper {
    private static final long serialVersionUID = -6922040243007952853L;
    private ImmutablePointDto geom;
    private ImmutablePointDto accesGeom;
    private ImmutablePointDto otherAccessGeom;
    private Country country;
    private String postcode;
    private String city;
    private String district;
    private String street;
    private String housenumber;
    private String extension;
    private ImmutableLineStringDto lineString;
    private String tempId;
    private Long routeSegmentId;
    private Long otherRouteSegmentId;
    private boolean ignoreEmpty = false;
    private Double parcelLocation;

    public LogisticLocationDto(T id) {
        super(id);
    }

    public LogisticLocationDto(T id, ImmutablePointDto geom, ImmutablePointDto accessGeom, Country country, String postcode, String city, String district, String street, Integer housenumber, String extension) {
        super(id);
        this.geom = geom;
        this.accesGeom = accessGeom;
        this.country = country;
        this.postcode = postcode;
        this.city = city;
        this.district = district;
        this.street = street;
        this.housenumber = housenumber == null ? "" : housenumber.toString();
        this.extension = extension;
    }

    public LogisticLocationDto(T id, ImmutablePointDto geom, ImmutablePointDto accessGeom, Country country, String postcode, String city, String district, String street, String housenumber, String extension) {
        super(id);
        this.geom = geom;
        this.accesGeom = accessGeom;
        this.country = country;
        this.postcode = postcode;
        this.city = city;
        this.district = district;
        this.street = street;
        this.housenumber = housenumber;
        this.extension = extension;
    }

    public LogisticLocationDto(LogisticLocationDto<T> logisticLocationDto) {
        this(logisticLocationDto.getId(), logisticLocationDto.getGeom(), logisticLocationDto.getAccessGeom(), logisticLocationDto.getCountry() == null ? null : logisticLocationDto.getCountry(), logisticLocationDto.getPostcode(), logisticLocationDto.getCity(), logisticLocationDto.getDistrict(), logisticLocationDto.getStreet(), logisticLocationDto.getHousenumber(), logisticLocationDto.getExtension());
    }

    public ImmutablePointDto getGeom() {
        return this.geom;
    }

    public void setGeom(ImmutablePointDto geom) {
        this.geom = geom;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = CountryUtil.searchCountryFuzzy(country);
    }

    @Override
    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    @Override
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Override
    public String getHousenumber() {
        return this.housenumber;
    }

    public void setHousenumber(String housenumber) {
        this.housenumber = housenumber;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public ImmutablePointDto getAccessGeom() {
        return this.accesGeom;
    }

    public void setAccesGeom(ImmutablePointDto accesGeom) {
        this.accesGeom = accesGeom;
    }

    public ImmutablePointDto getOtherAccessGeom() {
        return this.otherAccessGeom;
    }

    public void setOtherAccessGeom(ImmutablePointDto otherAccessGeom) {
        this.otherAccessGeom = otherAccessGeom;
    }

    public ImmutableLineStringDto getLineString() {
        if (this.lineString == null) {
            this.lineString = new ImmutableLineStringDto(null);
        }
        return this.lineString;
    }

    public void setLineString(ImmutableLineStringDto lineString) {
        this.lineString = lineString;
    }

    public Double getParcelLocation() {
        return this.parcelLocation;
    }

    public void setParcelLocation(Double parcelLocation) {
        this.parcelLocation = parcelLocation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogisticLocationDto) {
            return new EqualsBuilder().append(this.getId(), ((LogisticLocationDto)obj).getId()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getId()).toHashCode();
    }

    protected ToStringBuilder createToStringBuilder() {
        return new ToStringBuilder(this).append("id", this.getId()).append("city", this.getCity()).append("coordinate", this.getGeom()).append("country", this.getCountry()).append("district", this.getDistrict()).append("extension", this.getExtension()).append("housenumber", this.getHousenumber()).append("postcode", this.getPostcode()).append("street", this.getStreet());
    }

    public String toString() {
        return this.createToStringBuilder().toString();
    }

    public String getTempId() {
        return this.tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public boolean isSameAddress(LogisticLocationDto<T> other) {
        return (this.getCountry() == null && other.getCountry() == null || this.getCountry() != null && other.getCountry() != null && this.getCountry().equals(other.getCountry())) && StringUtil.getNotNull(this.getCity()).equals(StringUtil.getNotNull(other.getCity())) && StringUtil.getNotNull(this.getPostcode()).equals(StringUtil.getNotNull(other.getPostcode())) && StringUtil.getNotNull(this.getStreet()).equals(StringUtil.getNotNull(other.getStreet())) && StringUtil.getNotNull(this.getHousenumber()).equals(StringUtil.getNotNull(other.getHousenumber())) && StringUtil.getNotNull(this.getExtension()).equals(StringUtil.getNotNull(other.getExtension()));
    }

    public void setRouteSegmentId(Long routeSegmentId) {
        this.routeSegmentId = routeSegmentId;
    }

    public Long getRouteSegmentId() {
        return this.routeSegmentId;
    }

    public Long getOtherRouteSegmentId() {
        return this.otherRouteSegmentId;
    }

    public void setOtherRouteSegmentId(Long otherRouteSegmentId) {
        this.otherRouteSegmentId = otherRouteSegmentId;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public LogisticLocationDto<T> clone(T id) {
        LogisticLocationDto<T> clone = new LogisticLocationDto<T>(this);
        clone.setId(id);
        clone.geom = this.geom;
        clone.accesGeom = this.accesGeom;
        clone.lineString = this.lineString;
        clone.tempId = this.tempId;
        clone.routeSegmentId = this.routeSegmentId;
        clone.ignoreEmpty = this.ignoreEmpty;
        clone.parcelLocation = this.parcelLocation;
        return clone;
    }
}

