/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.logistic;

import de.datomino.logistic.LocationQualifier;
import de.datomino.logistic.LogisticException;
import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.searchevaluation.SearchEvaluation;
import de.datomino.logistic.searchevaluation.SearchEvaluationWeights;
import de.datomino.logistic.type.RangeType;
import de.datomino.logistic.type.SearchType;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.search.SearchResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KatasterServiceInterface
implements LocationQualifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(KatasterServiceInterface.class);
    private String url;
    private String account;
    private String password;
    private Integer paramCount = 0;

    @Override
    public LogisticQualifiedLocationDto validateLocation(LogisticLocationDto<?> logisticLocationDto) throws LogisticException {
        List<LogisticQualifiedLocationDto> list = this.findLocations(logisticLocationDto, null, true, "");
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<LogisticQualifiedLocationDto> findLocations(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, boolean exact, String userLoginName) throws LogisticException {
        try {
            List<SearchResult> resultList = this.request(logisticLocationDto, exact, userLoginName);
            if (!resultList.isEmpty()) {
                List<? extends LogisticQualifiedLocationDto> logisticQualifiedLocationDtos = this.createLogisticQualifiedLocationDtos(maxCount, (Serializable)logisticLocationDto.getId(), resultList);
                SearchEvaluationWeights searchEvaluationWeights = new SearchEvaluationWeights();
                searchEvaluationWeights.setDistrictWeight(0.0);
                ArrayList<LogisticQualifiedLocationDto> result = new ArrayList<LogisticQualifiedLocationDto>(logisticQualifiedLocationDtos.size());
                for (LogisticQualifiedLocationDto logisticQualifiedLocationDto : logisticQualifiedLocationDtos) {
                    double matching = SearchEvaluation.matching(logisticQualifiedLocationDto, logisticLocationDto, 100, searchEvaluationWeights);
                    logisticQualifiedLocationDto.setMatching(matching);
                    result.add(logisticQualifiedLocationDto);
                }
                return result;
            }
            String message = "No result returned with response";
            LOGGER.error(message);
            throw new LogisticException(message);
        }
        catch (HttpException e) {
            LOGGER.warn(e.getMessage(), e);
            throw new LogisticException(e);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), e);
            throw new LogisticException(e);
        }
    }

    private List<SearchResult> request(LogisticLocationDto<?> logisticLocationDto, boolean exact, String userLoginName) throws HttpException, IOException, LogisticException {
        this.paramCount = 0;
        StringBuilder requestUrl = new StringBuilder(this.url);
        this.getParamEncodedValueAndAppend(requestUrl, "account=", this.account);
        this.getParamEncodedValueAndAppend(requestUrl, "password=", this.password);
        this.getParamEncodedValueAndAppend(requestUrl, "country=", logisticLocationDto.getCountry() != null ? logisticLocationDto.getCountry().name() : null);
        this.getParamEncodedValueAndAppend(requestUrl, "postcode=", logisticLocationDto.getPostcode());
        this.getParamEncodedValueAndAppend(requestUrl, "city=", logisticLocationDto.getCity());
        this.getParamEncodedValueAndAppend(requestUrl, "district=", logisticLocationDto.getDistrict());
        this.getParamEncodedValueAndAppend(requestUrl, "street=", logisticLocationDto.getStreet());
        this.getParamEncodedValueAndAppend(requestUrl, "houseNumber=", logisticLocationDto.getHousenumber());
        this.getParamEncodedValueAndAppend(requestUrl, "houseNumberExtension=", logisticLocationDto.getExtension());
        this.getParamEncodedValueAndAppend(requestUrl, "userName=", userLoginName);
        if (exact) {
            this.getParamEncodedValueAndAppend(requestUrl, "searchType=", SearchType.ALIAS_EXACT.name());
        } else {
            this.getParamEncodedValueAndAppend(requestUrl, "searchType=", SearchType.FUZZY.name());
        }
        ArrayList<SearchResult> resultList = new ArrayList<SearchResult>();
        String request = requestUrl.toString();
        LOGGER.info("Requesting: " + request);
        HttpPost httppost = new HttpPost(request);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httppost);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            builder = new StringBuilder(builder.substring(builder.indexOf("["), builder.indexOf("]") + 1));
            JSONTokener tokener = new JSONTokener(builder.toString());
            JSONArray array = new JSONArray(tokener);
            for (int t = 0; t < array.length(); ++t) {
                JSONObject jObject = array.getJSONObject(t);
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                SearchResult resultObject = objectMapper.readValue(jObject.toString(), SearchResult.class);
                resultList.add(resultObject);
            }
        }
        catch (IllegalStateException e1) {
            LOGGER.error(e1.getMessage());
        }
        catch (JSONException e2) {
            LOGGER.error(e2.getMessage());
        }
        return resultList;
    }

    private void getParamEncodedValueAndAppend(StringBuilder requestUrl, String paramKeyString, Object parameterValue) {
        String appendStr = "";
        if (parameterValue != null && !parameterValue.equals("")) {
            if (this.paramCount == 0) {
                appendStr = "?";
            } else if (this.paramCount > 0) {
                appendStr = "&";
            }
            try {
                String encodeStr = URLEncoder.encode(parameterValue.toString(), "UTF-8");
                requestUrl.append(appendStr).append(paramKeyString).append(encodeStr);
                this.paramCount = this.paramCount + 1;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<LogisticQualifiedLocationDto> findRange(LogisticLocationDto<?> logisticLocationDto, Tupel<Tupel<Integer, String>, Tupel<Integer, String>> range, RangeType rangeType, Integer maxCount) throws LogisticException {
        return null;
    }

    private List<? extends LogisticQualifiedLocationDto> createLogisticQualifiedLocationDtos(Integer maxCount, Serializable id, List<SearchResult> resultList) {
        int count = 0;
        ArrayList<LogisticQualifiedLocationDto> returnResultList = new ArrayList<LogisticQualifiedLocationDto>();
        for (SearchResult result : resultList) {
            if (maxCount != null && maxCount <= count) break;
            LogisticQualifiedLocationDto logisticQualifiedLocationDto = new LogisticQualifiedLocationDto();
            Long nId = 1L;
            if (id instanceof Long) {
                nId = (Long)id;
            }
            logisticQualifiedLocationDto.setId(nId);
            Map<String, Object> infoMap = result.toMap();
            logisticQualifiedLocationDto.setCountry(infoMap.get("country") != null ? infoMap.get("country").toString() : "");
            logisticQualifiedLocationDto.setPostcode(infoMap.get("postcode") != null ? infoMap.get("postcode").toString() : "");
            logisticQualifiedLocationDto.setCity(infoMap.get("city") != null ? infoMap.get("city").toString() : "");
            logisticQualifiedLocationDto.setDistrict(infoMap.get("district") != null ? infoMap.get("district").toString() : "");
            logisticQualifiedLocationDto.setStreet(infoMap.get("street") != null ? infoMap.get("street").toString() : "");
            logisticQualifiedLocationDto.setHousenumber(infoMap.get("houseNumber") != null ? infoMap.get("houseNumber").toString() : "");
            logisticQualifiedLocationDto.setExtension(infoMap.get("houseNumberExtension") != null ? infoMap.get("houseNumberExtension").toString() : "");
            logisticQualifiedLocationDto.setMatching(infoMap.get("matching") != null ? Double.valueOf((String)infoMap.get("matching")) : null);
            logisticQualifiedLocationDto.setAccesGeom(null);
            logisticQualifiedLocationDto.setRouteSegmentId(null);
            logisticQualifiedLocationDto.setTempId(null);
            logisticQualifiedLocationDto.setLineString(null);
            logisticQualifiedLocationDto.setIgnoreEmpty(false);
            if (infoMap.get("lon") != null && infoMap.get("lat") != null) {
                double x = Double.valueOf((String)infoMap.get("lon"));
                double y = Double.valueOf((String)infoMap.get("lat"));
                logisticQualifiedLocationDto.setGeom(ImmutablePointDto.create(ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(x, y))));
            } else {
                logisticQualifiedLocationDto.setGeom(null);
            }
            returnResultList.add(logisticQualifiedLocationDto);
            ++count;
        }
        if (maxCount != null) {
            returnResultList = new ArrayList(returnResultList.subList(0, Math.min(maxCount, returnResultList.size())));
        }
        return returnResultList;
    }

    @Override
    public boolean isIdentifyable() {
        return false;
    }

    @Override
    public boolean isRangeable() {
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Long getGap() {
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getParamCount() {
        return this.paramCount;
    }

    public void setParamCount(Integer paramCount) {
        this.paramCount = paramCount;
    }

    @Override
    public List<LogisticQualifiedLocationDto> findLocationsWithWildcard(LogisticLocationDto<?> logisticLocationDto, Integer maxCount, String userLoginName) throws LogisticException {
        throw new RuntimeException("Method not implmeneted");
    }

    @Override
    public boolean supportsWildcard() {
        return false;
    }
}

