/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.log;

import java.io.File;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="ServletContextBaseFileAppender", category="Core", elementType="appender")
public class ServletContextBasedFileAppender
extends AbstractAppender {
    private static String loggingRootDir;
    private static String completeFilename;
    private static String file;
    private static FileAppender fileAppender;

    public ServletContextBasedFileAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    @PluginFactory
    public static ServletContextBasedFileAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new ServletContextBasedFileAppender(name, null, layout, false, new Property[0]);
    }

    @Override
    public synchronized void append(LogEvent event) {
        if (completeFilename != null) {
            boolean exists = new File(completeFilename).exists();
            if (!exists && fileAppender != null) {
                fileAppender.stop();
                fileAppender = null;
            }
            if (fileAppender == null) {
                ConfigurationBuilder<BuiltConfiguration> builder = ConfigurationBuilderFactory.newConfigurationBuilder();
                AppenderComponentBuilder file = builder.newAppender("log", "File");
                file.addAttribute("fileName", completeFilename);
                LayoutComponentBuilder standard = builder.newLayout("PatternLayout");
                standard.addAttribute("pattern", "%5p %d{ISO8601} [%t][%x] %c - %m%n");
                file.add(standard);
                builder.add(file);
                Configuration conf = (Configuration)builder.build();
                fileAppender = (FileAppender)conf.getAppender("log");
                fileAppender.start();
            }
            fileAppender.append(event);
        }
    }

    public static void setLoggingRootDir(String loggingRootDir) {
        ServletContextBasedFileAppender.loggingRootDir = loggingRootDir;
        ServletContextBasedFileAppender.setCompletFile();
    }

    public static void setServletContextBasedFile(String file) {
        ServletContextBasedFileAppender.file = file;
        ServletContextBasedFileAppender.setCompletFile();
    }

    private static void setCompletFile() {
        completeFilename = loggingRootDir != null && file != null ? loggingRootDir + "/" + file : null;
    }
}

