/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.debug;

import de.datomino.debug.AbstractIndexedDebugWatch;
import java.lang.reflect.Field;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ReflectionDebugWatch
extends AbstractIndexedDebugWatch {
    private static final long serialVersionUID = 9189846645650713758L;
    private Field[] members;
    private Object towatch;

    public ReflectionDebugWatch(String name, Object towatch, String ... members) {
        super("Object Debug " + name, towatch, members);
    }

    @Override
    protected void createComponents(Object constructorArg, String ... labels) {
        this.towatch = constructorArg;
        this.members = new Field[this.values.length];
        int i = 0;
        Class<?> clazz = this.towatch.getClass();
        for (String string : labels) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                this.members[i] = field;
                this.values[i] = new JTextField();
            }
            catch (Exception e) {
                this.members[i] = null;
                this.values[i] = new JLabel("not accessible");
            }
            ++i;
        }
    }

    @Override
    protected String getValue(int index) {
        Field field = this.members[index];
        String value = "";
        if (field != null) {
            try {
                value = field.get(this.towatch).toString();
            }
            catch (Exception e) {
                value = e.getClass() + ":" + e.getMessage();
            }
        }
        return value;
    }
}

