/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.NumHelper;
import com.vividsolutions.jts.geom.Point;

public class GHPoint {
    public double lat = Double.NaN;
    public double lon = Double.NaN;

    public GHPoint() {
    }

    public GHPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public static GHPoint create(Point point) {
        return new GHPoint(point.getY(), point.getX());
    }

    public static GHPoint parse(String str) {
        return GHPoint.parse(str, false);
    }

    public static GHPoint parseLonLat(String str) {
        return GHPoint.parse(str, true);
    }

    private static GHPoint parse(String str, boolean lonLatOrder) {
        String[] fromStrs = str.split(",");
        if (fromStrs.length == 2) {
            try {
                double fromLat = Double.parseDouble(fromStrs[0]);
                double fromLon = Double.parseDouble(fromStrs[1]);
                if (lonLatOrder) {
                    return new GHPoint(fromLon, fromLat);
                }
                return new GHPoint(fromLat, fromLon);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public boolean isValid() {
        return !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        hash = 83 * hash + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        GHPoint other = (GHPoint)obj;
        return NumHelper.equalsEps(this.lat, other.lat) && NumHelper.equalsEps(this.lon, other.lon);
    }

    public String toString() {
        return String.valueOf(this.lat) + "," + this.lon;
    }

    public Double[] toGeoJson() {
        return new Double[]{this.lon, this.lat};
    }
}

