/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.fasterxml.jackson.annotation.JsonValue;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.GPXEntry;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.Translation;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class InstructionList
extends AbstractList<Instruction> {
    private final List<Instruction> instructions;
    private final Translation tr;

    static String simpleXMLEscape(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("[\\<\\>]", "_");
    }

    public InstructionList(Translation tr) {
        this(10, tr);
    }

    public InstructionList(int cap, Translation tr) {
        this.instructions = new ArrayList<Instruction>(cap);
        this.tr = tr;
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public Instruction get(int index) {
        return this.instructions.get(index);
    }

    @Override
    public Instruction set(int index, Instruction element) {
        return this.instructions.set(index, element);
    }

    @Override
    public void add(int index, Instruction element) {
        this.instructions.add(index, element);
    }

    @Override
    public Instruction remove(int index) {
        return this.instructions.remove(index);
    }

    public void replaceLast(Instruction instr) {
        if (this.instructions.isEmpty()) {
            throw new IllegalStateException("Cannot replace last instruction as list is empty");
        }
        this.instructions.set(this.instructions.size() - 1, instr);
    }

    @JsonValue
    public List<Map<String, Object>> createJson() {
        ArrayList<Map<String, Object>> instrList = new ArrayList<Map<String, Object>>(this.instructions.size());
        int pointsIndex = 0;
        int counter = 0;
        for (Instruction instruction : this.instructions) {
            HashMap<String, Object> instrJson = new HashMap<String, Object>();
            instrList.add(instrJson);
            InstructionAnnotation ia = instruction.getAnnotation();
            String text = instruction.getTurnDescription(this.tr);
            if (Helper.isEmpty(text)) {
                text = ia.getMessage();
            }
            instrJson.put("text", Helper.firstBig(text));
            if (!ia.isEmpty()) {
                instrJson.put("annotation_text", ia.getMessage());
                instrJson.put("annotation_importance", ia.getImportance());
            }
            instrJson.put("street_name", instruction.getName());
            instrJson.put("time", instruction.getTime());
            instrJson.put("distance", Helper.round(instruction.getDistance(), 3));
            instrJson.put("sign", instruction.getSign());
            instrJson.putAll(instruction.getExtraInfoJSON());
            int tmpIndex = pointsIndex + instruction.getLength();
            instrJson.put("interval", Arrays.asList(pointsIndex, tmpIndex));
            pointsIndex = tmpIndex;
            ++counter;
        }
        return instrList;
    }

    public List<GPXEntry> createGPXList() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GPXEntry> gpxList = new ArrayList<GPXEntry>();
        long timeOffset = 0L;
        int i = 0;
        while (i < this.size() - 1) {
            Instruction prevInstr = i > 0 ? this.get(i - 1) : null;
            boolean instrIsFirst = prevInstr == null;
            Instruction nextInstr = this.get(i + 1);
            nextInstr.checkOne();
            timeOffset = this.get(i).fillGPXList(gpxList, timeOffset, prevInstr, nextInstr, instrIsFirst);
            ++i;
        }
        Instruction lastI = this.get(this.size() - 1);
        if (lastI.points.size() != 1) {
            throw new IllegalStateException("Last instruction must have exactly one point but was " + lastI.points.size());
        }
        double lastLat = lastI.getFirstLat();
        double lastLon = lastI.getFirstLon();
        double lastEle = lastI.getPoints().is3D() ? lastI.getFirstEle() : Double.NaN;
        gpxList.add(new GPXEntry(lastLat, lastLon, lastEle, timeOffset));
        return gpxList;
    }

    public String createGPX() {
        return this.createGPX("GraphHopper", new Date().getTime());
    }

    public String createGPX(String trackName, long startTimeMillis) {
        boolean includeElevation = this.size() > 0 && this.get(0).getPoints().is3D();
        return this.createGPX(trackName, startTimeMillis, includeElevation, true, true, true);
    }

    private void createWayPointBlock(StringBuilder output, Instruction instruction, DecimalFormat decimalFormat) {
        output.append("\n<wpt ");
        output.append("lat=\"").append(decimalFormat.format(instruction.getFirstLat()));
        output.append("\" lon=\"").append(decimalFormat.format(instruction.getFirstLon())).append("\">");
        String name = instruction.getName().isEmpty() ? instruction.getTurnDescription(this.tr) : instruction.getName();
        output.append(" <name>").append(InstructionList.simpleXMLEscape(name)).append("</name>");
        output.append("</wpt>");
    }

    public String createGPX(String trackName, long startTimeMillis, boolean includeElevation, boolean withRoute, boolean withTrack, boolean withWayPoints) {
        DateFormat formatter = Helper.createFormatter();
        DecimalFormat decimalFormat = new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ROOT));
        decimalFormat.setMinimumFractionDigits(1);
        decimalFormat.setMaximumFractionDigits(6);
        decimalFormat.setMinimumIntegerDigits(1);
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><gpx xmlns=\"http://www.topografix.com/GPX/1/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" creator=\"Graphhopper version " + Constants.VERSION + "\" version=\"1.1\"" + " xmlns:gh=\"https://graphhopper.com/public/schema/gpx/1.1\">" + "\n<metadata>" + "<copyright author=\"OpenStreetMap contributors\"/>" + "<link href=\"http://graphhopper.com\">" + "<text>GraphHopper GPX</text>" + "</link>" + "<time>" + formatter.format(startTimeMillis) + "</time>" + "</metadata>";
        StringBuilder gpxOutput = new StringBuilder(header);
        if (!this.isEmpty()) {
            if (withWayPoints) {
                this.createWayPointBlock(gpxOutput, this.instructions.get(0), decimalFormat);
                for (Instruction currInstr : this.instructions) {
                    if (currInstr.getSign() != 5 && currInstr.getSign() != 4) continue;
                    this.createWayPointBlock(gpxOutput, currInstr, decimalFormat);
                }
            }
            if (withRoute) {
                gpxOutput.append("\n<rte>");
                Instruction nextInstr = null;
                for (Instruction currInstr : this.instructions) {
                    if (nextInstr != null) {
                        this.createRteptBlock(gpxOutput, nextInstr, currInstr, decimalFormat);
                    }
                    nextInstr = currInstr;
                }
                this.createRteptBlock(gpxOutput, nextInstr, null, decimalFormat);
                gpxOutput.append("\n</rte>");
            }
        }
        if (withTrack) {
            gpxOutput.append("\n<trk><name>").append(trackName).append("</name>");
            gpxOutput.append("<trkseg>");
            for (GPXEntry entry : this.createGPXList()) {
                gpxOutput.append("\n<trkpt lat=\"").append(decimalFormat.format(entry.getLat()));
                gpxOutput.append("\" lon=\"").append(decimalFormat.format(entry.getLon())).append("\">");
                if (includeElevation) {
                    gpxOutput.append("<ele>").append(Helper.round2(entry.getEle())).append("</ele>");
                }
                gpxOutput.append("<time>").append(formatter.format(startTimeMillis + entry.getTime())).append("</time>");
                gpxOutput.append("</trkpt>");
            }
            gpxOutput.append("\n</trkseg>");
            gpxOutput.append("\n</trk>");
        }
        gpxOutput.append("\n</gpx>");
        return gpxOutput.toString();
    }

    public void createRteptBlock(StringBuilder output, Instruction instruction, Instruction nextI, DecimalFormat decimalFormat) {
        double azimuth;
        output.append("\n<rtept lat=\"").append(decimalFormat.format(instruction.getFirstLat())).append("\" lon=\"").append(decimalFormat.format(instruction.getFirstLon())).append("\">");
        if (!instruction.getName().isEmpty()) {
            output.append("<desc>").append(InstructionList.simpleXMLEscape(instruction.getTurnDescription(this.tr))).append("</desc>");
        }
        output.append("<extensions>");
        output.append("<gh:distance>").append(Helper.round(instruction.getDistance(), 1)).append("</gh:distance>");
        output.append("<gh:time>").append(instruction.getTime()).append("</gh:time>");
        String direction = instruction.calcDirection(nextI);
        if (!direction.isEmpty()) {
            output.append("<gh:direction>").append(direction).append("</gh:direction>");
        }
        if (!Double.isNaN(azimuth = instruction.calcAzimuth(nextI))) {
            output.append("<gh:azimuth>").append(Helper.round2(azimuth)).append("</gh:azimuth>");
        }
        if (instruction instanceof RoundaboutInstruction) {
            RoundaboutInstruction ri = (RoundaboutInstruction)instruction;
            output.append("<gh:exit_number>").append(ri.getExitNumber()).append("</gh:exit_number>");
        }
        output.append("<gh:sign>").append(instruction.getSign()).append("</gh:sign>");
        output.append("</extensions>");
        output.append("</rtept>");
    }

    List<List<Double>> createStartPoints() {
        ArrayList<List<Double>> res = new ArrayList<List<Double>>(this.instructions.size());
        for (Instruction instruction : this.instructions) {
            res.add(Arrays.asList(instruction.getFirstLat(), instruction.getFirstLon()));
        }
        return res;
    }

    public Instruction find(double lat, double lon, double maxDistance) {
        if (this.size() == 0) {
            return null;
        }
        PointList points = this.get(0).getPoints();
        double prevLat = points.getLatitude(0);
        double prevLon = points.getLongitude(0);
        DistanceCalc distCalc = Helper.DIST_EARTH;
        double foundMinDistance = distCalc.calcNormalizedDist(lat, lon, prevLat, prevLon);
        int foundInstruction = 0;
        if (this.size() > 1) {
            int instructionIndex = 0;
            while (instructionIndex < this.size()) {
                points = this.get(instructionIndex).getPoints();
                int pointIndex = 0;
                while (pointIndex < points.size()) {
                    double currLat = points.getLatitude(pointIndex);
                    double currLon = points.getLongitude(pointIndex);
                    if (instructionIndex != 0 || pointIndex != 0) {
                        double distance;
                        int index = instructionIndex;
                        if (distCalc.validEdgeDistance(lat, lon, currLat, currLon, prevLat, prevLon)) {
                            distance = distCalc.calcNormalizedEdgeDistance(lat, lon, currLat, currLon, prevLat, prevLon);
                            if (pointIndex > 0) {
                                ++index;
                            }
                        } else {
                            distance = distCalc.calcNormalizedDist(lat, lon, currLat, currLon);
                            if (pointIndex > 0) {
                                ++index;
                            }
                        }
                        if (distance < foundMinDistance) {
                            foundMinDistance = distance;
                            foundInstruction = index;
                        }
                    }
                    prevLat = currLat;
                    prevLon = currLon;
                    ++pointIndex;
                }
                ++instructionIndex;
            }
        }
        if (distCalc.calcDenormalizedDist(foundMinDistance) > maxDistance) {
            return null;
        }
        if (foundInstruction == this.size()) {
            --foundInstruction;
        }
        return this.get(foundInstruction);
    }
}

