/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalc3D;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    public static final DistanceCalc DIST_EARTH = new DistanceCalcEarth();
    public static final DistanceCalc3D DIST_3D = new DistanceCalc3D();
    public static final DistancePlaneProjection DIST_PLANE = new DistancePlaneProjection();
    public static final AngleCalc ANGLE_CALC = new AngleCalc();
    public static final Charset UTF_CS = Charset.forName("UTF-8");
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final long MB = 0x100000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Helper.class);
    private static final float DEGREE_FACTOR = 5368709.0f;
    private static final float ELE_FACTOR = 1000.0f;

    private Helper() {
    }

    public static ArrayList<Integer> intListToArrayList(IntIndexedContainer from) {
        int len = from.size();
        ArrayList<Integer> list = new ArrayList<Integer>(len);
        int i = 0;
        while (i < len) {
            list.add(from.get(i));
            ++i;
        }
        return list;
    }

    public static Locale getLocale(String param) {
        int index;
        int pointIndex = param.indexOf(46);
        if (pointIndex > 0) {
            param = param.substring(0, pointIndex);
        }
        if ((index = (param = param.replace("-", "_")).indexOf("_")) < 0) {
            return new Locale(param);
        }
        return new Locale(param.substring(0, index), param.substring(index + 1));
    }

    public static String toLowerCase(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    static String packageToPath(Package pkg) {
        return pkg.getName().replaceAll("\\.", File.separator);
    }

    public static int countBitValue(int maxTurnCosts) {
        if (maxTurnCosts < 0) {
            throw new IllegalArgumentException("maxTurnCosts cannot be negative " + maxTurnCosts);
        }
        int counter = 0;
        while (maxTurnCosts > 0) {
            maxTurnCosts >>= 1;
            ++counter;
        }
        return counter++;
    }

    public static void loadProperties(Map<String, String> map, Reader tmpReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(tmpReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//") || line.startsWith("#") || Helper.isEmpty(line)) continue;
                int index = line.indexOf("=");
                if (index < 0) {
                    LOGGER.warn("Skipping configuration at line:" + line);
                    continue;
                }
                String field = line.substring(0, index);
                String value = line.substring(index + 1);
                map.put(field.trim(), value.trim());
            }
        }
    }

    public static void saveProperties(Map<String, String> map, Writer tmpWriter) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(tmpWriter);){
            for (Map.Entry<String, String> e : map.entrySet()) {
                writer.append(e.getKey());
                writer.append('=');
                writer.append(e.getValue());
                writer.append('\n');
            }
        }
    }

    public static List<String> readFile(String file) throws IOException {
        return Helper.readFile(new InputStreamReader((InputStream)new FileInputStream(file), UTF_CS));
    }

    public static List<String> readFile(Reader simpleReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(simpleReader);){
            String line;
            ArrayList<String> res = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                res.add(line);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
    }

    public static String isToString(InputStream inputStream) throws IOException {
        int size = 8192;
        String encoding = "UTF-8";
        try (BufferedInputStream in = new BufferedInputStream(inputStream, size);){
            int numRead;
            byte[] buffer = new byte[size];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((numRead = ((InputStream)in).read(buffer)) != -1) {
                output.write(buffer, 0, numRead);
            }
            String string = output.toString(encoding);
            return string;
        }
    }

    public static int idealIntArraySize(int need) {
        return Helper.idealByteArraySize(need * 4) / 4;
    }

    public static int idealByteArraySize(int need) {
        int i = 4;
        while (i < 32) {
            if (need <= (1 << i) - 12) {
                return (1 << i) - 12;
            }
            ++i;
        }
        return need;
    }

    public static boolean removeDir(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Helper.removeDir(f);
                ++n2;
            }
        }
        return file.delete();
    }

    public static long getTotalMB() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static long getUsedMB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    public static String getMemInfo() {
        return "totalMB:" + Helper.getTotalMB() + ", usedMB:" + Helper.getUsedMB();
    }

    public static int getSizeOfObjectRef(int factor) {
        return factor * 12;
    }

    public static int getSizeOfLongArray(int length, int factor) {
        return factor * 16 + 8 * length;
    }

    public static int getSizeOfObjectArray(int length, int factor) {
        return factor * 16 + 4 * length;
    }

    public static void close(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Couldn't close resource", ex);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isFileMapped(ByteBuffer bb) {
        if (bb instanceof MappedByteBuffer) {
            try {
                ((MappedByteBuffer)bb).isLoaded();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int calcIndexSize(BBox graphBounds) {
        if (!graphBounds.isValid()) {
            throw new IllegalArgumentException("Bounding box is not valid to calculate index size: " + graphBounds);
        }
        double dist = DIST_EARTH.calcDist(graphBounds.maxLat, graphBounds.minLon, graphBounds.minLat, graphBounds.maxLon);
        dist = Math.min(dist / 1000.0, 50000.0);
        return Math.max(2000, (int)(dist * dist));
    }

    public static String pruneFileEnd(String file) {
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return file;
        }
        return file.substring(0, index);
    }

    public static List<Double> createDoubleList(double[] values) {
        ArrayList<Double> list = new ArrayList<Double>();
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            list.add(v);
            ++n2;
        }
        return list;
    }

    public static IntArrayList createTList(int ... list) {
        return IntArrayList.from(list);
    }

    public static PointList createPointList(double ... list) {
        if (list.length % 2 != 0) {
            throw new IllegalArgumentException("list should consist of lat,lon pairs!");
        }
        int max = list.length / 2;
        PointList res = new PointList(max, false);
        int i = 0;
        while (i < max) {
            res.add(list[2 * i], list[2 * i + 1], Double.NaN);
            ++i;
        }
        return res;
    }

    public static PointList createPointList3D(double ... list) {
        if (list.length % 3 != 0) {
            throw new IllegalArgumentException("list should consist of lat,lon,ele tuples!");
        }
        int max = list.length / 3;
        PointList res = new PointList(max, true);
        int i = 0;
        while (i < max) {
            res.add(list[3 * i], list[3 * i + 1], list[3 * i + 2]);
            ++i;
        }
        return res;
    }

    public static final int degreeToInt(double deg) {
        if (deg >= Double.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (deg <= -1.7976931348623157E308) {
            return -2147483647;
        }
        return (int)(deg * 5368709.0);
    }

    public static final double intToDegree(int storedInt) {
        if (storedInt == Integer.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        if (storedInt == -2147483647) {
            return -1.7976931348623157E308;
        }
        return (double)storedInt / 5368709.0;
    }

    public static final int eleToInt(double ele) {
        if (ele >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)(ele * 1000.0);
    }

    public static final double intToEle(int integEle) {
        if (integEle == Integer.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return (float)integEle / 1000.0f;
    }

    public static void cleanMappedByteBuffer(final ByteBuffer buffer) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (Constants.JRE_IS_MINIMUM_JAVA9) {
                        Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                        Field f = unsafeClass.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        Object theUnsafe = f.get(null);
                        Method method = unsafeClass.getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                        try {
                            method.invoke(theUnsafe, buffer);
                            return null;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                    if (buffer.getClass().getSimpleName().equals("MappedByteBufferAdapter")) {
                        if (!Constants.ANDROID) {
                            throw new RuntimeException("MappedByteBufferAdapter only supported for Android at the moment");
                        }
                        Class<?> directByteBufferClass = Class.forName("java.nio.MappedByteBufferAdapter");
                        Helper.callBufferFree(buffer, directByteBufferClass);
                    } else {
                        Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
                        try {
                            Method dbbCleanerMethod = directByteBufferClass.getMethod("cleaner", new Class[0]);
                            dbbCleanerMethod.setAccessible(true);
                            Object cleaner = dbbCleanerMethod.invoke((Object)buffer, new Object[0]);
                            if (cleaner != null) {
                                Class<?> cleanerMethodReturnType = dbbCleanerMethod.getReturnType();
                                Method cleanMethod = cleanerMethodReturnType.getDeclaredMethod("clean", new Class[0]);
                                cleanMethod.setAccessible(true);
                                cleanMethod.invoke(cleaner, new Object[0]);
                            }
                        }
                        catch (NoSuchMethodException ex2) {
                            if (Constants.ANDROID) {
                                Helper.callBufferFree(buffer, directByteBufferClass);
                            }
                            LOGGER.warn("NoSuchMethodException | " + Constants.JAVA_VERSION, ex2);
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Unable to unmap the mapped buffer", e);
        }
    }

    private static void callBufferFree(ByteBuffer buffer, Class<?> directByteBufferClass) throws InvocationTargetException, IllegalAccessException {
        try {
            Method dbbFreeMethod = directByteBufferClass.getMethod("free", new Class[0]);
            dbbFreeMethod.setAccessible(true);
            dbbFreeMethod.invoke((Object)buffer, new Object[0]);
        }
        catch (NoSuchMethodException ex2) {
            LOGGER.warn("NoSuchMethodException | " + Constants.JAVA_VERSION, ex2);
        }
    }

    public static void cleanHack() {
        System.gc();
    }

    public static String nf(long no) {
        return NumberFormat.getInstance(Locale.FRANCE).format(no);
    }

    public static String firstBig(String sayText) {
        if (sayText == null || sayText.length() <= 0) {
            return sayText;
        }
        return String.valueOf(Character.toUpperCase(sayText.charAt(0))) + sayText.substring(1);
    }

    public static final double keepIn(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double round(double value, int exponent) {
        double factor = Math.pow(10.0, exponent);
        return (double)Math.round(value * factor) / factor;
    }

    public static final double round6(double value) {
        return (double)Math.round(value * 1000000.0) / 1000000.0;
    }

    public static final double round4(double value) {
        return (double)Math.round(value * 10000.0) / 10000.0;
    }

    public static final double round2(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static DateFormat createFormatter() {
        return Helper.createFormatter("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public static DateFormat createFormatter(String str) {
        SimpleDateFormat df = new SimpleDateFormat(str, Locale.UK);
        df.setTimeZone(UTC);
        return df;
    }

    public static final long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static final int toSignedInt(long x) {
        return (int)x;
    }

    public static final String camelCaseToUnderScore(String key) {
        if (key.isEmpty()) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key.length());
        int i = 0;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append("_").append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String underScoreToCamelCase(String key) {
        if (key.isEmpty()) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key.length());
        int i = 0;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (c == '_') {
                if (++i < key.length()) {
                    sb.append(Character.toUpperCase(key.charAt(i)));
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

