/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.NotThreadSafe;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

@NotThreadSafe
public class UnsafeDataAccess
extends AbstractDataAccess {
    static final Unsafe UNSAFE;
    private long address;
    private long capacity;

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    UnsafeDataAccess(String name, String location, ByteOrder order) {
        super(name, location, order);
    }

    @Override
    public UnsafeDataAccess create(long bytes) {
        this.setSegmentSize(this.segmentSizeInBytes);
        this.ensureCapacity(bytes);
        return this;
    }

    @Override
    public final boolean ensureCapacity(long bytes) {
        return this.ensureCapacity(bytes, true);
    }

    final boolean ensureCapacity(long bytes, boolean clearNewMem) {
        long oldCap = this.getCapacity();
        long newBytes = bytes - oldCap;
        if (newBytes <= 0L) {
            return false;
        }
        int allSegments = (int)(bytes / (long)this.segmentSizeInBytes);
        if (bytes % (long)this.segmentSizeInBytes != 0L) {
            ++allSegments;
        }
        this.capacity = allSegments * this.segmentSizeInBytes;
        try {
            this.address = UNSAFE.reallocateMemory(this.address, this.capacity);
        }
        catch (OutOfMemoryError err) {
            throw new OutOfMemoryError(String.valueOf(err.getMessage()) + " - problem when allocating new memory. Old capacity: " + oldCap + ", new bytes:" + newBytes + ", segmentSizeIntsPower:" + this.segmentSizePower);
        }
        if (clearNewMem) {
            UNSAFE.setMemory(this.address + oldCap, this.capacity - oldCap, (byte)0);
        }
        return true;
    }

    @Override
    public DataAccess copyTo(DataAccess da) {
        boolean cfr_ignored_0 = da instanceof UnsafeDataAccess;
        return super.copyTo(da);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadExisting() {
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        File file = new File(this.getFullName());
        if (!file.exists()) return false;
        if (file.length() == 0L) {
            return false;
        }
        try (RandomAccessFile raFile = new RandomAccessFile(this.getFullName(), "r");){
            long byteCount = this.readHeader(raFile) - 100L;
            if (byteCount < 0L) {
                return false;
            }
            raFile.seek(100L);
            int segmentCount = (int)(byteCount / (long)this.segmentSizeInBytes);
            if (byteCount % (long)this.segmentSizeInBytes != 0L) {
                ++segmentCount;
            }
            this.ensureCapacity(byteCount, false);
            byte[] bytes = new byte[this.segmentSizeInBytes];
            int s = 0;
            while (true) {
                if (s >= segmentCount) {
                    return true;
                }
                int read = raFile.read(bytes);
                if (read <= 0) {
                    throw new IllegalStateException("segment " + s + " is empty? " + this.toString());
                }
                this.setBytes(s * this.segmentSizeInBytes, bytes, this.segmentSizeInBytes);
                ++s;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Problem while loading " + this.getFullName(), ex);
        }
    }

    @Override
    public void flush() {
        if (this.isClosed()) {
            throw new IllegalStateException("already closed");
        }
        try (RandomAccessFile raFile = new RandomAccessFile(this.getFullName(), "rw");){
            long len = this.getCapacity();
            this.writeHeader(raFile, len, this.segmentSizeInBytes);
            raFile.seek(100L);
            byte[] bytes = new byte[this.segmentSizeInBytes];
            int segs = this.getSegments();
            int s = 0;
            while (s < segs) {
                this.getBytes(s * this.segmentSizeInBytes, bytes, this.segmentSizeInBytes);
                raFile.write(bytes);
                ++s;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't store bytes to " + this.toString(), ex);
        }
    }

    @Override
    public void close() {
        super.close();
        UNSAFE.freeMemory(this.address);
    }

    @Override
    public final void setInt(long bytePos, int value) {
        UNSAFE.putInt(this.address + bytePos, value);
    }

    @Override
    public final int getInt(long bytePos) {
        return UNSAFE.getInt(this.address + bytePos);
    }

    @Override
    public short getShort(long bytePos) {
        return UNSAFE.getShort(this.address + bytePos);
    }

    @Override
    public void setShort(long bytePos, short value) {
        UNSAFE.putShort(this.address + bytePos, value);
    }

    @Override
    public final void setBytes(long bytePos, byte[] values, int length) {
        int offset = 0;
        while (offset < length) {
            UNSAFE.putByte(this.address + bytePos + (long)offset, values[offset]);
            ++offset;
        }
    }

    @Override
    public final void getBytes(long bytePos, byte[] values, int length) {
        assert (length <= this.segmentSizeInBytes) : "the length has to be smaller or equal to the segment size: " + length + " vs. " + this.segmentSizeInBytes;
        int offset = 0;
        while (offset < length) {
            values[offset] = UNSAFE.getByte(this.address + bytePos + (long)offset);
            ++offset;
        }
    }

    @Override
    public final long getCapacity() {
        return this.capacity;
    }

    @Override
    public final int getSegments() {
        return (int)(this.capacity / (long)this.segmentSizeInBytes);
    }

    @Override
    public final void trimTo(long bytes) {
        if (bytes > this.capacity) {
            throw new IllegalStateException("Use ensureCapacity to increase capacity!");
        }
        int allSegments = (int)(bytes / (long)this.segmentSizeInBytes);
        if (bytes % (long)this.segmentSizeInBytes != 0L) {
            ++allSegments;
        }
        if (allSegments <= 0) {
            allSegments = 1;
        }
        this.capacity = allSegments * this.segmentSizeInBytes;
    }

    @Override
    public DAType getType() {
        return DAType.UNSAFE_STORE;
    }
}

