/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;

public class PriorityWeighting
extends FastestWeighting {
    public static final int KEY = 101;
    private final double minFactor;

    public PriorityWeighting(FlagEncoder encoder) {
        this(encoder, new PMap(0));
    }

    public PriorityWeighting(FlagEncoder encoder, PMap pMap) {
        super(encoder, pMap);
        double maxPriority = 1.0;
        this.minFactor = 1.0 / (0.5 + maxPriority);
    }

    @Override
    public double getMinWeight(double distance) {
        return this.minFactor * super.getMinWeight(distance);
    }

    @Override
    public double calcWeight(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double weight = super.calcWeight(edgeState, reverse, prevOrNextEdgeId);
        if (Double.isInfinite(weight)) {
            return Double.POSITIVE_INFINITY;
        }
        return weight / (0.5 + this.flagEncoder.getDouble(edgeState.getFlags(), 101));
    }
}

