/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;

public abstract class AbstractAdjustedWeighting
implements Weighting {
    protected final Weighting superWeighting;

    public AbstractAdjustedWeighting(Weighting superWeighting) {
        if (superWeighting == null) {
            throw new IllegalArgumentException("No super weighting set");
        }
        this.superWeighting = superWeighting;
    }

    @Override
    public long calcMillis(EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        return this.superWeighting.calcMillis(edgeState, reverse, prevOrNextEdgeId);
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.superWeighting.getFlagEncoder();
    }

    @Override
    public boolean matches(HintsMap reqMap) {
        return this.getName().equals(reqMap.getWeighting()) && this.superWeighting.getFlagEncoder().toString().equals(reqMap.getVehicle());
    }

    public String toString() {
        return String.valueOf(this.getName()) + "|" + this.superWeighting.toString();
    }
}

