/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.spatialrules;

import com.graphhopper.json.geo.JsonFeature;
import com.graphhopper.json.geo.JsonFeatureCollection;
import com.graphhopper.routing.util.spatialrules.Polygon;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookupArray;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRuleLookupBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SpatialRuleLookupBuilder.class);

    public static SpatialRuleLookup buildIndex(JsonFeatureCollection jsonFeatureCollection, String jsonIdField, SpatialRuleFactory spatialRuleFactory, double resolution, BBox maxBBox) {
        BBox polygonBounds = BBox.createInverse(false);
        ArrayList<SpatialRule> spatialRules = new ArrayList<SpatialRule>();
        int jsonFeatureIdx = 0;
        while (jsonFeatureIdx < jsonFeatureCollection.getFeatures().size()) {
            String id;
            JsonFeature jsonFeature = jsonFeatureCollection.getFeatures().get(jsonFeatureIdx);
            String string = id = jsonIdField.isEmpty() || Helper.toLowerCase(jsonIdField).equals("id") ? jsonFeature.getId() : (String)jsonFeature.getProperty(jsonIdField);
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("ID cannot be empty but was for JsonFeature " + jsonFeatureIdx);
            }
            ArrayList<Polygon> borders = new ArrayList<Polygon>();
            int i = 0;
            while (i < jsonFeature.getGeometry().getNumGeometries()) {
                Geometry poly = jsonFeature.getGeometry().getGeometryN(i);
                if (!(poly instanceof com.vividsolutions.jts.geom.Polygon)) {
                    throw new IllegalArgumentException("Geometry for " + id + " (" + i + ") not supported " + poly.getClass().getSimpleName());
                }
                borders.add(Polygon.create((com.vividsolutions.jts.geom.Polygon)poly));
                ++i;
            }
            SpatialRule spatialRule = spatialRuleFactory.createSpatialRule(id, borders);
            if (spatialRule != SpatialRule.EMPTY) {
                spatialRules.add(spatialRule);
                for (Polygon polygon : spatialRule.getBorders()) {
                    polygonBounds.update(polygon.getMinLat(), polygon.getMinLon());
                    polygonBounds.update(polygon.getMaxLat(), polygon.getMaxLon());
                }
            }
            ++jsonFeatureIdx;
        }
        if (!polygonBounds.isValid()) {
            return SpatialRuleLookup.EMPTY;
        }
        BBox calculatedBounds = polygonBounds.calculateIntersection(maxBBox);
        if (calculatedBounds == null) {
            return SpatialRuleLookup.EMPTY;
        }
        SpatialRuleLookupArray spatialRuleLookup = new SpatialRuleLookupArray(spatialRules, resolution, true, calculatedBounds);
        logger.info("Created the SpatialRuleLookup with the following rules: " + Arrays.toString(spatialRules.toArray()));
        return spatialRuleLookup;
    }

    public static SpatialRuleLookup buildIndex(JsonFeatureCollection jsonFeatureCollection, String jsonIdField, SpatialRuleFactory spatialRuleFactory) {
        return SpatialRuleLookupBuilder.buildIndex(jsonFeatureCollection, jsonIdField, spatialRuleFactory, 0.1, new BBox(-180.0, 180.0, -90.0, 90.0));
    }

    public static interface SpatialRuleFactory {
        public SpatialRule createSpatialRule(String var1, List<Polygon> var2);
    }
}

