/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.PathWrapper;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostExtension;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TestAlgoCollector {
    public final List<String> errors = new ArrayList<String>();
    private final String name;
    private final DistanceCalc distCalc = Helper.DIST_EARTH;
    private final TranslationMap trMap = new TranslationMap().doImport();

    public TestAlgoCollector(String name) {
        this.name = name;
    }

    public TestAlgoCollector assertDistance(AlgoHelperEntry algoEntry, List<QueryResult> queryList, OneRun oneRun) {
        ArrayList<Path> altPaths = new ArrayList<Path>();
        QueryGraph queryGraph = new QueryGraph(algoEntry.getForQueryGraph());
        queryGraph.lookup(queryList);
        AlgorithmOptions opts = algoEntry.getAlgorithmOptions();
        FlagEncoder encoder = opts.getWeighting().getFlagEncoder();
        if (encoder.supports(TurnWeighting.class)) {
            if (!opts.getTraversalMode().isEdgeBased()) {
                this.errors.add("Cannot use TurnWeighting with a node based traversal");
                return this;
            }
            algoEntry.setAlgorithmOptions(AlgorithmOptions.start(opts).weighting(new TurnWeighting(opts.getWeighting(), (TurnCostExtension)queryGraph.getExtension())).build());
        }
        RoutingAlgorithmFactory factory = algoEntry.createRoutingFactory();
        int i = 0;
        while (i < queryList.size() - 1) {
            RoutingAlgorithm algo = factory.createAlgo(queryGraph, algoEntry.getAlgorithmOptions());
            Path path = algo.calcPath(queryList.get(i).getClosestNode(), queryList.get(i + 1).getClosestNode());
            altPaths.add(path);
            ++i;
        }
        PathMerger pathMerger = new PathMerger().setCalcPoints(true).setSimplifyResponse(false).setEnableInstructions(true);
        PathWrapper rsp = new PathWrapper();
        pathMerger.doWork(rsp, altPaths, this.trMap.getWithFallBack(Locale.US));
        if (rsp.hasErrors()) {
            this.errors.add("response for " + algoEntry + " contains errors. Expected distance: " + oneRun.getDistance() + ", expected points: " + oneRun + ". " + queryList + ", errors:" + rsp.getErrors());
            return this;
        }
        PointList pointList = rsp.getPoints();
        double tmpDist = pointList.calcDistance(this.distCalc);
        if (Math.abs(rsp.getDistance() - tmpDist) > 2.0) {
            this.errors.add(algoEntry + " path.getDistance was  " + rsp.getDistance() + "\t pointList.calcDistance was " + tmpDist + "\t (expected points " + oneRun.getLocs() + ", expected distance " + oneRun.getDistance() + ") " + queryList);
        }
        if (Math.abs(rsp.getDistance() - oneRun.getDistance()) > 2.0) {
            this.errors.add(algoEntry + " returns path not matching the expected distance of " + oneRun.getDistance() + "\t Returned was " + rsp.getDistance() + "\t (expected points " + oneRun.getLocs() + ", was " + pointList.getSize() + ") " + queryList);
        }
        if (Math.abs(pointList.getSize() - oneRun.getLocs()) > 1) {
            this.errors.add(algoEntry + " returns path not matching the expected points of " + oneRun.getLocs() + "\t Returned was " + pointList.getSize() + "\t (expected distance " + oneRun.getDistance() + ", was " + rsp.getDistance() + ") " + queryList);
        }
        return this;
    }

    void queryIndex(Graph g, LocationIndex idx, double lat, double lon, double expectedDist) {
        QueryResult res = idx.findClosest(lat, lon, EdgeFilter.ALL_EDGES);
        if (!res.isValid()) {
            this.errors.add("node not found for " + lat + "," + lon);
            return;
        }
        GHPoint3D found = res.getSnappedPoint();
        double dist = this.distCalc.calcDist(lat, lon, found.lat, found.lon);
        if (Math.abs(dist - expectedDist) > 0.1) {
            this.errors.add("queried lat,lon=" + (float)lat + "," + (float)lon + " (found: " + (float)found.lat + "," + (float)found.lon + ")" + "\n   expected distance:" + expectedDist + ", but was:" + dist);
        }
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + "FOUND " + this.errors.size() + " ERRORS.\n";
        for (String s : this.errors) {
            str = String.valueOf(str) + s + ".\n";
        }
        return str;
    }

    void printSummary() {
        if (this.errors.size() > 0) {
            System.out.println("\n-------------------------------\n");
            System.out.println(this.toString());
        } else {
            System.out.println("SUCCESS for " + this.name + "!");
        }
    }

    public static class AlgoHelperEntry {
        private final LocationIndex idx;
        private Graph forQueryGraph;
        private String expectedAlgo;
        private AlgorithmOptions opts;

        public AlgoHelperEntry(Graph g, AlgorithmOptions opts, LocationIndex idx, String expectedAlgo) {
            this.forQueryGraph = g;
            this.opts = opts;
            this.idx = idx;
            this.expectedAlgo = expectedAlgo;
        }

        public Graph getForQueryGraph() {
            return this.forQueryGraph;
        }

        public void setAlgorithmOptions(AlgorithmOptions opts) {
            this.opts = opts;
        }

        public RoutingAlgorithmFactory createRoutingFactory() {
            return new RoutingAlgorithmFactorySimple();
        }

        public AlgorithmOptions getAlgorithmOptions() {
            return this.opts;
        }

        public LocationIndex getIdx() {
            return this.idx;
        }

        public String getExpectedAlgo() {
            return this.expectedAlgo;
        }

        public String toString() {
            String algo = this.opts.getAlgorithm();
            if (this.getExpectedAlgo().contains("landmarks")) {
                algo = String.valueOf(algo) + "|landmarks";
            }
            if (this.forQueryGraph instanceof CHGraph) {
                algo = String.valueOf(algo) + "|ch";
            }
            return "algoEntry(" + algo + ")";
        }
    }

    static class AssumptionPerPath {
        double lat;
        double lon;
        int locs;
        double distance;

        public AssumptionPerPath(double lat, double lon, double distance, int locs) {
            this.lat = lat;
            this.lon = lon;
            this.locs = locs;
            this.distance = distance;
        }

        public String toString() {
            return String.valueOf(this.lat) + ", " + this.lon + ", locs:" + this.locs + ", dist:" + this.distance;
        }
    }

    public static class OneRun {
        private final List<AssumptionPerPath> assumptions = new ArrayList<AssumptionPerPath>();

        public OneRun() {
        }

        public OneRun(double fromLat, double fromLon, double toLat, double toLon, double dist, int locs) {
            this.add(fromLat, fromLon, 0.0, 0);
            this.add(toLat, toLon, dist, locs);
        }

        public OneRun add(double lat, double lon, double dist, int locs) {
            this.assumptions.add(new AssumptionPerPath(lat, lon, dist, locs));
            return this;
        }

        public int getLocs() {
            int sum = 0;
            for (AssumptionPerPath as : this.assumptions) {
                sum += as.locs;
            }
            return sum;
        }

        public void setLocs(int index, int locs) {
            this.assumptions.get((int)index).locs = locs;
        }

        public double getDistance() {
            double sum = 0.0;
            for (AssumptionPerPath as : this.assumptions) {
                sum += as.distance;
            }
            return sum;
        }

        public void setDistance(int index, double dist) {
            this.assumptions.get((int)index).distance = dist;
        }

        public List<QueryResult> getList(LocationIndex idx, EdgeFilter edgeFilter) {
            ArrayList<QueryResult> qr = new ArrayList<QueryResult>();
            for (AssumptionPerPath p : this.assumptions) {
                qr.add(idx.findClosest(p.lat, p.lon, edgeFilter));
            }
            return qr;
        }

        public String toString() {
            return this.assumptions.toString();
        }
    }
}

