/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.apache.commons.lang3.StringUtils;
import com.graphhopper.debatty.java.stringsimilarity.JaroWinkler;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NameSimilarityEdgeFilter
implements EdgeFilter {
    private static final Pattern NON_WORD_CHAR = Pattern.compile("[^\\p{L}]+");
    private final double JARO_WINKLER_ACCEPT_FACTOR = 0.79;
    private final JaroWinkler jaroWinkler = new JaroWinkler();
    private final EdgeFilter edgeFilter;
    private final String pointHint;

    public NameSimilarityEdgeFilter(EdgeFilter edgeFilter, String pointHint) {
        this.edgeFilter = edgeFilter;
        this.pointHint = this.prepareName(pointHint == null ? "" : pointHint);
    }

    private String prepareName(String name) {
        String[] arr = name.split("\\s");
        ArrayList<String> list = new ArrayList<String>(arr.length);
        int i = 0;
        while (i < arr.length) {
            String tmp = NON_WORD_CHAR.matcher(Helper.toLowerCase(arr[i])).replaceAll("");
            if (!tmp.isEmpty() && tmp.length() > 3) {
                list.add(tmp);
            }
            ++i;
        }
        return this.listToString(list);
    }

    private String removeRelation(String edgeName) {
        if (edgeName != null && edgeName.contains(", ")) {
            edgeName = edgeName.substring(0, edgeName.lastIndexOf(44));
        }
        return edgeName;
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        if (!this.edgeFilter.accept(iter)) {
            return false;
        }
        if (this.pointHint.isEmpty()) {
            return true;
        }
        String name = iter.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        name = this.removeRelation(name);
        String edgeName = this.prepareName(name);
        return this.isJaroWinklerSimilar(this.pointHint, edgeName);
    }

    private boolean isJaroWinklerSimilar(String str1, String str2) {
        double jwSimilarity = this.jaroWinkler.similarity(str1, str2);
        return jwSimilarity > 0.79;
    }

    private final String listToString(List<String> list) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            b.append(list.get(i));
            ++i;
        }
        return b.toString();
    }

    private boolean isLevenshteinSimilar(String hint, String name) {
        if (Math.min(name.length(), hint.length()) * 4 < Math.max(name.length(), hint.length())) {
            return false;
        }
        int factor = 1 + Math.abs(hint.length() - name.length());
        int levDistance = StringUtils.getLevenshteinDistance(hint, name);
        return levDistance <= factor;
    }
}

