/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.FlagEncoderFactory;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class EncodingManager {
    private static final String ERR = "Encoders are requesting %s bits, more than %s bits of %s flags. ";
    private static final String WAY_ERR = "Decrease the number of vehicles or increase the flags to take long via graph.bytes_for_flags=8";
    private final List<AbstractFlagEncoder> edgeEncoders = new ArrayList<AbstractFlagEncoder>();
    private final int bitsForEdgeFlags;
    private final int bitsForTurnFlags = 32;
    private int nextWayBit = 0;
    private int nextNodeBit = 0;
    private int nextRelBit = 0;
    private int nextTurnBit = 0;
    private boolean enableInstructions = true;
    private String preferredLanguage = "";

    public EncodingManager(String flagEncodersStr) {
        this(flagEncodersStr, 4);
    }

    public EncodingManager(String flagEncodersStr, int bytesForEdgeFlags) {
        this(FlagEncoderFactory.DEFAULT, flagEncodersStr, bytesForEdgeFlags);
    }

    public EncodingManager(FlagEncoderFactory factory, String flagEncodersStr, int bytesForEdgeFlags) {
        this(EncodingManager.parseEncoderString(factory, flagEncodersStr), bytesForEdgeFlags);
    }

    public EncodingManager(FlagEncoder ... flagEncoders) {
        this(Arrays.asList(flagEncoders));
    }

    public EncodingManager(List<? extends FlagEncoder> flagEncoders) {
        this(flagEncoders, 4);
    }

    public EncodingManager(List<? extends FlagEncoder> flagEncoders, int bytesForEdgeFlags) {
        if (bytesForEdgeFlags != 4 && bytesForEdgeFlags != 8) {
            throw new IllegalStateException("For 'edge flags' currently only 4 or 8 bytes supported");
        }
        this.bitsForEdgeFlags = bytesForEdgeFlags * 8;
        for (FlagEncoder flagEncoder : flagEncoders) {
            this.registerEncoder((AbstractFlagEncoder)flagEncoder);
        }
        if (this.edgeEncoders.isEmpty()) {
            throw new IllegalStateException("No vehicles found");
        }
    }

    static List<FlagEncoder> parseEncoderString(FlagEncoderFactory factory, String encoderList) {
        if (encoderList.contains(":")) {
            throw new IllegalArgumentException("EncodingManager does no longer use reflection instantiate encoders directly.");
        }
        if (!encoderList.equals(Helper.toLowerCase(encoderList))) {
            throw new IllegalArgumentException("Since 0.7 EncodingManager does no longer accept upper case profiles: " + encoderList);
        }
        String[] entries = encoderList.split(",");
        ArrayList<FlagEncoder> resultEncoders = new ArrayList<FlagEncoder>();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (!(entry = Helper.toLowerCase(entry.trim())).isEmpty()) {
                String entryVal = "";
                if (entry.contains("|")) {
                    entryVal = entry;
                    entry = entry.split("\\|")[0];
                }
                PMap configuration = new PMap(entryVal);
                FlagEncoder fe = factory.createFlagEncoder(entry, configuration);
                if (configuration.has("version") && fe.getVersion() != configuration.getInt("version", -1)) {
                    throw new IllegalArgumentException("Encoder " + entry + " was used in version " + configuration.getLong("version", -1L) + ", but current version is " + fe.getVersion());
                }
                resultEncoders.add(fe);
            }
            ++n2;
        }
        return resultEncoders;
    }

    static String fixWayName(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll(";[ ]*", ", ");
    }

    public static EncodingManager create(FlagEncoderFactory factory, String ghLoc) {
        RAMDirectory dir = new RAMDirectory(ghLoc, true);
        StorableProperties properties = new StorableProperties(dir);
        if (!properties.loadExisting()) {
            throw new IllegalStateException("Cannot load properties to fetch EncodingManager configuration at: " + dir.getLocation());
        }
        properties.checkVersions(false);
        String acceptStr = properties.get("graph.flag_encoders");
        if (acceptStr.isEmpty()) {
            throw new IllegalStateException("EncodingManager was not configured. And no one was found in the graph: " + dir.getLocation());
        }
        int bytesForFlags = 4;
        if ("8".equals(properties.get("graph.bytes_for_flags"))) {
            bytesForFlags = 8;
        }
        return new EncodingManager(factory, acceptStr, bytesForFlags);
    }

    public int getBytesForFlags() {
        return this.bitsForEdgeFlags / 8;
    }

    private void registerEncoder(AbstractFlagEncoder encoder) {
        if (encoder.isRegistered()) {
            throw new IllegalStateException("You must not register a FlagEncoder (" + encoder.toString() + ") twice!");
        }
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.toString().equals(encoder.toString())) continue;
            throw new IllegalArgumentException("Cannot register edge encoder. Name already exists: " + flagEncoder.toString());
        }
        encoder.setRegistered(true);
        int n = this.edgeEncoders.size();
        int usedBits = encoder.defineNodeBits(n, this.nextNodeBit);
        if (usedBits > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, usedBits, this.bitsForEdgeFlags, "node"));
        }
        encoder.setNodeBitMask(usedBits - this.nextNodeBit, this.nextNodeBit);
        this.nextNodeBit = usedBits;
        usedBits = encoder.defineWayBits(n, this.nextWayBit);
        if (usedBits > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.valueOf(String.format(Locale.ROOT, ERR, usedBits, this.bitsForEdgeFlags, "way")) + WAY_ERR);
        }
        encoder.setWayBitMask(usedBits - this.nextWayBit, this.nextWayBit);
        this.nextWayBit = usedBits;
        usedBits = encoder.defineRelationBits(n, this.nextRelBit);
        if (usedBits > this.bitsForEdgeFlags) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, usedBits, this.bitsForEdgeFlags, "relation"));
        }
        encoder.setRelBitMask(usedBits - this.nextRelBit, this.nextRelBit);
        this.nextRelBit = usedBits;
        usedBits = encoder.defineTurnBits(n, this.nextTurnBit);
        if (usedBits > 32) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, ERR, usedBits, 32, "turn"));
        }
        this.nextTurnBit = usedBits;
        this.edgeEncoders.add(encoder);
    }

    public boolean supports(String encoder) {
        return this.getEncoder(encoder, false) != null;
    }

    public FlagEncoder getEncoder(String name) {
        return this.getEncoder(name, true);
    }

    private FlagEncoder getEncoder(String name, boolean throwExc) {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!name.equalsIgnoreCase(flagEncoder.toString())) continue;
            return flagEncoder;
        }
        if (throwExc) {
            throw new IllegalArgumentException("Encoder for " + name + " not found. Existing: " + this.toDetailsString());
        }
        return null;
    }

    public long acceptWay(ReaderWay way) {
        long includeWay = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            includeWay |= encoder.acceptWay(way);
        }
        return includeWay;
    }

    public long handleRelationTags(ReaderRelation relation, long oldRelationFlags) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleRelationTags(relation, oldRelationFlags);
        }
        return flags;
    }

    public long handleWayTags(ReaderWay way, long includeWay, long relationFlags) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleWayTags(way, includeWay, relationFlags & encoder.getRelBitMask());
        }
        return flags;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(flagEncoder.toString());
        }
        return str.toString();
    }

    public String toDetailsString() {
        StringBuilder str = new StringBuilder();
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(encoder.toString()).append("|").append(encoder.getPropertiesString()).append("|version=").append(encoder.getVersion());
        }
        return str.toString();
    }

    public long flagsDefault(boolean forward, boolean backward) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.flagsDefault(forward, backward);
        }
        return flags;
    }

    public long reverseFlags(long flags) {
        int len = this.edgeEncoders.size();
        int i = 0;
        while (i < len) {
            flags = this.edgeEncoders.get(i).reverseFlags(flags);
            ++i;
        }
        return flags;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.edgeEncoders != null ? this.edgeEncoders.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncodingManager other = (EncodingManager)obj;
        return this.edgeEncoders == other.edgeEncoders || this.edgeEncoders != null && this.edgeEncoders.equals(other.edgeEncoders);
    }

    public long handleNodeTags(ReaderNode node) {
        long flags = 0L;
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            flags |= encoder.handleNodeTags(node);
        }
        return flags;
    }

    public EncodingManager setEnableInstructions(boolean enableInstructions) {
        this.enableInstructions = enableInstructions;
        return this;
    }

    public EncodingManager setPreferredLanguage(String preferredLanguage) {
        if (preferredLanguage == null) {
            throw new IllegalArgumentException("preferred language cannot be null");
        }
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        if (this.enableInstructions) {
            String refName;
            String name = "";
            if (!this.preferredLanguage.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name:" + this.preferredLanguage));
            }
            if (name.isEmpty()) {
                name = EncodingManager.fixWayName(way.getTag("name"));
            }
            if (!(refName = EncodingManager.fixWayName(way.getTag("ref"))).isEmpty()) {
                name = name.isEmpty() ? refName : String.valueOf(name) + ", " + refName;
            }
            edge.setName(name);
        }
        for (AbstractFlagEncoder encoder : this.edgeEncoders) {
            encoder.applyWayTags(way, edge);
        }
    }

    public List<FlagEncoder> fetchEdgeEncoders() {
        ArrayList<FlagEncoder> list = new ArrayList<FlagEncoder>();
        list.addAll(this.edgeEncoders);
        return list;
    }

    public boolean needsTurnCostsSupport() {
        for (FlagEncoder flagEncoder : this.edgeEncoders) {
            if (!flagEncoder.supports(TurnWeighting.class)) continue;
            return true;
        }
        return false;
    }
}

